/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.tools;

import ij.ImagePlus;
import ij.measure.Calibration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

class PathImagePlus
implements PathImage<ImagePlus> {
    private static final Logger logger = LoggerFactory.getLogger(PathImagePlus.class);
    private transient ImagePlus imp = null;
    private RegionRequest request;
    private PixelCalibration calibration;

    PathImagePlus(RegionRequest request, ImagePlus imp) {
        this.request = request;
        this.imp = imp;
        logger.trace("Creating PathImage for {} and request {}", (Object)imp, (Object)request);
    }

    public double getDownsampleFactor() {
        return this.request.getDownsample();
    }

    public ImagePlus getImage() {
        return this.imp;
    }

    public PixelCalibration getPixelCalibration() {
        if (this.calibration == null) {
            PixelCalibration.Builder builder = new PixelCalibration.Builder();
            Calibration cal = this.getImage().getCalibration();
            if (PathImagePlus.isMicrons(cal.getXUnit()) && PathImagePlus.isMicrons(cal.getYUnit())) {
                builder.pixelSizeMicrons((Number)cal.pixelWidth, (Number)cal.pixelHeight);
            }
            if (PathImagePlus.isMicrons(cal.getZUnit())) {
                builder.zSpacingMicrons((Number)cal.pixelDepth);
            }
            this.calibration = builder.build();
        }
        return this.calibration;
    }

    private static boolean isMicrons(String unit) {
        if (unit == null) {
            return false;
        }
        return (unit = unit.toLowerCase()).startsWith(GeneralTools.micrometerSymbol()) || unit.equals("um") || unit.startsWith("micron");
    }

    public ImageRegion getImageRegion() {
        return this.request;
    }
}

