/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.tools;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.CompositeConverter;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.IJProcessing;
import qupath.imagej.tools.IJProperties;
import qupath.imagej.tools.PathImagePlus;
import qupath.imagej.tools.ROIConverterIJ;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleImages;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.PolylineROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

public class IJTools {
    private static final Logger logger = LoggerFactory.getLogger(IJTools.class);
    private static List<String> micronList = Arrays.asList("micron", "microns", "um", GeneralTools.micrometerSymbol());
    private static double MEMORY_THRESHOLD = 0.5;

    public static void setMemoryThreshold(double threshold) {
        double new_threshold = threshold > 1.0 ? 1.0 : threshold;
        MEMORY_THRESHOLD = new_threshold = threshold < 0.0 ? 0.1 : new_threshold;
    }

    public static boolean isMemorySufficient(RegionRequest region, ImageData<BufferedImage> imageData) throws Exception {
        ImageServer server = imageData.getServer();
        int bytesPerPixel = server.isRGB() ? 4 : server.getPixelType().getBytesPerPixel() * server.nChannels();
        double regionWidth = (double)region.getWidth() / region.getDownsample();
        double regionHeight = (double)region.getHeight() / region.getDownsample();
        double approxPixelCount = regionWidth * regionHeight;
        Runtime.getRuntime().gc();
        long approxMemory = (long)approxPixelCount * (long)bytesPerPixel;
        long allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long presumableFreeMemory = Runtime.getRuntime().maxMemory() - allocatedMemory;
        DecimalFormat df = new DecimalFormat("00.00");
        if (approxPixelCount > 2.14748E9) {
            throw new Exception("ImageJ cannot handle images this big (" + (int)regionWidth + "x" + (int)regionHeight + " pixels).\nTry again with a smaller region, or a higher downsample factor.");
        }
        if ((double)approxMemory > (double)presumableFreeMemory * MEMORY_THRESHOLD) {
            throw new Exception("There is not enough free memory to open this region in ImageJ\nImage memory requirement: " + df.format(approxMemory / 0x100000L) + "MB\nAvailable Memory: " + df.format((double)presumableFreeMemory / 1048576.0 * MEMORY_THRESHOLD) + "MB\n\nTry again with a smaller region, or a higher downsample factor,or modify the memory threshold using IJTools.setMemoryThreshold(double threshold)");
        }
        return (double)approxMemory > (double)presumableFreeMemory * MEMORY_THRESHOLD;
    }

    public static ImagePlus extractHyperstack(ImageServer<BufferedImage> server, RegionRequest request) throws IOException {
        return IJTools.extractHyperstack(server, request, 0, server.nZSlices(), 0, server.nTimepoints());
    }

    public static ImagePlus extractHyperstack(ImageServer<BufferedImage> server, RegionRequest request, int zStart, int zEnd, int tStart, int tEnd) throws IOException {
        if (request == null) {
            request = RegionRequest.createInstance(server);
        }
        int nChannels = -1;
        int nZ = zEnd - zStart;
        int nT = tEnd - tStart;
        double downsample = request.getDownsample();
        ImageStack stack = null;
        Calibration cal = null;
        for (int t = tStart; t < tEnd; ++t) {
            for (int z = zStart; z < zEnd; ++z) {
                RegionRequest request2 = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (int)request.getX(), (int)request.getY(), (int)request.getWidth(), (int)request.getHeight(), (int)z, (int)t);
                ImagePlus imp = (ImagePlus)IJTools.convertToImagePlus(server, request2).getImage();
                if (stack == null) {
                    stack = new ImageStack(imp.getWidth(), imp.getHeight());
                }
                for (int i = 1; i <= imp.getStack().getSize(); ++i) {
                    stack.addSlice(imp.getStack().getSliceLabel(i), imp.getStack().getProcessor(i));
                }
                cal = imp.getCalibration();
                nChannels = imp.getNChannels();
            }
        }
        PixelCalibration pixelCalibration = server.getPixelCalibration();
        if (cal != null && !Double.isNaN(pixelCalibration.getZSpacingMicrons())) {
            cal.pixelDepth = pixelCalibration.getZSpacingMicrons();
            cal.setZUnit("um");
        }
        String name = ServerTools.getDisplayableImageName(server);
        ImagePlus imp = new ImagePlus(name, stack);
        CompositeImage impComp = null;
        if (imp.getType() != 4 && nChannels > 1) {
            impComp = new CompositeImage(imp, 1);
            imp = impComp;
        }
        imp.setCalibration(cal);
        imp.setDimensions(nChannels, nZ, nT);
        if (impComp != null) {
            for (int c = 0; c < nChannels; ++c) {
                impComp.setChannelLut(LUT.createLutFromColor((Color)ColorToolsAwt.getCachedColor((Integer)server.getChannel(c).getColor())), c + 1);
            }
        }
        return imp;
    }

    public static ImageProcessor convertToFloatProcessor(SimpleImage image) {
        float[] pixels = SimpleImages.getPixels((SimpleImage)image, (boolean)false);
        return new FloatProcessor(image.getWidth(), image.getHeight(), pixels);
    }

    public static void setTitleFromObject(PathImage<ImagePlus> pathImage, PathObject pathObject) {
        if (pathImage == null || pathObject == null) {
            return;
        }
        if ((pathObject.isTMACore() || pathObject.isAnnotation()) && (pathObject.getName() != null || pathObject.getPathClass() != null)) {
            ((ImagePlus)pathImage.getImage()).setTitle(pathObject.getDisplayedName());
        }
    }

    public static void calibrateImagePlus(ImagePlus imp, RegionRequest request, ImageServer<BufferedImage> server) {
        double pixelHeight;
        Calibration cal = new Calibration();
        double downsampleFactor = request.getDownsample();
        PixelCalibration pixelCalibration = server.getPixelCalibration();
        double pixelWidth = pixelCalibration.getPixelWidthMicrons();
        if (!Double.isNaN(pixelWidth + (pixelHeight = pixelCalibration.getPixelHeightMicrons()))) {
            cal.pixelWidth = pixelWidth * downsampleFactor;
            cal.pixelHeight = pixelHeight * downsampleFactor;
            cal.pixelDepth = pixelCalibration.getZSpacingMicrons();
            if (server.nTimepoints() > 1) {
                cal.frameInterval = server.getMetadata().getTimepoint(1);
                if (server.getMetadata().getTimeUnit() != null) {
                    cal.setTimeUnit(server.getMetadata().getTimeUnit().toString());
                }
            }
            cal.setUnit("um");
        }
        cal.xOrigin = (double)(-request.getX()) / downsampleFactor;
        cal.yOrigin = (double)(-request.getY()) / downsampleFactor;
        imp.setCalibration(cal);
        FileInfo fi = imp.getFileInfo();
        File file = new File(server.getPath());
        fi.directory = file.getParent() + File.separator;
        fi.fileName = file.getName();
        String path = server.getPath();
        if (path != null && path.toLowerCase().startsWith("http")) {
            fi.url = path;
        }
        imp.setFileInfo(fi);
        imp.setProperty("Info", (Object)("location=" + server.getPath()));
    }

    public static double estimateDownsampleFactor(ImagePlus imp, ImageServer<?> server) {
        double downsampleFactor;
        Calibration cal = imp.getCalibration();
        double xMicrons = IJTools.tryToParseMicrons(cal.pixelWidth, cal.getXUnit());
        double yMicrons = IJTools.tryToParseMicrons(cal.pixelHeight, cal.getYUnit());
        boolean ijHasMicrons = !Double.isNaN(xMicrons) && !Double.isNaN(yMicrons);
        PixelCalibration pixelCalibration = server.getPixelCalibration();
        if (pixelCalibration.hasPixelSizeMicrons() && ijHasMicrons) {
            double downsampleY;
            double downsampleX = xMicrons / pixelCalibration.getPixelWidthMicrons();
            if (GeneralTools.almostTheSame((double)downsampleX, (double)(downsampleY = yMicrons / pixelCalibration.getPixelHeightMicrons()), (double)0.001)) {
                logger.debug("ImageJ downsample factor is being estimated from pixel sizes");
            } else {
                logger.warn("ImageJ downsample factor is being estimated from pixel sizes (and these don't seem to match! {} and {})", (Object)downsampleX, (Object)downsampleY);
            }
            downsampleFactor = (downsampleX + downsampleY) / 2.0;
        } else {
            double downsampleY;
            double downsampleX = (double)server.getWidth() / (double)imp.getWidth();
            if (GeneralTools.almostTheSame((double)downsampleX, (double)(downsampleY = (double)server.getHeight() / (double)imp.getHeight()), (double)0.001)) {
                logger.warn("ImageJ downsample factor is being estimated from image dimensions - assumes that ImagePlus corresponds to the full image server");
            } else {
                logger.warn("ImageJ downsample factor is being estimated from image dimensions - assumes that ImagePlus corresponds to the full image server (and these don't seem to match! {} and {})", (Object)downsampleX, (Object)downsampleY);
            }
            downsampleFactor = (downsampleX + downsampleY) / 2.0;
        }
        return downsampleFactor;
    }

    @Deprecated
    public static PathObject convertToPathObject(ImagePlus imp, ImageServer<?> server, Roi roi, double downsampleFactor, Function<ROI, PathObject> creator, ImagePlane plane) {
        ROI pathROI;
        Calibration cal;
        Calibration calibration = cal = imp == null ? null : imp.getCalibration();
        if (plane == null) {
            plane = IJTools.getImagePlane(roi, imp);
        }
        if ((pathROI = IJTools.convertToROI(roi, cal, downsampleFactor, plane)) == null) {
            return null;
        }
        PathObject pathObject = creator.apply(pathROI);
        IJTools.calibrateObject(pathObject, roi);
        return pathObject;
    }

    public static PathObject convertToPathObject(Roi roi, double xOrigin, double yOrigin, double downsampleFactor, Function<ROI, PathObject> creator, ImagePlane plane) {
        ROI pathROI = IJTools.convertToROI(roi, xOrigin, yOrigin, downsampleFactor, plane);
        if (pathROI == null) {
            return null;
        }
        PathObject pathObject = creator.apply(pathROI);
        IJTools.calibrateObject(pathObject, roi);
        return pathObject;
    }

    public static PathObject convertToPathObject(Roi roi, double downsampleFactor, Function<ROI, PathObject> creator, ImagePlus imp) {
        ImagePlane plane;
        Calibration cal = imp == null ? null : imp.getCalibration();
        ROI pathROI = IJTools.convertToROI(roi, cal, downsampleFactor, plane = IJTools.getImagePlane(roi, imp));
        if (pathROI == null) {
            return null;
        }
        PathObject pathObject = creator.apply(pathROI);
        IJTools.calibrateObject(pathObject, roi);
        return pathObject;
    }

    public static PathObject convertToAnnotation(Roi roi, double xOrigin, double yOrigin, double downsampleFactor, ImagePlane plane) {
        return IJTools.convertToPathObject(roi, xOrigin, yOrigin, downsampleFactor, PathObjects::createAnnotationObject, plane);
    }

    public static PathObject convertToDetection(Roi roi, double xOrigin, double yOrigin, double downsampleFactor, ImagePlane plane) {
        return IJTools.convertToPathObject(roi, xOrigin, yOrigin, downsampleFactor, (ROI r) -> PathObjects.createDetectionObject((ROI)r), plane);
    }

    public static PathObject convertToAnnotation(Roi roi, double downsampleFactor, ImagePlus imp) {
        return IJTools.convertToPathObject(roi, downsampleFactor, r -> PathObjects.createAnnotationObject((ROI)r), imp);
    }

    public static PathObject convertToDetection(Roi roi, double downsampleFactor, ImagePlus imp) {
        return IJTools.convertToPathObject(roi, downsampleFactor, r -> PathObjects.createDetectionObject((ROI)r), imp);
    }

    public static List<Roi> readImageJRois(File file) {
        RoiManager rm = new RoiManager(false);
        rm.runCommand("open", file.getAbsolutePath());
        Roi[] roisIJ = rm.getRoisAsArray();
        rm.reset();
        return Arrays.asList(roisIJ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsImageJRois(File file) {
        String ext = GeneralTools.getExtension((File)file).orElse(null);
        if (ext == null) {
            return false;
        }
        if (".roi".equals(ext = ext.toLowerCase())) {
            return true;
        }
        if (!".zip".equals(ext)) return false;
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry;
            Enumeration<? extends ZipEntry> enumerator = zipFile.entries();
            do {
                if (!enumerator.hasMoreElements()) return false;
            } while (!(entry = enumerator.nextElement()).getName().toLowerCase().endsWith(".roi"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn("Unable to check zip file for ROIs", (Throwable)e);
            return false;
        }
    }

    public static void calibrateObject(PathObject pathObject, Roi roi) {
        Map<String, Number> measurements;
        UUID id;
        Integer classColor;
        Color color = roi.getStrokeColor();
        Integer colorRGB = color == null ? null : Integer.valueOf(color.getRGB());
        String name = IJProperties.getObjectName(roi);
        if (name != null && !name.isBlank()) {
            pathObject.setName(name);
        }
        String classification = IJProperties.getClassification(roi);
        Integer n = classColor = !Objects.equals(color, Roi.getColor()) ? colorRGB : null;
        if (classification != null) {
            PathClass pathClass = PathClass.fromString((String)classification, (Integer)classColor);
            pathObject.setPathClass(pathClass);
        } else if (roi.getGroup() > 0) {
            int group = roi.getGroup();
            Object groupName = Roi.getGroupName((int)group);
            if (groupName == null) {
                groupName = "Group " + group;
            }
            pathObject.setPathClass(PathClass.fromString((String)groupName, (Integer)classColor));
        }
        if (colorRGB != null && pathObject.getPathClass() == null && !colorRGB.equals(pathObject.getColor())) {
            pathObject.setColor(colorRGB);
        }
        if ((id = IJProperties.getObjectId(roi)) != null) {
            pathObject.setID(id);
        }
        if (!(measurements = IJProperties.getAllMeasurements(roi)).isEmpty()) {
            pathObject.getMeasurementList().putAll(measurements);
        }
    }

    public static void calibrateRoi(Roi roi, PathObject pathObject) {
        IJProperties.setClassification(roi, pathObject);
        IJProperties.setObjectName(roi, pathObject);
        IJProperties.setObjectId(roi, pathObject);
        roi.setProperty("qupath.object.type", PathObjectTools.getSuitableName(pathObject.getClass(), (boolean)false));
        Integer colorRGB = pathObject.getColor();
        PathClass pc = pathObject.getPathClass();
        if (pc != null) {
            colorRGB = pc.getColor();
        }
        if (colorRGB != null) {
            roi.setStrokeColor(ColorToolsAwt.getCachedColor((Integer)colorRGB));
        }
    }

    @Deprecated
    public static PathObject convertToAnnotation(ImagePlus imp, ImageServer<?> server, Roi roi, double downsampleFactor, ImagePlane plane) {
        logger.debug("Called deprecated method convertToAnnotation - please update the method signature for v0.4.0+");
        return IJTools.convertToPathObject(imp, server, roi, downsampleFactor, (ROI r) -> PathObjects.createAnnotationObject((ROI)r), plane);
    }

    @Deprecated
    public static PathObject convertToDetection(ImagePlus imp, ImageServer<?> server, Roi roi, double downsampleFactor, ImagePlane plane) {
        logger.debug("Called deprecated method convertToDetection - please update the method signature for v0.4.0+");
        return IJTools.convertToPathObject(imp, server, roi, downsampleFactor, (ROI r) -> PathObjects.createDetectionObject((ROI)r), plane);
    }

    public static SortedMap<Number, PathObject> convertLabelsToCells(ImageProcessor ipNuclei, ImageProcessor ipCells, Calibration cal, double downsample, ImagePlane plane) {
        double x = cal == null ? 0.0 : cal.xOrigin;
        double y = cal == null ? 0.0 : cal.yOrigin;
        return IJTools.convertLabelsToCells(ipNuclei, ipCells, x, y, downsample, plane);
    }

    public static SortedMap<Number, PathObject> convertLabelsToCells(ImageProcessor ipNuclei, ImageProcessor ipCells, double xOrigin, double yOrigin, double downsample, ImagePlane plane) {
        int x;
        int y;
        int width = ipCells.getWidth();
        int height = ipCells.getHeight();
        TreeMap<Number, PathObject> cells = new TreeMap<Number, PathObject>();
        Wand wandCells = new Wand(ipCells);
        Wand wandNuclei = new Wand(ipNuclei);
        int wandMode = 8;
        ByteProcessor bpDone = new ByteProcessor(width, height);
        bpDone.setValue(255.0);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                int labelNucleus = (int)ipNuclei.getf(x, y);
                int labelCell = (int)ipNuclei.getf(x, y);
                if (labelNucleus > 0 && labelCell != labelNucleus) {
                    throw new IllegalArgumentException("All nucleus labels must have an identical corresponding cell label! Found nucleus label " + labelNucleus + " with cell " + labelCell + " at (" + x + ", " + y + ")");
                }
                if (labelNucleus == 0 || bpDone.get(x, y) != 0) continue;
                wandNuclei.autoOutline(x, y, (double)labelNucleus, (double)labelNucleus, wandMode);
                PolygonRoi nucleusRoi = IJProcessing.wandToRoi(wandNuclei);
                wandCells.autoOutline(x, y, (double)labelCell, (double)labelCell, wandMode);
                PolygonRoi cellRoi = IJProcessing.wandToRoi(wandCells);
                ROI roiNucleus = IJTools.convertToROI((Roi)nucleusRoi, xOrigin, yOrigin, downsample, plane);
                ROI roiCell = IJTools.convertToROI((Roi)cellRoi, xOrigin, yOrigin, downsample, plane);
                PathObject newCell = PathObjects.createCellObject((ROI)roiCell, (ROI)roiNucleus, null, null);
                PathObject previous = cells.put(labelNucleus, newCell);
                if (previous != null) {
                    logger.warn("Found duplicate cells/nuclei for label {}, will keep only one!", (Object)labelNucleus);
                    if (PathObjectTools.getROI((PathObject)newCell, (boolean)true).getArea() < PathObjectTools.getROI((PathObject)previous, (boolean)true).getArea()) {
                        cells.put(labelNucleus, previous);
                    }
                }
                bpDone.fill((Roi)cellRoi);
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                int label = (int)ipCells.getf(x, y);
                if (label == 0 || bpDone.get(x, y) != 0) continue;
                wandCells.autoOutline(x, y, (double)label, (double)label, wandMode);
                PolygonRoi cellRoi = IJProcessing.wandToRoi(wandCells);
                ROI roiCell = IJTools.convertToROI((Roi)cellRoi, xOrigin, yOrigin, downsample, plane);
                PathObject previous = cells.putIfAbsent(label, PathObjects.createCellObject((ROI)roiCell, null, null, null));
                if (previous != null) {
                    logger.warn("Found duplicate cell for label {}, will keep only one!", (Object)previous);
                }
                bpDone.fill((Roi)cellRoi);
            }
        }
        return cells;
    }

    public static void quickShowImage(String name, Roi roi, ImageProcessor ... ips) {
        ImageStack stack = null;
        for (ImageProcessor ip : ips) {
            if (!(ip instanceof ColorProcessor)) {
                ip.resetMinAndMax();
            }
            if (stack == null) {
                stack = new ImageStack(ip.getWidth(), ip.getHeight());
            }
            stack.addSlice(ip);
        }
        ImagePlus imp = new ImagePlus(name, stack);
        if (roi != null) {
            imp.setRoi(roi);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            imp.show();
        } else {
            SwingUtilities.invokeLater(() -> imp.show());
        }
    }

    public static void quickShowImage(String name, ImageProcessor ... ips) {
        IJTools.quickShowImage(name, null, ips);
    }

    public static double tryToParseMicrons(double value, String unit) {
        if (unit == null) {
            return Double.NaN;
        }
        String u = unit.toLowerCase();
        boolean microns = micronList.contains(u);
        if (microns) {
            return value;
        }
        if ("nm".equals(u)) {
            return value * 1000.0;
        }
        return Double.NaN;
    }

    public static ImagePlus convertToUncalibratedImagePlus(String title, BufferedImage img) {
        ImagePlus imp;
        int nBands = img.getSampleModel().getNumBands();
        if (img.getType() == 13 && nBands == 1 || BufferedImageTools.is8bitColorType((int)img.getType())) {
            imp = new ImagePlus(title, (Image)img);
        } else {
            ImageStack stack = new ImageStack(img.getWidth(), img.getHeight());
            for (int b = 0; b < nBands; ++b) {
                stack.addSlice(IJTools.convertToImageProcessor(img, b));
            }
            imp = new ImagePlus(title, stack);
            imp.setDimensions(nBands, 1, 1);
        }
        return imp;
    }

    public static ImageStack createImageStack(ImageProcessor ... ips) {
        if (ips.length == 0) {
            return new ImageStack();
        }
        ImageStack stack = new ImageStack(ips[0].getWidth(), ips[0].getHeight());
        for (ImageProcessor temp : ips) {
            stack.addSlice(temp);
        }
        return stack;
    }

    public static ImageProcessor convertToImageProcessor(BufferedImage img, int band) {
        int w = img.getWidth();
        int h = img.getHeight();
        int dataType = img.getSampleModel().getDataType();
        FloatProcessor fp = new FloatProcessor(w, h);
        float[] pixels = (float[])fp.getPixels();
        img.getRaster().getSamples(0, 0, w, h, band, pixels);
        if (dataType == 0) {
            ByteProcessor bp = new ByteProcessor(w, h);
            bp.setPixels(0, fp);
            return bp;
        }
        if (dataType == 1) {
            ShortProcessor sp = new ShortProcessor(w, h);
            sp.setPixels(0, fp);
            return sp;
        }
        return fp;
    }

    public static PathImage<ImagePlus> convertToImagePlus(String title, ImageServer<BufferedImage> server, BufferedImage img, RegionRequest request) throws IOException {
        if (img == null) {
            img = (BufferedImage)server.readRegion(request);
        }
        ImagePlus imp = IJTools.convertToUncalibratedImagePlus(title, img);
        imp.setDimensions(imp.getStackSize(), 1, 1);
        SampleModel sampleModel = img.getSampleModel();
        if (!server.isRGB()) {
            if (sampleModel.getNumBands() > 1) {
                CompositeImage impComp = imp.isRGB() ? (CompositeImage)CompositeConverter.makeComposite((ImagePlus)imp) : new CompositeImage(imp, 1);
                for (int b = 0; b < sampleModel.getNumBands(); ++b) {
                    impComp.setChannelLut(LUT.createLutFromColor((Color)new Color(server.getChannel(b).getColor())), b + 1);
                    impComp.getStack().setSliceLabel(server.getChannel(b).getName(), b + 1);
                }
                impComp.updateAllChannelsAndDraw();
                impComp.resetDisplayRanges();
                imp = impComp;
            } else {
                String channelName = server.getChannel(0).getName();
                if (channelName != null && !channelName.isBlank()) {
                    imp.getStack().setSliceLabel(channelName, 1);
                }
            }
        }
        IJTools.calibrateImagePlus(imp, request, server);
        return IJTools.createPathImage(server, imp, request);
    }

    public static PathImage<ImagePlus> convertToImagePlus(ImageServer<BufferedImage> server, RegionRequest request) throws IOException {
        String name = ServerTools.getDisplayableImageName(server);
        return IJTools.convertToImagePlus(name, server, null, request);
    }

    public static PathImage<ImagePlus> createPathImage(ImageServer<BufferedImage> server, ImagePlus imp, RegionRequest request) throws IOException {
        if (imp == null) {
            imp = (ImagePlus)IJTools.convertToImagePlus(server, request).getImage();
        }
        return new PathImagePlus(request, imp);
    }

    public static <T extends PathImage<ImagePlus>> Roi convertToIJRoi(ROI pathROI, T pathImage) {
        Calibration cal = null;
        double downsampleFactor = 1.0;
        if (pathImage != null) {
            cal = ((ImagePlus)pathImage.getImage()).getCalibration();
            downsampleFactor = pathImage.getDownsampleFactor();
        }
        return IJTools.convertToIJRoi(pathROI, cal, downsampleFactor);
    }

    public static <T extends PathImage<ImagePlus>> Roi convertToIJRoi(ROI pathROI, Calibration cal, double downsampleFactor) {
        if (cal != null) {
            return IJTools.convertToIJRoi(pathROI, cal.xOrigin, cal.yOrigin, downsampleFactor);
        }
        return IJTools.convertToIJRoi(pathROI, 0.0, 0.0, downsampleFactor);
    }

    public static ROI convertToROI(Roi roi, Calibration cal, double downsampleFactor, ImagePlane plane) {
        double x = cal == null ? 0.0 : cal.xOrigin;
        double y = cal == null ? 0.0 : cal.yOrigin;
        return IJTools.convertToROI(roi, x, y, downsampleFactor, plane);
    }

    public static ROI convertToROI(Roi roi, RegionRequest request) {
        double xOrigin = 0.0;
        double yOrigin = 0.0;
        double downsampleFactor = 1.0;
        ImagePlane plane = ImagePlane.getDefaultPlane();
        if (request != null) {
            downsampleFactor = request.getDownsample();
            xOrigin = (double)(-request.getX()) / downsampleFactor;
            yOrigin = (double)(-request.getY()) / downsampleFactor;
            plane = request.getImagePlane();
        }
        return IJTools.convertToROI(roi, xOrigin, yOrigin, downsampleFactor, plane);
    }

    public static ImagePlane getImagePlane(Roi roi, ImagePlus imp) {
        int position = roi.getPosition();
        int c = roi.getCPosition();
        int z = roi.getZPosition();
        int t = roi.getTPosition();
        if (imp != null && c == 0 && z == 0 && t == 0 && position > 0) {
            int[] pos = imp.convertIndexToPosition(position);
            c = pos[0];
            z = pos[1];
            t = pos[2];
        }
        c = Math.max(c - 1, 0);
        z = Math.max(z - 1, 0);
        t = Math.max(t - 1, 0);
        if (c == 0 && z == 0 && t == 0) {
            return ImagePlane.getDefaultPlane();
        }
        if (c > 0) {
            return ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t);
        }
        return ImagePlane.getPlane((int)z, (int)t);
    }

    public static <T extends PathImage<? extends ImagePlus>> ROI convertToROI(Roi roi, T pathImage) {
        ImageRegion region = pathImage.getImageRegion();
        Calibration cal = ((ImagePlus)pathImage.getImage()).getCalibration();
        double downsampleFactor = pathImage.getDownsampleFactor();
        return IJTools.convertToROI(roi, cal, downsampleFactor, region.getImagePlane());
    }

    public static PolygonROI convertToPolygonROI(PolygonRoi roi, Calibration cal, double downsampleFactor, ImagePlane plane) {
        List<Point2> points = ROIConverterIJ.convertToPointsList(roi.getFloatPolygon(), cal, downsampleFactor);
        return ROIs.createPolygonROI(points, (ImagePlane)plane);
    }

    public static Roi convertToIJRoi(ROI roi, RegionRequest request) {
        double xOrigin = 0.0;
        double yOrigin = 0.0;
        double downsampleFactor = 1.0;
        if (request != null) {
            downsampleFactor = request.getDownsample();
            xOrigin = (double)(-request.getX()) / downsampleFactor;
            yOrigin = (double)(-request.getY()) / downsampleFactor;
        }
        return IJTools.convertToIJRoi(roi, xOrigin, yOrigin, downsampleFactor);
    }

    public static Roi convertToIJRoi(ROI pathROI, double xOrigin, double yOrigin, double downsampleFactor) {
        Geometry geom;
        if (pathROI == null) {
            return null;
        }
        if (pathROI instanceof RectangleROI) {
            return ROIConverterIJ.getRectangleROI((RectangleROI)pathROI, xOrigin, yOrigin, downsampleFactor);
        }
        if (pathROI instanceof EllipseROI) {
            return ROIConverterIJ.convertToOvalROI((EllipseROI)pathROI, xOrigin, yOrigin, downsampleFactor);
        }
        if (pathROI instanceof LineROI) {
            return ROIConverterIJ.convertToLineROI((LineROI)pathROI, xOrigin, yOrigin, downsampleFactor);
        }
        if (pathROI instanceof PolylineROI) {
            return ROIConverterIJ.convertToPolygonROI((PolylineROI)pathROI, xOrigin, yOrigin, downsampleFactor);
        }
        if (pathROI instanceof PointsROI) {
            return ROIConverterIJ.convertToPointROI((PointsROI)pathROI, xOrigin, yOrigin, downsampleFactor);
        }
        if (pathROI instanceof PolygonROI && (geom = pathROI.getGeometry()) instanceof Polygon && geom.getNumGeometries() == 1 && ((Polygon)geom).getNumInteriorRing() == 0) {
            return ROIConverterIJ.convertToPolygonROI((PolygonROI)pathROI, xOrigin, yOrigin, downsampleFactor);
        }
        if (pathROI.isArea()) {
            return ROIConverterIJ.convertToShapeRoi(pathROI, xOrigin, yOrigin, downsampleFactor);
        }
        throw new UnsupportedOperationException("Unknown ROI " + String.valueOf(pathROI) + " - cannot convert to ImageJ Roi");
    }

    public static ROI convertToROI(Roi roi, double xOrigin, double yOrigin, double downsampleFactor, ImagePlane plane) {
        if (plane == null) {
            plane = IJTools.getImagePlane(roi, null);
        }
        int c = plane.getC();
        int z = plane.getZ();
        int t = plane.getT();
        if (roi.getType() == 0 && roi.getCornerDiameter() == 0) {
            return ROIConverterIJ.getRectangleROI(roi, xOrigin, yOrigin, downsampleFactor, c, z, t);
        }
        if (roi.getType() == 1) {
            return ROIConverterIJ.convertToEllipseROI(roi, xOrigin, yOrigin, downsampleFactor, c, z, t);
        }
        if (roi instanceof Line) {
            return ROIConverterIJ.convertToLineROI((Line)roi, xOrigin, yOrigin, downsampleFactor, c, z, t);
        }
        if (roi instanceof PointRoi) {
            return ROIConverterIJ.convertToPointROI((PolygonRoi)roi, xOrigin, yOrigin, downsampleFactor, c, z, t);
        }
        if (roi.isArea()) {
            return ROIConverterIJ.convertToPolygonOrAreaROI(roi, xOrigin, yOrigin, downsampleFactor, c, z, t);
        }
        if (roi instanceof PolygonRoi && (roi.getType() == 7 || roi.getType() == 6)) {
            return ROIConverterIJ.convertToPolylineROI((PolygonRoi)roi, xOrigin, yOrigin, downsampleFactor, c, z, t);
        }
        throw new IllegalArgumentException("Unknown Roi: " + String.valueOf(roi));
    }

    public static FloatProcessor convertToOpticalDensitySum(ColorProcessor cp, double maxRed, double maxGreen, double maxBlue) {
        FloatProcessor fp = cp.toFloat(0, null);
        ColorDeconvolutionHelper.convertPixelsToOpticalDensities((float[])((float[])fp.getPixels()), (double)maxRed, (boolean)true);
        FloatProcessor fpTemp = cp.toFloat(1, null);
        ColorDeconvolutionHelper.convertPixelsToOpticalDensities((float[])((float[])fpTemp.getPixels()), (double)maxGreen, (boolean)true);
        fp.copyBits((ImageProcessor)fpTemp, 0, 0, 3);
        fpTemp = cp.toFloat(2, fpTemp);
        ColorDeconvolutionHelper.convertPixelsToOpticalDensities((float[])((float[])fpTemp.getPixels()), (double)maxBlue, (boolean)true);
        fp.copyBits((ImageProcessor)fpTemp, 0, 0, 3);
        return fp;
    }

    public static FloatProcessor[] colorDeconvolve(ColorProcessor cp, ColorDeconvolutionStains stains) {
        int width = cp.getWidth();
        int height = cp.getHeight();
        int[] rgb = (int[])cp.getPixels();
        FloatProcessor fpStain1 = new FloatProcessor(width, height, ColorTransformer.getTransformedPixels((int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_1, null, (ColorDeconvolutionStains)stains));
        FloatProcessor fpStain2 = new FloatProcessor(width, height, ColorTransformer.getTransformedPixels((int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_2, null, (ColorDeconvolutionStains)stains));
        FloatProcessor fpStain3 = new FloatProcessor(width, height, ColorTransformer.getTransformedPixels((int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_3, null, (ColorDeconvolutionStains)stains));
        return new FloatProcessor[]{fpStain1, fpStain2, fpStain3};
    }

    public static FloatProcessor[] colorDeconvolve(ImageProcessor ipRed, ImageProcessor ipGreen, ImageProcessor ipBlue, ColorDeconvolutionStains stains) {
        int w = ipRed.getWidth();
        int h = ipRed.getHeight();
        float[] red = (float[])ipRed.convertToFloatProcessor().getPixels();
        float[] green = (float[])ipGreen.convertToFloatProcessor().getPixels();
        float[] blue = (float[])ipBlue.convertToFloatProcessor().getPixels();
        ColorDeconvolutionHelper.colorDeconvolve((float[])red, (float[])green, (float[])blue, (ColorDeconvolutionStains)stains);
        return new FloatProcessor[]{new FloatProcessor(w, h, red), new FloatProcessor(w, h, green), new FloatProcessor(w, h, blue)};
    }
}

