/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.tools;

import ij.ImagePlus;
import ij.gui.Roi;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.ImageData;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.PathObject;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class IJProperties {
    private static final Logger logger = LoggerFactory.getLogger(IJProperties.class);
    public static final String IMAGE_TYPE = "qupath.image.type";
    public static final String IMAGE_BACKGROUND = "qupath.image.background";
    public static final String BACKGROUND_DARK = "dark";
    public static final String BACKGROUND_LIGHT = "light";
    public static final String IMAGE_REGION_ROOT = "qupath.image.region.";
    public static final String IMAGE_REQUEST = "qupath.image.request";
    public static final String OBJECT_CLASSIFICATION = "qupath.object.classification";
    public static final String OBJECT_NAME = "qupath.object.name";
    public static final String OBJECT_ID = "qupath.object.id";
    public static final String OBJECT_MEASUREMENT_ROOT = "qupath.object.measurements.";

    public static String setImageRegion(ImagePlus imp, ImageRegion region) {
        if (region == null) {
            return null;
        }
        String prop = String.format("[x=%d, y=%d, w=%d, h=%d, z=%d, t=%d]", region.getX(), region.getY(), region.getWidth(), region.getHeight(), region.getZ(), region.getT());
        imp.setProp(IMAGE_REGION_ROOT, prop);
        imp.setProp("qupath.image.region.x", (double)region.getX());
        imp.setProp("qupath.image.region.y", (double)region.getY());
        imp.setProp("qupath.image.region.width", (double)region.getWidth());
        imp.setProp("qupath.image.region.height", (double)region.getHeight());
        imp.setProp("qupath.image.region.z", (double)region.getZ());
        imp.setProp("qupath.image.region.t", (double)region.getT());
        if (region instanceof RegionRequest) {
            RegionRequest request = (RegionRequest)region;
            imp.setProp("qupath.image.region.downsample", request.getDownsample());
        }
        return prop;
    }

    public static ImageRegion getImageRegion(ImagePlus imp) {
        String sx = imp.getProp("qupath.image.region.x");
        String sy = imp.getProp("qupath.image.region.y");
        String swidth = imp.getProp("qupath.image.region.width");
        String sheight = imp.getProp("qupath.image.region.height");
        String sz = imp.getProp("qupath.image.region.z");
        String st = imp.getProp("qupath.image.region.t");
        if (sx == null || sy == null || swidth == null || sheight == null) {
            return null;
        }
        int z = sz == null ? 0 : Integer.parseInt(sz);
        int t = st == null ? 0 : Integer.parseInt(st);
        try {
            return ImageRegion.createInstance((int)Integer.parseInt(sx), (int)Integer.parseInt(sy), (int)Integer.parseInt(swidth), (int)Integer.parseInt(sheight), (int)z, (int)t);
        }
        catch (Exception e) {
            logger.warn("Exception parsing region from properties: {}", (Object)e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String setRegionRequest(ImagePlus imp, RegionRequest request) {
        String json = GsonTools.getInstance().toJson((Object)request);
        imp.setProp(IMAGE_REQUEST, json);
        return json;
    }

    public static RegionRequest getRegionRequest(ImagePlus imp) {
        String json = imp.getProp(IMAGE_REQUEST);
        return json == null ? null : (RegionRequest)GsonTools.getInstance().fromJson(json, RegionRequest.class);
    }

    public static String setImageType(ImagePlus imp, ImageData.ImageType imageType) {
        if (imageType == null) {
            return null;
        }
        String prop = imageType.name();
        imp.setProp(IMAGE_TYPE, prop);
        return prop;
    }

    public static String setImageBackground(ImagePlus imp, ImageData.ImageType imageType) {
        String prop;
        if (imageType == null) {
            return null;
        }
        switch (imageType) {
            case FLUORESCENCE: {
                String string = BACKGROUND_DARK;
                break;
            }
            case BRIGHTFIELD_H_DAB: 
            case BRIGHTFIELD_H_E: 
            case BRIGHTFIELD_OTHER: {
                String string = BACKGROUND_LIGHT;
                break;
            }
            default: {
                String string = prop = null;
            }
        }
        if (prop != null) {
            imp.setProp(IMAGE_BACKGROUND, prop);
        }
        return prop;
    }

    public static String getImageBackground(ImagePlus imp) {
        return imp.getProp(IMAGE_BACKGROUND);
    }

    public static String setClassification(Roi roi, PathObject pathObject) {
        return IJProperties.setClassification(roi, pathObject == null ? null : pathObject.getClassification());
    }

    public static String setClassification(Roi roi, String classification) {
        roi.setProperty(OBJECT_CLASSIFICATION, classification);
        return classification;
    }

    public static String getClassification(Roi roi) {
        return roi.getProperty(OBJECT_CLASSIFICATION);
    }

    public static String setObjectName(Roi roi, PathObject pathObject) {
        return IJProperties.setObjectName(roi, pathObject == null ? null : pathObject.getName());
    }

    public static String setObjectName(Roi roi, String name) {
        roi.setProperty(OBJECT_NAME, name);
        return name;
    }

    public static String getObjectName(Roi roi) {
        return roi.getProperty(OBJECT_NAME);
    }

    public static String setObjectId(Roi roi, PathObject pathObject) {
        return IJProperties.setObjectId(roi, pathObject == null ? null : pathObject.getID());
    }

    public static String setObjectId(Roi roi, UUID id) {
        String val = id == null ? null : id.toString();
        roi.setProperty(OBJECT_ID, val);
        return val;
    }

    public static UUID getObjectId(Roi roi) {
        String id = roi.getProperty(OBJECT_ID);
        try {
            return id == null || id.isEmpty() ? null : UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid object ID in Roi: {}", (Object)id);
            return null;
        }
    }

    public static void putMeasurement(Roi roi, String name, double value) {
        roi.setProperty(OBJECT_MEASUREMENT_ROOT + name.replaceAll(" ", "_"), Double.toString(value));
    }

    public static Double getMeasurement(Roi roi, String name) {
        String prop;
        Object key = name.replaceAll(" ", "_");
        if (!((String)key).startsWith(OBJECT_MEASUREMENT_ROOT)) {
            key = OBJECT_MEASUREMENT_ROOT + (String)key;
        }
        return (prop = roi.getProperty((String)key)) == null ? null : Double.valueOf(Double.parseDouble(prop));
    }

    public static Map<String, Number> getAllMeasurements(Roi roi) {
        String properties = roi.getProperties();
        if (properties == null || !properties.contains(OBJECT_MEASUREMENT_ROOT)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        for (String line : properties.split("\n")) {
            int indSplit;
            if (!(line = line.strip()).startsWith(OBJECT_MEASUREMENT_ROOT) || (indSplit = line.indexOf(":")) < 0 || indSplit >= line.length() - 1) continue;
            try {
                double val = Double.parseDouble(line.substring(indSplit + 1).strip());
                String name = line.substring(OBJECT_MEASUREMENT_ROOT.length(), indSplit).replaceAll("_", " ").strip();
                map.put(name, val);
            }
            catch (NumberFormatException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }
}

