/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.superpixels;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.ColorSpaceConverter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.RoiLabeling;
import qupath.imagej.tools.IJTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.plugins.AbstractTileableDetectionPlugin;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class SLICSuperpixelsPlugin
extends AbstractTileableDetectionPlugin<BufferedImage> {
    private static int PREFERRED_PIXEL_SPACING = 20;
    private static Logger logger = LoggerFactory.getLogger(SLICSuperpixelsPlugin.class);

    public String getName() {
        return "SLIC superpixel plugin";
    }

    public String getLastResultsDescription() {
        return null;
    }

    private static double getPreferredDownsample(ImageData<BufferedImage> imageData, ParameterList params) {
        PixelCalibration cal = imageData.getServer().getPixelCalibration();
        boolean hasPixelSizeMicrons = cal.hasPixelSizeMicrons();
        double spacingPixels = hasPixelSizeMicrons ? params.getDoubleParameterValue("spacingMicrons") / cal.getAveragedPixelSizeMicrons() : params.getDoubleParameterValue("spacingPixels");
        double downsample = Math.max(1L, Math.round(spacingPixels / (double)PREFERRED_PIXEL_SPACING));
        return downsample;
    }

    protected double getPreferredPixelSizeMicrons(ImageData<BufferedImage> imageData, ParameterList params) {
        PixelCalibration cal = imageData.getServer().getPixelCalibration();
        if (cal.hasPixelSizeMicrons()) {
            return cal.getAveragedPixelSizeMicrons() * SLICSuperpixelsPlugin.getPreferredDownsample(imageData, params);
        }
        return SLICSuperpixelsPlugin.getPreferredDownsample(imageData, params);
    }

    protected ObjectDetector<BufferedImage> createDetector(ImageData<BufferedImage> imageData, ParameterList params) {
        return new SLICSuperpixelDetector();
    }

    protected int getTileOverlap(ImageData<BufferedImage> imageData, ParameterList params) {
        return 0;
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        ParameterList params = new ParameterList().addTitleParameter("Size parameters").addDoubleParameter("sigmaPixels", "Gaussian sigma", 5.0, "px", "Adjust the Gaussian smoothing applied to the image, to reduce textures and give a smoother result").addDoubleParameter("sigmaMicrons", "Gaussian sigma", 5.0, GeneralTools.micrometerSymbol(), "Adjust the Gaussian smoothing applied to the image, to reduce textures and give a smoother result").addDoubleParameter("spacingPixels", "Superpixel spacing", 50.0, "px", "Control the (approximate) size of individual superpixels").addDoubleParameter("spacingMicrons", "Superpixel spacing", 50.0, GeneralTools.micrometerSymbol(), "Control the (approximate) size of individual superpixels").addTitleParameter("Algorithm parameters").addIntParameter("maxIterations", "Number of iterations", 10, null, "Maximum number of iterations to use for superpixel generation").addDoubleParameter("regularization", "Regularization", 0.25, null, "Control the 'squareness' of superpixels - higher values are more square").addBooleanParameter("adaptRegularization", "Auto-adapt regularization", false, "Automatically adapt regularization parameter for different superpixels").addBooleanParameter("useDeconvolved", "Use color deconvolved channels", false, "Use color-deconvolved values, rather than (standard) RGB->LAB colorspace transform");
        boolean hasMicrons = imageData != null && imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        ((Parameter)params.getParameters().get("sigmaPixels")).setHidden(hasMicrons);
        ((Parameter)params.getParameters().get("sigmaMicrons")).setHidden(!hasMicrons);
        ((Parameter)params.getParameters().get("spacingPixels")).setHidden(hasMicrons);
        ((Parameter)params.getParameters().get("spacingMicrons")).setHidden(!hasMicrons);
        ((Parameter)params.getParameters().get("useDeconvolved")).setHidden(!imageData.isBrightfield() || imageData.getColorDeconvolutionStains() == null || !imageData.getServer().isRGB());
        return params;
    }

    public String getDescription() {
        return "Partition image into tiled regions of irregular shapes, using intensity & boundary information";
    }

    protected synchronized Collection<? extends PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
        Collection parents = super.getParentObjects(imageData);
        return parents;
    }

    static class SLICSuperpixelDetector
    implements ObjectDetector<BufferedImage> {
        private PathImage<ImagePlus> pathImage = null;
        private ROI pathROI = null;
        private String lastResultSummary = null;

        SLICSuperpixelDetector() {
        }

        public Collection<PathObject> runDetection(ImageData<BufferedImage> imageData, ParameterList params, ROI pathROI) throws IOException {
            List<PathObject> pathObjects;
            int i;
            ImageProcessor[] ipColor;
            if (pathROI == null) {
                this.lastResultSummary = "No ROI selected!";
                return null;
            }
            if (!pathROI.equals((Object)this.pathROI)) {
                ImageServer server = imageData.getServer();
                double downsample = SLICSuperpixelsPlugin.getPreferredDownsample(imageData, params);
                RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)pathROI).pad2D((int)Math.ceil(downsample * 2.0), (int)Math.ceil(downsample * 2.0)).intersect2D(0, 0, server.getWidth(), server.getHeight());
                this.pathImage = IJTools.convertToImagePlus((ImageServer<BufferedImage>)server, request);
                this.pathROI = pathROI;
            }
            int maxIterations = params.getIntParameterValue("maxIterations");
            double m = params.getDoubleParameterValue("regularization");
            boolean adaptRegularization = params.getBooleanParameterValue("adaptRegularization");
            boolean doDeconvolve = params.getBooleanParameterValue("useDeconvolved");
            double mergeThreshold = 0.05;
            ImagePlus imp = (ImagePlus)this.pathImage.getImage();
            if (imp.getType() == 4) {
                ColorProcessor cp = (ColorProcessor)imp.getProcessor();
                if (doDeconvolve && imageData.isBrightfield() && imageData.getColorDeconvolutionStains() != null) {
                    ipColor = IJTools.colorDeconvolve(cp, imageData.getColorDeconvolutionStains());
                    m /= 2.0;
                    mergeThreshold /= 2.0;
                } else {
                    imp = new ColorSpaceConverter().RGBToLab(imp);
                    ImageStack stack = imp.getStack();
                    ipColor = new ImageProcessor[stack.getSize()];
                    for (int i2 = 0; i2 < stack.getSize(); ++i2) {
                        ipColor[i2] = stack.getProcessor(i2 + 1).convertToFloatProcessor();
                    }
                    m *= 40.0;
                    mergeThreshold *= 40.0;
                }
            } else {
                ImageStack stack = imp.getStack();
                ipColor = new ImageProcessor[stack.getSize()];
                for (int i3 = 0; i3 < stack.getSize(); ++i3) {
                    ipColor[i3] = stack.getProcessor(i3 + 1).convertToFloatProcessor();
                }
                double regularizationSuggestion = 0.0;
                ImageProcessor[] imageProcessorArray = ipColor;
                int n = imageProcessorArray.length;
                for (int j = 0; j < n; ++j) {
                    ImageProcessor fp = imageProcessorArray[j];
                    regularizationSuggestion += fp.getStatistics().stdDev;
                }
                logger.info("Possible regularization value: {}", (Object)(regularizationSuggestion / (double)ipColor.length / 100.0));
                m *= 100.0;
                mergeThreshold *= 100.0;
            }
            double sigma = SLICSuperpixelDetector.getSigma(this.pathImage, params);
            if (sigma > 0.0) {
                for (ImageProcessor fp : ipColor) {
                    fp.blurGaussian(sigma);
                }
            }
            int w = imp.getWidth();
            int h = imp.getHeight();
            short[] labels = new short[w * h];
            Arrays.fill(labels, (short)-1);
            double[] distances = new double[w * h];
            Arrays.fill(distances, Double.POSITIVE_INFINITY);
            int s = PREFERRED_PIXEL_SPACING;
            ArrayList<ClusterCenter> centers = new ArrayList<ClusterCenter>();
            int widthClusters = 0;
            for (int y = s / 2; y < h; y += s) {
                widthClusters = 0;
                for (int x = s / 2; x < w; x += s) {
                    short label = (short)centers.size();
                    ClusterCenter center = new ClusterCenter(ipColor, label, s, m, adaptRegularization, w, h);
                    center.addLabel(y * w + x);
                    labels[y * w + x] = label;
                    centers.add(center);
                    ++widthClusters;
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                return Collections.emptyList();
            }
            for (i = 0; i < maxIterations; ++i) {
                short centerLabel = 0;
                if (Thread.currentThread().isInterrupted()) {
                    return Collections.emptyList();
                }
                for (ClusterCenter center : centers) {
                    center.updateFeatures();
                    for (int label : center.getNearbyClusters()) {
                        short currentLabel;
                        double distance = center.distanceSquared(label);
                        if (!(distance < distances[label]) || (currentLabel = labels[label]) == centerLabel) continue;
                        if (currentLabel != -1) {
                            ((ClusterCenter)centers.get(currentLabel)).removeLabel(label);
                        }
                        center.addLabel(label);
                        distances[label] = distance;
                        labels[label] = centerLabel;
                    }
                    ++centerLabel;
                }
            }
            if (params.containsKey((Object)"doMerge") && Boolean.TRUE.equals(params.getBooleanParameterValue("doMerge"))) {
                for (i = 0; i < centers.size(); ++i) {
                    ClusterCenter center2;
                    ClusterCenter center = (ClusterCenter)centers.get(i);
                    center.updateFeatures();
                    int xc = i % widthClusters;
                    if (xc < widthClusters - 1) {
                        center2 = (ClusterCenter)centers.get(i + 1);
                        SLICSuperpixelDetector.maybeMergeClusters(center, center2, labels, mergeThreshold);
                    }
                    if (i >= centers.size() - widthClusters) continue;
                    center2 = (ClusterCenter)centers.get(i + widthClusters);
                    SLICSuperpixelDetector.maybeMergeClusters(center, center2, labels, mergeThreshold);
                    if (xc < widthClusters - 1) {
                        center2 = (ClusterCenter)centers.get(i + widthClusters + 1);
                        SLICSuperpixelDetector.maybeMergeClusters(center, center2, labels, mergeThreshold);
                    }
                    if (xc <= 0) continue;
                    center2 = (ClusterCenter)centers.get(i + widthClusters - 1);
                    SLICSuperpixelDetector.maybeMergeClusters(center, center2, labels, mergeThreshold);
                }
            }
            short[] newLabels = new short[labels.length];
            int[] xyCurrent = new int[w * h];
            short label = 1;
            int minSize = s * s / 4;
            for (int y = 0; y < h; ++y) {
                short lastNewLabel = y > 0 ? labels[(y - 1) * w] : (short)1;
                for (int x = 0; x < w; ++x) {
                    int i4 = y * w + x;
                    short currentNewLabel = newLabels[i4];
                    if (currentNewLabel != 0) {
                        lastNewLabel = currentNewLabel;
                        continue;
                    }
                    short s2 = labels[i4];
                    int count = 1;
                    xyCurrent[0] = i4;
                    newLabels[i4] = label;
                    int c = 0;
                    while (c < count) {
                        int ind;
                        int ii = xyCurrent[c];
                        int xx = ii % w;
                        int yy = ii / w;
                        ++c;
                        if (xx > 0 && newLabels[ind = ii - 1] == 0 && labels[ind] == s2) {
                            xyCurrent[count] = ind;
                            newLabels[ind] = label;
                            ++count;
                        }
                        if (yy > 0 && newLabels[ind = ii - w] == 0 && labels[ind] == s2) {
                            xyCurrent[count] = ind;
                            newLabels[ind] = label;
                            ++count;
                        }
                        if (xx < w - 1 && newLabels[ind = ii + 1] == 0 && labels[ind] == s2) {
                            xyCurrent[count] = ind;
                            newLabels[ind] = label;
                            ++count;
                        }
                        if (yy >= h - 1 || newLabels[ind = ii + w] != 0 || labels[ind] != s2) continue;
                        xyCurrent[count] = ind;
                        newLabels[ind] = label;
                        ++count;
                    }
                    if (count <= minSize) {
                        for (c = 0; c < count; ++c) {
                            newLabels[xyCurrent[c]] = lastNewLabel;
                        }
                        continue;
                    }
                    lastNewLabel = label;
                    label = (short)(label + 1);
                }
            }
            ShortProcessor ipLabels = new ShortProcessor(w, h, newLabels, null);
            List<PolygonRoi> polygons = RoiLabeling.labelsToFilledRoiList((ImageProcessor)ipLabels, true);
            List<ROI> superpixelROIs = new ArrayList();
            try {
                for (Roi roi : polygons) {
                    if (roi == null) continue;
                    superpixelROIs.add(IJTools.convertToROI(roi, this.pathImage));
                }
                superpixelROIs = RoiTools.clipToROI((ROI)pathROI, superpixelROIs);
                pathObjects = superpixelROIs.stream().map(r -> PathObjects.createTileObject((ROI)r)).toList();
            }
            catch (Exception e) {
                logger.error("Error created tiled ROIs", (Throwable)e);
                pathObjects = Collections.emptyList();
            }
            this.lastResultSummary = pathObjects.size() + " tiles created";
            return pathObjects;
        }

        static boolean maybeMergeClusters(ClusterCenter center, ClusterCenter center2, short[] labels, double mergeThreshold) {
            boolean doMerge;
            double distanceThreshold = mergeThreshold;
            double dist = 0.0;
            for (int i = 0; i < center.features.length; ++i) {
                double f1 = center.features[i];
                double f2 = center2.features[i];
                dist += (f1 - f2) * (f1 - f2);
            }
            boolean bl = doMerge = (dist = Math.sqrt(dist)) <= distanceThreshold;
            if (doMerge) {
                for (int label : center2.getLabels()) {
                    labels[label] = center.primaryLabel;
                }
                center2.primaryLabel = center.primaryLabel;
                return true;
            }
            return false;
        }

        static double getSigma(PathImage<?> pathImage, ParameterList params) {
            double pixelSizeMicrons = pathImage.getPixelCalibration().getAveragedPixelSizeMicrons();
            if (Double.isNaN(pixelSizeMicrons)) {
                return params.getDoubleParameterValue("sigmaPixels") * pathImage.getDownsampleFactor();
            }
            return params.getDoubleParameterValue("sigmaMicrons") / pixelSizeMicrons;
        }

        public String getLastResultsDescription() {
            return this.lastResultSummary;
        }
    }

    static class ClusterCenter {
        private ImageProcessor[] featuresImages;
        private List<Integer> labels = new ArrayList<Integer>();
        private short primaryLabel;
        private double[] features = null;
        private double x;
        private double y;
        private boolean adaptRegularization;
        private double s;
        private double mSquared;
        private int width;
        private int height;

        ClusterCenter(ImageProcessor[] featuresImages, short primaryLabel, double s, double m, boolean adaptRegularization, int width, int height) {
            this.featuresImages = featuresImages;
            this.primaryLabel = primaryLabel;
            this.s = s;
            this.adaptRegularization = adaptRegularization;
            this.mSquared = m * m;
            this.width = width;
            this.height = height;
        }

        public List<Integer> getLabels() {
            return Collections.unmodifiableList(this.labels);
        }

        public void addLabel(Integer label) {
            this.labels.add(label);
        }

        public void removeLabel(Integer label) {
            this.labels.remove(label);
        }

        public List<Integer> getNearbyClusters() {
            if (this.labels.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int yy = (int)Math.max(0.0, this.y - this.s); yy < (int)Math.min((double)this.height, this.y + this.s); ++yy) {
                for (int xx = (int)Math.max(0.0, this.x - this.s); xx < (int)Math.min((double)this.width, this.x + this.s); ++xx) {
                    list.add(yy * this.width + xx);
                }
            }
            return list;
        }

        public void updateFeatures() {
            if (this.labels.isEmpty()) {
                this.x = Double.NaN;
                this.y = Double.NaN;
                this.features = null;
            }
            int n = this.labels.size();
            this.x = 0.0;
            this.y = 0.0;
            this.features = new double[this.featuresImages.length];
            for (int label : this.labels) {
                double xx = label % this.width;
                double yy = label / this.width;
                this.x += xx / (double)n;
                this.y += yy / (double)n;
                for (int i = 0; i < this.features.length; ++i) {
                    int n2 = i;
                    this.features[n2] = this.features[n2] + (double)(this.featuresImages[i].getf(label) / (float)n);
                }
            }
            this.updateM();
        }

        private void updateM() {
            if (!this.adaptRegularization) {
                return;
            }
            double maxDistanceSquared = 0.0;
            for (int label : this.labels) {
                double dist = this.colorDistanceSquared(label);
                if (!(dist > maxDistanceSquared)) continue;
                maxDistanceSquared = dist;
            }
            if (maxDistanceSquared > 0.0) {
                this.mSquared = maxDistanceSquared;
            }
        }

        private double colorDistanceSquared(int ind) {
            double DC2 = 0.0;
            for (int i = 0; i < this.featuresImages.length; ++i) {
                double d = (double)this.featuresImages[i].getf(ind) - this.features[i];
                if (!Double.isFinite(d)) continue;
                DC2 += d * d;
            }
            return DC2;
        }

        public double colorDistance(double[] features) {
            double distanceSquared = 0.0;
            for (int i = 0; i < features.length; ++i) {
                double d = features[i] - this.features[i];
                distanceSquared += d * d;
            }
            return Math.sqrt(distanceSquared);
        }

        public double distanceSquared(int ind) {
            if (this.features == null) {
                return Double.POSITIVE_INFINITY;
            }
            double xx = ind % this.width;
            double yy = ind / this.width;
            double dx = this.x - xx;
            double dy = this.y - yy;
            double DS2 = dx * dx + dy * dy;
            double DC2 = this.colorDistanceSquared(ind);
            double distanceSquared = DC2 / this.mSquared + DS2 / (this.s * this.s);
            return distanceSquared;
        }
    }
}

