/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.superpixels;

import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.MaximumFinder;
import ij.plugin.filter.RankFilters;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.RoiLabeling;
import qupath.imagej.tools.IJTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.plugins.AbstractTileableDetectionPlugin;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class DoGSuperpixelsPlugin
extends AbstractTileableDetectionPlugin<BufferedImage> {
    private static Logger logger = LoggerFactory.getLogger(DoGSuperpixelsPlugin.class);

    public String getName() {
        return "DoG superpixel creator";
    }

    public String getLastResultsDescription() {
        return null;
    }

    protected double getPreferredPixelSizeMicrons(ImageData<BufferedImage> imageData, ParameterList params) {
        double pixelSize = params.getDoubleParameterValue("downsampleFactor");
        PixelCalibration cal = imageData.getServer().getPixelCalibration();
        if (imageData != null && cal.hasPixelSizeMicrons()) {
            pixelSize *= cal.getAveragedPixelSizeMicrons();
        }
        return pixelSize;
    }

    protected ObjectDetector<BufferedImage> createDetector(ImageData<BufferedImage> imageData, ParameterList params) {
        return new DoGSuperpixelDetector();
    }

    protected int getTileOverlap(ImageData<BufferedImage> imageData, ParameterList params) {
        return 0;
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        ParameterList params = new ParameterList().addDoubleParameter("downsampleFactor", "Downsample factor", 8.0, null, "Downsample factor, used to determine the resolution of the image being processed").addDoubleParameter("sigmaPixels", "Gaussian sigma", 10.0, "px", "Sigma value used for smoothing; higher values result in larger regions being created").addDoubleParameter("sigmaMicrons", "Gaussian sigma", 10.0, GeneralTools.micrometerSymbol(), "Sigma value used for smoothing; higher values result in larger regions being created").addDoubleParameter("minThreshold", "Minimum intensity threshold", 10.0, null, "Regions with average values below this threshold will be discarded; this helps remove background or artefacts").addDoubleParameter("maxThreshold", "Maximum intensity threshold", 230.0, null, "Regions with average values above this threshold will be discarded; this helps remove background or artefacts").addDoubleParameter("noiseThreshold", "Noise threshold", 1.0, null, "Local threshold used to determine the number of regions created");
        boolean hasMicrons = imageData != null && imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        ((Parameter)params.getParameters().get("sigmaPixels")).setHidden(hasMicrons);
        ((Parameter)params.getParameters().get("sigmaMicrons")).setHidden(!hasMicrons);
        return params;
    }

    public String getDescription() {
        return "Partition image into tiled regions of irregular shapes, using intensity & boundary information";
    }

    protected synchronized Collection<? extends PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
        Collection parents = super.getParentObjects(imageData);
        return parents;
    }

    static class DoGSuperpixelDetector
    implements ObjectDetector<BufferedImage> {
        private PathImage<ImagePlus> pathImage = null;
        private ROI pathROI = null;
        private String lastResultSummary = null;

        DoGSuperpixelDetector() {
        }

        public Collection<PathObject> runDetection(ImageData<BufferedImage> imageData, ParameterList params, ROI pathROI) throws IOException {
            if (pathROI == null) {
                this.lastResultSummary = "No ROI selected!";
                return null;
            }
            if (pathROI.equals((Object)this.pathROI)) {
                // empty if block
            }
            ImageServer server = imageData.getServer();
            double downsample = params.getDoubleParameterValue("downsampleFactor");
            RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)pathROI).pad2D((int)Math.ceil(downsample * 2.0), (int)Math.ceil(downsample * 2.0)).intersect2D(0, 0, server.getWidth(), server.getHeight());
            this.pathImage = IJTools.convertToImagePlus((ImageServer<BufferedImage>)server, request);
            this.pathROI = pathROI;
            ImageProcessor ipOrig = ((ImagePlus)this.pathImage.getImage()).getProcessor();
            FloatProcessor fp = ipOrig.convertToFloatProcessor();
            FloatProcessor fpOrig = (FloatProcessor)fp.duplicate();
            FloatProcessor fp2 = (FloatProcessor)fpOrig.duplicate();
            double sigma = DoGSuperpixelDetector.getSigma(this.pathImage, params);
            fp.blurGaussian(sigma);
            fp2.blurGaussian(sigma * 1.6);
            fp.copyBits((ImageProcessor)fp2, 0, 0, 4);
            fp.resetRoi();
            fp.abs();
            ByteProcessor bp = new MaximumFinder().findMaxima((ImageProcessor)fp, params.getDoubleParameterValue("noiseThreshold").doubleValue(), 2, false);
            bp.setThreshold(128.0, Double.POSITIVE_INFINITY, 2);
            ImageProcessor ipLabels = RoiLabeling.labelImage((ImageProcessor)bp, 0.5f, false);
            new RankFilters().rank(ipLabels, 1.0, 2);
            if (Thread.currentThread().isInterrupted()) {
                return Collections.emptyList();
            }
            PolygonRoi[] polygons = RoiLabeling.labelsToFilledROIs(ipLabels, (int)ipLabels.getMax());
            ArrayList<PathObject> pathObjects = new ArrayList<PathObject>(polygons.length);
            double minThreshold = params.getDoubleParameterValue("minThreshold");
            double maxThreshold = params.getDoubleParameterValue("maxThreshold");
            if (!Double.isFinite(minThreshold)) {
                minThreshold = Double.NEGATIVE_INFINITY;
            }
            if (!Double.isFinite(maxThreshold)) {
                maxThreshold = Double.POSITIVE_INFINITY;
            }
            boolean hasThreshold = minThreshold != maxThreshold && (Double.isFinite(minThreshold) || Double.isFinite(maxThreshold));
            try {
                List<ROI> superpixelROIs = new ArrayList();
                for (PolygonRoi roi : polygons) {
                    if (roi == null) continue;
                    if (hasThreshold) {
                        fpOrig.setRoi((Roi)roi);
                        double meanValue = fpOrig.getStatistics().mean;
                        if (meanValue < minThreshold || meanValue > maxThreshold) continue;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        return Collections.emptyList();
                    }
                    superpixelROIs.add(IJTools.convertToROI((Roi)roi, this.pathImage));
                }
                if (pathROI != null) {
                    superpixelROIs = RoiTools.clipToROI((ROI)pathROI, superpixelROIs);
                }
                for (ROI superpixelROI : superpixelROIs) {
                    PathObject tile = PathObjects.createTileObject((ROI)superpixelROI);
                    pathObjects.add(tile);
                }
            }
            catch (Exception e) {
                logger.error("Error creating superpixels", (Throwable)e);
            }
            fpOrig.resetRoi();
            this.lastResultSummary = pathObjects.size() + " tiles created";
            return pathObjects;
        }

        static double getSigma(PathImage<?> pathImage, ParameterList params) {
            double pixelSizeMicrons = pathImage.getPixelCalibration().getAveragedPixelSizeMicrons();
            if (Double.isNaN(pixelSizeMicrons)) {
                return params.getDoubleParameterValue("sigmaPixels") * params.getDoubleParameterValue("downsampleFactor");
            }
            return params.getDoubleParameterValue("sigmaMicrons") / pixelSizeMicrons;
        }

        public String getLastResultsDescription() {
            return this.lastResultSummary;
        }
    }
}

