/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.processing;

import ij.IJ;
import ij.plugin.filter.EDM;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayDeque;
import java.util.PriorityQueue;
import qupath.imagej.processing.SimpleThresholding;

public class Watershed {
    public static void watershedExpandLabels(ImageProcessor ipLabels, double maxDistance, boolean conn8) {
        ByteProcessor bp = SimpleThresholding.thresholdAbove(ipLabels, 0.0);
        FloatProcessor fpEDM = new EDM().makeFloatEDM((ImageProcessor)bp, -1, false);
        fpEDM.multiply(-1.0);
        Watershed.doWatershed((ImageProcessor)fpEDM, ipLabels, -maxDistance, conn8);
    }

    public static void doWatershed(ImageProcessor ip, ImageProcessor ipLabels, boolean conn8) {
        Watershed.doWatershed(ip, ipLabels, Double.NEGATIVE_INFINITY, conn8);
    }

    public static void doWatershed(ImageProcessor ip, ImageProcessor ipLabels, double minThreshold, boolean conn8) {
        long startTime = System.currentTimeMillis();
        int width = ip.getWidth();
        int height = ip.getHeight();
        WatershedQueueWrapper queue = new WatershedQueueWrapper(ip, ipLabels, minThreshold);
        while (!queue.isEmpty()) {
            PixelWithValue pwv = queue.poll();
            int x = pwv.x;
            int y = pwv.y;
            queue.discard(pwv);
            float lastLabel = conn8 ? Watershed.getNeighborLabels8(ipLabels, x, y, width, height) : Watershed.getNeighborLabels4(ipLabels, x, y, width, height);
            if (Float.isNaN(lastLabel)) continue;
            ipLabels.setf(x, y, lastLabel);
            if (conn8) {
                Watershed.addNeighboursToQueue8(queue, x, y, width, height);
                continue;
            }
            Watershed.addNeighboursToQueue4(queue, x, y, width, height);
        }
        long endTime = System.currentTimeMillis();
        if (IJ.debugMode) {
            IJ.log((String)String.format("Watershed time taken: %.2fs", (double)(endTime - startTime) / 1000.0));
        }
    }

    private static float getNeighborLabels4(ImageProcessor ipLabels, int x, int y, int w, int h) {
        float label;
        float lastLabel = Float.NaN;
        if (x > 0 && (label = ipLabels.getf(x - 1, y)) != 0.0f) {
            if (Float.isNaN(lastLabel)) {
                lastLabel = label;
            } else if (lastLabel != label) {
                return Float.NaN;
            }
        }
        if (x < w - 1 && (label = ipLabels.getf(x + 1, y)) != 0.0f) {
            if (Float.isNaN(lastLabel)) {
                lastLabel = label;
            } else if (lastLabel != label) {
                return Float.NaN;
            }
        }
        if (y > 0 && (label = ipLabels.getf(x, y - 1)) != 0.0f) {
            if (Float.isNaN(lastLabel)) {
                lastLabel = label;
            } else if (lastLabel != label) {
                return Float.NaN;
            }
        }
        if (y < h - 1 && (label = ipLabels.getf(x, y + 1)) != 0.0f) {
            if (Float.isNaN(lastLabel)) {
                lastLabel = label;
            } else if (lastLabel != label) {
                return Float.NaN;
            }
        }
        return lastLabel;
    }

    private static void addNeighboursToQueue4(WatershedQueueWrapper queue, int x, int y, int w, int h) {
        queue.add(x, y - 1);
        queue.add(x - 1, y);
        queue.add(x + 1, y);
        queue.add(x, y + 1);
    }

    private static float getNeighborLabels8(ImageProcessor ipLabels, int x, int y, int w, int h) {
        float lastLabel = Float.NaN;
        for (int yy = Math.max(y - 1, 0); yy <= Math.min(h - 1, y + 1); ++yy) {
            for (int xx = Math.max(x - 1, 0); xx <= Math.min(w - 1, x + 1); ++xx) {
                float label;
                if (xx == x && yy == y || (label = ipLabels.getf(xx, yy)) <= 0.0f) continue;
                if (Float.isNaN(lastLabel)) {
                    lastLabel = label;
                    continue;
                }
                if (lastLabel == label) continue;
                return Float.NaN;
            }
        }
        return lastLabel;
    }

    private static void addNeighboursToQueue8(WatershedQueueWrapper queue, int x, int y, int w, int h) {
        queue.add(x - 1, y - 1);
        queue.add(x, y - 1);
        queue.add(x + 1, y - 1);
        queue.add(x - 1, y);
        queue.add(x + 1, y);
        queue.add(x - 1, y + 1);
        queue.add(x, y + 1);
        queue.add(x + 1, y + 1);
    }

    static class WatershedQueueWrapper {
        private final PriorityQueue<PixelWithValue> queue = new PriorityQueue();
        private final boolean[] queued;
        private final int width;
        private final int height;
        private final ImageProcessor ip;
        private long counter = 0L;
        private final ArrayDeque<PixelWithValue> dequePool;

        public WatershedQueueWrapper(ImageProcessor ip, ImageProcessor ipLabels, double minThreshold) {
            this.ip = ip;
            this.width = ip.getWidth();
            this.height = ip.getHeight();
            this.queued = new boolean[this.width * this.height];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    float val = ip.getf(x, y);
                    if ((double)val <= minThreshold) {
                        this.queued[y * this.width + x] = true;
                        continue;
                    }
                    if (ipLabels.getf(x, y) != 0.0f) {
                        this.queued[y * this.width + x] = true;
                        continue;
                    }
                    if (ipLabels.getPixelValue(x + 1, y) == 0.0f && ipLabels.getPixelValue(x - 1, y) == 0.0f && ipLabels.getPixelValue(x, y - 1) == 0.0f && ipLabels.getPixelValue(x, y + 1) == 0.0f) continue;
                    this.queued[y * this.width + x] = true;
                    this.queue.add(new PixelWithValue(x, y, val, ++this.counter));
                }
            }
            this.dequePool = new ArrayDeque(ip.getWidth() * ip.getHeight());
        }

        public final void add(int x, int y) {
            if (!this.mayAddToQueue(x, y)) {
                return;
            }
            this.addWithoutCheck(x, y, this.ip.getf(x, y));
        }

        protected final void addWithoutCheck(int x, int y, float val) {
            PixelWithValue pwv = this.dequePool.poll();
            if (pwv == null) {
                pwv = new PixelWithValue(x, y, val, ++this.counter);
            } else {
                pwv.x = x;
                pwv.y = y;
                pwv.value = val;
                pwv.count = ++this.counter;
            }
            this.queue.add(pwv);
            this.queued[y * this.width + x] = true;
        }

        public final boolean mayAddToQueue(int x, int y) {
            return x >= 0 && x < this.width && y >= 0 && y < this.height && !this.queued[y * this.width + x];
        }

        public final PixelWithValue poll() {
            return this.queue.poll();
        }

        public final boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public final void discard(PixelWithValue pwv) {
            this.dequePool.add(pwv);
        }
    }

    static class PixelWithValue
    implements Comparable<PixelWithValue> {
        public int x;
        public int y;
        public float value;
        public long count;

        public PixelWithValue(int x, int y, float value, long count) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.count = count;
        }

        @Override
        public int compareTo(PixelWithValue pwv) {
            if (this.value < pwv.value) {
                return 1;
            }
            if (this.value > pwv.value) {
                return -1;
            }
            return this.count > pwv.count ? 1 : -1;
        }
    }
}

