/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.processing;

import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import qupath.imagej.processing.IJProcessing;
import qupath.imagej.tools.IJTools;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class SimpleThresholding {
    public static ByteProcessor greaterThanOrEqual(ImageProcessor ip1, ImageProcessor ip2) {
        ByteProcessor bp = new ByteProcessor(ip1.getWidth(), ip1.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            if (!(ip1.getf(i) >= ip2.getf(i))) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ByteProcessor greaterThan(ImageProcessor ip1, ImageProcessor ip2) {
        ByteProcessor bp = new ByteProcessor(ip1.getWidth(), ip1.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            if (!(ip1.getf(i) > ip2.getf(i))) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ByteProcessor thresholdBelow(ImageProcessor ip, double threshold) {
        ByteProcessor bp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            if (!((double)ip.getf(i) < threshold)) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ByteProcessor thresholdBelowEquals(ImageProcessor ip, double threshold) {
        ByteProcessor bp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            if (!((double)ip.getf(i) <= threshold)) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ByteProcessor imagesEqual(ImageProcessor ip1, ImageProcessor ip2) {
        ByteProcessor bp = new ByteProcessor(ip1.getWidth(), ip1.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            if (ip1.getf(i) != ip2.getf(i)) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ByteProcessor thresholdAbove(ImageProcessor ip, double threshold) {
        ByteProcessor bp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            if (!((double)ip.getf(i) > threshold)) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ByteProcessor thresholdAboveEquals(ImageProcessor ip, double threshold) {
        ByteProcessor bp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            if (!((double)ip.getf(i) >= threshold)) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ByteProcessor thresholdBetween(ImageProcessor ip, double lowThreshold, double highThreshold) {
        ByteProcessor bp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        for (int i = 0; i < bpPixels.length; ++i) {
            double val = ip.getf(i);
            if (!(val >= lowThreshold) || !(val <= highThreshold)) continue;
            bpPixels[i] = -1;
        }
        return bp;
    }

    public static ROI thresholdToROI(BufferedImage img, double minThreshold, double maxThreshold, int band, RegionRequest request) {
        int w = img.getWidth();
        int h = img.getHeight();
        float[] pixels = new float[w * h];
        img.getRaster().getSamples(0, 0, w, h, band, pixels);
        FloatProcessor fp = new FloatProcessor(w, h, pixels);
        fp.setThreshold(minThreshold, maxThreshold, 2);
        return SimpleThresholding.thresholdToROI((ImageProcessor)fp, request);
    }

    public static ROI thresholdToROI(Raster raster, double minThreshold, double maxThreshold, int band, TileRequest request) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        float[] pixels = new float[w * h];
        raster.getSamples(0, 0, w, h, band, pixels);
        FloatProcessor fp = new FloatProcessor(w, h, pixels);
        fp.setThreshold(minThreshold, maxThreshold, 2);
        return SimpleThresholding.thresholdToROI((ImageProcessor)fp, request);
    }

    public static ROI thresholdToROI(ImageProcessor ip, RegionRequest request) {
        Roi roiIJ = IJProcessing.thresholdToRoi(ip);
        if (roiIJ == null) {
            return null;
        }
        if (request == null) {
            return IJTools.convertToROI(roiIJ, 0.0, 0.0, 1.0, ImagePlane.getDefaultPlane());
        }
        return IJTools.convertToROI(roiIJ, (double)(-request.getX()) / request.getDownsample(), (double)(-request.getY()) / request.getDownsample(), request.getDownsample(), request.getImagePlane());
    }

    private static ROI thresholdToROI(ImageProcessor ip, TileRequest request) {
        Roi roiIJ = IJProcessing.thresholdToRoi(ip);
        if (roiIJ == null) {
            return null;
        }
        if (request == null) {
            return IJTools.convertToROI(roiIJ, 0.0, 0.0, 1.0, ImagePlane.getDefaultPlane());
        }
        return IJTools.convertToROI(roiIJ, -request.getTileX(), -request.getTileY(), request.getDownsample(), request.getImagePlane());
    }
}

