/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.processing;

import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.process.ByteProcessor;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.IJProcessing;
import qupath.lib.common.LogTools;

public class RoiLabeling {
    private static final Logger logger = LoggerFactory.getLogger(RoiLabeling.class);

    public static ByteProcessor findDirectionalMaxima(ImageProcessor ip) {
        ImageProcessor ip2 = ip.duplicate();
        ip2.invert();
        return RoiLabeling.findDirectionalMinima(ip2);
    }

    public static ByteProcessor findDirectionalMinima(ImageProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        ByteProcessor bp = new ByteProcessor(w, h);
        for (int y = 1; y < h - 1; ++y) {
            for (int x = 1; x < w - 1; ++x) {
                float val = ip.getf(x, y);
                if (!(ip.getf(x - 1, y) > val && ip.getf(x + 1, y) > val || ip.getf(x - 1, y - 1) > val && ip.getf(x + 1, y + 1) > val || ip.getf(x, y - 1) > val && ip.getf(x, y + 1) > val) && (!(ip.getf(x - 1, y + 1) > val) || !(ip.getf(x + 1, y - 1) > val))) continue;
                bp.setf(x, y, 255.0f);
            }
        }
        return bp;
    }

    public static PolygonRoi[] labelsToFilledROIs(ImageProcessor ipLabels, int n) {
        PolygonRoi[] rois = new PolygonRoi[n];
        int w = ipLabels.getWidth();
        int h = ipLabels.getHeight();
        ByteProcessor bpCompleted = new ByteProcessor(w, h);
        bpCompleted.setValue(255.0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                PolygonRoi roi;
                float val;
                if (bpCompleted.get(x, y) != 0 || !((val = ipLabels.getf(x, y)) > 0.0f) || !(val <= (float)n)) continue;
                Wand wand = new Wand(ipLabels);
                wand.autoOutline(x, y, (double)val, (double)val, 8);
                rois[(int)val - 1] = roi = RoiLabeling.wandToRoi(wand);
                bpCompleted.fill((Roi)roi);
            }
        }
        return rois;
    }

    public static List<PolygonRoi> labelsToFilledRoiList(ImageProcessor ipLabels, boolean conn8) {
        ArrayList<PolygonRoi> rois = new ArrayList<PolygonRoi>();
        int w = ipLabels.getWidth();
        int h = ipLabels.getHeight();
        ByteProcessor bpCompleted = new ByteProcessor(w, h);
        bpCompleted.setValue(255.0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float val;
                if (bpCompleted.get(x, y) != 0 || !((val = ipLabels.getf(x, y)) > 0.0f)) continue;
                Wand wand = new Wand(ipLabels);
                wand.autoOutline(x, y, (double)val, (double)val, conn8 ? 8 : 4);
                PolygonRoi roi = RoiLabeling.wandToRoi(wand);
                rois.add(roi);
                bpCompleted.fill((Roi)roi);
            }
        }
        return rois;
    }

    public static Map<Float, PolygonRoi> getFilledPolygonROIsFromLabels(ImageProcessor ip, int wandMode) {
        double threshHigher;
        double threshLower = ip.getMinThreshold();
        if (threshLower == -808080.0) {
            threshLower = Double.NEGATIVE_INFINITY;
        }
        if ((threshHigher = ip.getMaxThreshold()) == -808080.0) {
            threshHigher = Double.POSITIVE_INFINITY;
        }
        int w = ip.getWidth();
        int h = ip.getHeight();
        ByteProcessor bpCompleted = new ByteProcessor(w, h);
        bpCompleted.setValue(255.0);
        TreeMap<Float, PolygonRoi> map = new TreeMap<Float, PolygonRoi>();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float val;
                if (bpCompleted.get(x, y) != 0 || !((double)(val = ip.getf(x, y)) >= threshLower) || !((double)val <= threshHigher)) continue;
                Wand wand = new Wand(ip);
                wand.autoOutline(x, y, threshLower, threshHigher, wandMode);
                PolygonRoi roi = RoiLabeling.wandToRoi(wand);
                Float key = Float.valueOf(val);
                if (map.containsKey(key)) {
                    logger.warn("Polygon ROI is being inserted twice into map for the same key {}", (Object)key);
                }
                map.put(Float.valueOf(val), roi);
                bpCompleted.fill((Roi)roi);
            }
        }
        return map;
    }

    public static List<PolygonRoi> getFilledPolygonROIs(ImageProcessor ip, int wandMode) {
        double threshHigher;
        double threshLower = ip.getMinThreshold();
        if (threshLower == -808080.0) {
            threshLower = Double.NEGATIVE_INFINITY;
        }
        if ((threshHigher = ip.getMaxThreshold()) == -808080.0) {
            threshHigher = Double.POSITIVE_INFINITY;
        }
        int w = ip.getWidth();
        int h = ip.getHeight();
        ArrayList<PolygonRoi> rois = new ArrayList<PolygonRoi>();
        ByteProcessor bpCompleted = new ByteProcessor(w, h);
        bpCompleted.setValue(255.0);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float val;
                if (bpCompleted.get(x, y) != 0 || !((double)(val = ip.getf(x, y)) >= threshLower) || !((double)val <= threshHigher)) continue;
                Wand wand = new Wand(ip);
                wand.autoOutline(x, y, threshLower, threshHigher, wandMode);
                PolygonRoi roi = RoiLabeling.wandToRoi(wand);
                rois.add(roi);
                bpCompleted.fill((Roi)roi);
            }
        }
        return rois;
    }

    @Deprecated
    public static PolygonRoi wandToRoi(Wand wand) {
        return IJProcessing.wandToRoi(wand);
    }

    public static void fillHoles(ByteProcessor bp) {
        int w = bp.getWidth();
        int h = bp.getHeight();
        FloodFiller ff = new FloodFiller((ImageProcessor)bp);
        bp.setValue(127.0);
        for (int x = 0; x < w; ++x) {
            if (bp.getPixel(x, 0) == 0) {
                ff.fill8(x, 0);
            }
            if (bp.getPixel(x, h - 1) != 0) continue;
            ff.fill8(x, h - 1);
        }
        for (int y = 0; y < h; ++y) {
            if (bp.getPixel(0, y) == 0) {
                ff.fill8(0, y);
            }
            if (bp.getPixel(w - 1, y) != 0) continue;
            ff.fill8(w - 1, y);
        }
        for (int i = 0; i < w * h; ++i) {
            if (bp.get(i) == 127) {
                bp.set(i, 0);
                continue;
            }
            bp.set(i, 255);
        }
    }

    public static ImageProcessor labelROIs(ImageProcessor ipLabels, List<? extends Roi> rois) {
        int label = 0;
        for (Roi roi : rois) {
            ipLabels.setValue((double)(++label));
            ipLabels.fill(roi);
        }
        return ipLabels;
    }

    public static ImageProcessor labelImage(ImageProcessor ip, float threshold, boolean conn8) {
        return IJProcessing.labelImage(ip, conn8 ? 8 : 4, d -> d > (double)threshold);
    }

    @Deprecated
    public static Roi[] labelsToConnectedROIs(ImageProcessor ipLabels, int n) {
        LogTools.warnOnce((Logger)logger, (String)"labelsToConnectedROIs is deprecated, use labelsToRoisArray instead");
        Roi[] array = IJProcessing.labelsToRoisArray(ipLabels);
        if (n == array.length) {
            return array;
        }
        return Arrays.copyOf(array, n);
    }

    public static void removeSmallAreas(ByteProcessor bp, double minPixels, boolean conn8) {
        RoiLabeling.removeByAreas(bp, minPixels, Double.POSITIVE_INFINITY, conn8);
    }

    public static int removeByAreas(ByteProcessor bp, double minPixels, double maxPixels, boolean conn8) {
        int i;
        int w = bp.getWidth();
        int h = bp.getHeight();
        int shortMax = 65535;
        ImageProcessor ipLabels = RoiLabeling.labelImage((ImageProcessor)bp, 0.5f, conn8);
        long[] histogram = new long[shortMax + 1];
        for (int i2 = 0; i2 < w * h; ++i2) {
            int val = (int)ipLabels.getf(i2);
            if (val == 0) continue;
            int n = val;
            histogram[n] = histogram[n] + 1L;
        }
        boolean[] histThresholded = new boolean[histogram.length];
        int nObjects = 0;
        for (i = 0; i < histThresholded.length; ++i) {
            boolean keepObject;
            boolean bl = keepObject = (double)histogram[i] >= minPixels && (double)histogram[i] <= maxPixels;
            if (!keepObject) continue;
            histThresholded[i] = true;
            ++nObjects;
        }
        for (i = 0; i < w * h; ++i) {
            int val = (int)ipLabels.getf(i);
            if (val == 0 || histThresholded[val]) continue;
            bp.set(i, 0);
        }
        return nObjects;
    }

    public static void fillOutside(ImageProcessor ip, Roi roi, double value) {
        if (roi.getType() == 0 && roi.getBounds().equals(new Rectangle(0, 0, ip.getWidth(), ip.getHeight()))) {
            return;
        }
        ByteProcessor bpMask = new ByteProcessor(ip.getWidth(), ip.getHeight());
        bpMask.setValue(1.0);
        bpMask.fill(roi);
        if (value == 0.0) {
            ip.copyBits((ImageProcessor)bpMask, 0, 0, 5);
        } else {
            float floatValue = (float)value;
            byte[] px = (byte[])bpMask.getPixels();
            for (int i = 0; i < px.length; ++i) {
                if (px[i] != 0) continue;
                ip.setf(i, floatValue);
            }
        }
    }

    public static void clearOutside(ImageProcessor ip, Roi roi) {
        RoiLabeling.fillOutside(ip, roi, 0.0);
    }
}

