/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.processing;

import ij.gui.Roi;
import ij.plugin.filter.RankFilters;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;
import java.util.Arrays;
import qupath.imagej.processing.RoiLabeling;
import qupath.imagej.processing.SimpleThresholding;

public class MorphologicalReconstruction {
    public static ByteProcessor binaryReconstruction(ByteProcessor bpMarker, ByteProcessor bpMask, boolean permitMaskChanges) {
        int i;
        if (!permitMaskChanges) {
            bpMask = (ByteProcessor)bpMask.duplicate();
            bpMarker = (ByteProcessor)bpMarker.duplicate();
        }
        FloodFiller ff = new FloodFiller((ImageProcessor)bpMask);
        bpMask.setValue(127.0);
        int width = bpMarker.getWidth();
        byte[] pxMarker = (byte[])bpMarker.getPixels();
        byte[] pxMask = (byte[])bpMask.getPixels();
        for (i = 0; i < pxMarker.length; ++i) {
            if (pxMarker[i] != -1 || pxMask[i] == 127) continue;
            ff.fill(i % width, i / width);
        }
        Arrays.fill(pxMarker, (byte)0);
        for (i = 0; i < pxMask.length; ++i) {
            if (pxMask[i] != 127) continue;
            pxMarker[i] = -1;
        }
        return bpMarker;
    }

    private static int dilateAndCompare(ImageProcessor ipMarker, ImageProcessor ipMask, boolean reverse, IntDequeue queue) {
        int vEnd;
        int hEnd;
        int hStart;
        int inc;
        Rectangle rect = ipMarker.getRoi();
        if (rect.width <= 0 || rect.height <= 0) {
            return 0;
        }
        if (reverse) {
            inc = -1;
            hStart = rect.x + rect.width - 1;
            vStart = rect.y + rect.height - 1;
            hEnd = rect.x - 1;
            vEnd = rect.y - 1;
        } else {
            inc = 1;
            hStart = rect.x;
            vStart = rect.y;
            hEnd = rect.x + rect.width;
            vEnd = rect.y + rect.height;
        }
        boolean populateQueue = queue != null;
        int width = ipMarker.getWidth();
        int changes = 0;
        boolean firstRow = true;
        for (int y = vStart; y != vEnd; y += inc) {
            float valP3;
            float valP2;
            float valP1;
            float valPrevious = ipMarker.getf(hStart, y);
            if (firstRow) {
                valP1 = valPrevious;
                valP2 = valPrevious;
                valP3 = valPrevious;
            } else {
                valP1 = valP2 = ipMarker.getf(hStart, y - inc);
            }
            boolean firstColumn = true;
            for (int x = hStart; x != hEnd; x += inc) {
                float valCurrent = ipMarker.getf(x, y);
                if (firstRow) {
                    valP1 = valCurrent;
                    valP2 = valCurrent;
                    valP3 = valCurrent;
                } else {
                    valP3 = x + inc != hEnd ? ipMarker.getf(x + inc, y - inc) : valCurrent;
                }
                float valNeighbourMax = valP1 >= valP2 ? valP1 : valP2;
                valNeighbourMax = valNeighbourMax >= valP3 ? valNeighbourMax : valP3;
                float f = valNeighbourMax = valNeighbourMax >= valPrevious ? valNeighbourMax : valPrevious;
                if (valCurrent < valNeighbourMax) {
                    float valNew;
                    float valMask = ipMask.getf(x, y);
                    float f2 = valNew = valNeighbourMax >= valMask ? valMask : valNeighbourMax;
                    if (valNew > valCurrent) {
                        valCurrent = valNew;
                        ipMarker.setf(x, y, valCurrent);
                        ++changes;
                    }
                }
                if (populateQueue) {
                    boolean addToQueue = false;
                    if (valPrevious < valCurrent && valPrevious < ipMask.getf(x - inc, y)) {
                        addToQueue = true;
                    } else if (!firstRow) {
                        if (!firstColumn && valP1 < valCurrent && valP1 < ipMask.getf(x - inc, y - inc)) {
                            addToQueue = true;
                        } else if (valP2 < valCurrent && valP2 < ipMask.getf(x, y - inc)) {
                            addToQueue = true;
                        } else if (valP3 < valCurrent && valP3 < ipMask.getf(x + inc, y - inc)) {
                            addToQueue = true;
                        }
                    }
                    if (addToQueue) {
                        queue.add(y * width + x);
                    }
                }
                valPrevious = valCurrent;
                valP1 = valP2;
                valP2 = valP3;
                firstColumn = false;
            }
            firstRow = false;
        }
        return changes;
    }

    private static void processPoint(ImageProcessor ipMarker, ImageProcessor ipMask, int ind, float val, IntDequeue queue) {
        float valTempMask;
        float valTempMarker = ipMarker.getf(ind);
        if (valTempMarker < val && valTempMarker < (valTempMask = ipMask.getf(ind))) {
            ipMarker.setf(ind, valTempMask <= val ? valTempMask : val);
            queue.add(ind);
        }
    }

    private static boolean processQueue(ImageProcessor ipMarker, ImageProcessor ipMask, IntDequeue queue) {
        Rectangle rect = ipMarker.getRoi();
        int x1 = rect.x;
        int y1 = rect.y;
        int x2 = x1 + rect.width;
        int y2 = y1 + rect.height;
        long counter = 0L;
        int width = ipMarker.getWidth();
        Thread currentThread = Thread.currentThread();
        while (!queue.isEmpty()) {
            if (++counter % 2500L == 0L && currentThread.isInterrupted()) {
                return false;
            }
            int ind = queue.remove();
            int x = ind % width;
            int y = ind / width;
            float val = ipMarker.getf(ind);
            if (x > x1) {
                MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind - 1, val, queue);
                if (y > y1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind - width - 1, val, queue);
                }
                if (y < y2 - 1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind + width - 1, val, queue);
                }
            }
            if (x < x2 - 1) {
                MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind + 1, val, queue);
                if (y > y1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind - width + 1, val, queue);
                }
                if (y < y2 - 1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind + width + 1, val, queue);
                }
            }
            if (y > y1) {
                MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind - width, val, queue);
            }
            if (y >= y2 - 1) continue;
            MorphologicalReconstruction.processPoint(ipMarker, ipMask, ind + width, val, queue);
        }
        return true;
    }

    public static boolean morphologicalReconstruction(ImageProcessor ipMarker, ImageProcessor ipMask) {
        int nPixels = ipMarker.getWidth() * ipMarker.getHeight();
        int nChanges = MorphologicalReconstruction.dilateAndCompare(ipMarker, ipMask, false, null);
        while ((double)nChanges / (double)nPixels > 0.1) {
            MorphologicalReconstruction.dilateAndCompare(ipMarker, ipMask, true, null);
            nChanges = MorphologicalReconstruction.dilateAndCompare(ipMarker, ipMask, false, null);
        }
        IntDequeue queue = new IntDequeue(nPixels / 4);
        MorphologicalReconstruction.dilateAndCompare(ipMarker, ipMask, true, queue);
        MorphologicalReconstruction.processQueue(ipMarker, ipMask, queue);
        return MorphologicalReconstruction.processQueue(ipMarker, ipMask, queue);
    }

    public static boolean validateMarkerMask(ImageProcessor ipMarker, ImageProcessor ipMask) {
        if (ipMarker.getWidth() != ipMask.getWidth() || ipMarker.getHeight() != ipMask.getHeight()) {
            return false;
        }
        ipMarker.copyBits(ipMask, 0, 0, 12);
        return true;
    }

    public static ImageProcessor openingByReconstruction(ImageProcessor ip, double radius) {
        RankFilters rf = new RankFilters();
        ImageProcessor ipReconstructed = ip.duplicate();
        ipReconstructed.setRoi(ip.getRoi());
        rf.rank(ipReconstructed, radius, 1);
        if (MorphologicalReconstruction.morphologicalReconstruction(ipReconstructed, ip)) {
            return ipReconstructed;
        }
        return null;
    }

    public static ImageProcessor closingByReconstruction(ImageProcessor ip, double radius) {
        ImageProcessor ipDuplicate = ip.duplicate();
        ipDuplicate.invert();
        ImageProcessor ipReconstructed = MorphologicalReconstruction.openingByReconstruction(ipDuplicate, radius);
        if (ipReconstructed != null) {
            ipReconstructed.invert();
        }
        return ipReconstructed;
    }

    public static void imposeMinima(FloatProcessor fp, Roi roi) {
        ImageProcessor fpOrig = fp.duplicate();
        fp.setValue(Double.NEGATIVE_INFINITY);
        fp.fill(roi);
        RoiLabeling.fillOutside((ImageProcessor)fp, roi, Double.POSITIVE_INFINITY);
        fpOrig.copyBits((ImageProcessor)fp, 0, 0, 12);
        fpOrig.multiply(-1.0);
        fp.multiply(-1.0);
        MorphologicalReconstruction.morphologicalReconstruction((ImageProcessor)fp, fpOrig);
        fp.multiply(-1.0);
    }

    public static void imposeMaxima(FloatProcessor fp, Roi roi) {
        ImageProcessor fpOrig = fp.duplicate();
        ImageStatistics stats = fp.getStatistics();
        fp.setValue(Double.POSITIVE_INFINITY);
        fp.fill(roi);
        RoiLabeling.fillOutside((ImageProcessor)fp, roi, Double.NEGATIVE_INFINITY);
        fpOrig.copyBits((ImageProcessor)fp, 0, 0, 13);
        MorphologicalReconstruction.morphologicalReconstruction((ImageProcessor)fp, fpOrig);
        fp.setValue(stats.max);
        fp.fill(roi);
    }

    public static void imposeMaxima(FloatProcessor fp, ImageProcessor ipMask) {
        int i;
        ImageProcessor fpOrig = fp.duplicate();
        ImageStatistics stats = fp.getStatistics();
        int w = fp.getWidth();
        int h = fp.getHeight();
        for (i = 0; i < w * h; ++i) {
            if (ipMask.getf(i) == 0.0f) {
                fp.setf(i, Float.NEGATIVE_INFINITY);
                continue;
            }
            fp.setf(i, Float.POSITIVE_INFINITY);
        }
        fpOrig.copyBits((ImageProcessor)fp, 0, 0, 13);
        MorphologicalReconstruction.morphologicalReconstruction((ImageProcessor)fp, fpOrig);
        for (i = 0; i < w * h; ++i) {
            if (ipMask.getf(i) == 0.0f) continue;
            fp.setf(i, (float)stats.max);
        }
    }

    static ImageProcessor getMaximaLabels(ImageProcessor ip, float threshold, int x1, int x2, int y1, int y2) {
        float minVal = ip instanceof FloatProcessor ? Float.NEGATIVE_INFINITY : 0.0f;
        ImageProcessor ip2 = ip.duplicate();
        for (int y = y1 + 1; y < y2 - 1; ++y) {
            float val = ip.getf(x1, y);
            float nextVal = ip.getf(x1 + 1, y);
            for (int x = x1 + 1; x < x2 - 1; ++x) {
                float lastVal = val;
                val = nextVal;
                nextVal = ip.getf(x + 1, y);
                if (val < threshold || val < lastVal || val < nextVal || !(val >= ip.getf(x - 1, y - 1)) || !(val >= ip.getf(x, y - 1)) || !(val >= ip.getf(x + 1, y - 1)) || !(val >= ip.getf(x - 1, y + 1)) || !(val >= ip.getf(x, y + 1)) || !(val >= ip.getf(x + 1, y + 1))) continue;
                ip2.setf(x, y, minVal);
            }
        }
        ip2.setRoi(ip.getRoi());
        return ip2;
    }

    public static ImageProcessor findRegionalMaxima(ImageProcessor ip, float threshold, boolean outputBinary) {
        ByteProcessor ipOutput;
        int y2;
        int y1;
        int x2;
        int x1;
        Rectangle bounds = ip.getRoi();
        if (bounds == null) {
            x1 = 0;
            x2 = ip.getWidth();
            y1 = 0;
            y2 = ip.getHeight();
        } else {
            x1 = bounds.x;
            x2 = bounds.x + bounds.width;
            y1 = bounds.y;
            y2 = bounds.y + bounds.height;
        }
        ImageProcessor ip2 = MorphologicalReconstruction.getMaximaLabels(ip, threshold, x1, x2, y1, y2);
        MorphologicalReconstruction.morphologicalReconstruction(ip2, ip);
        if (outputBinary) {
            ipOutput = SimpleThresholding.greaterThan(ip, ip2);
        } else {
            ip2.copyBits(ip, 0, 0, 8);
            ipOutput = ip2;
        }
        return ipOutput;
    }

    private static class IntDequeue {
        private static final int MAX_EXPANSION = 10240;
        private int[] array;
        private int head = 0;
        private int tail = 0;

        private IntDequeue(int capacity) {
            this.array = new int[capacity];
            this.head = 0;
            this.tail = 0;
        }

        public boolean isEmpty() {
            return this.tail == this.head;
        }

        private int remove() {
            ++this.head;
            return this.array[this.head - 1];
        }

        private void add(int val) {
            if (this.tail < this.array.length) {
                this.array[this.tail] = val;
                ++this.tail;
                return;
            }
            if (this.head != 0) {
                if (this.tail > this.head) {
                    System.arraycopy(this.array, this.head, this.array, 0, this.tail - this.head);
                }
                this.tail -= this.head;
                this.head = 0;
                this.array[this.tail] = val;
                ++this.tail;
                return;
            }
            int[] array2 = new int[Math.max(this.array.length * 2, 10240)];
            System.arraycopy(this.array, 0, array2, 0, this.array.length);
            this.array = array2;
            this.array[this.tail] = val;
            ++this.tail;
        }
    }
}

