/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.processing;

import ij.gui.Overlay;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.DoublePredicate;

public class IJProcessing {
    public static int CONNECTIVITY_4 = 4;
    public static int CONNECTIVITY_8 = 8;

    public static Roi autoThresholdToRoi(ImageProcessor ip, String method) {
        ip.setAutoThreshold(method);
        Roi roi = IJProcessing.thresholdToRoi(ip);
        ip.resetThreshold();
        return roi;
    }

    public static List<Roi> autoThresholdToSplitRois(ImageProcessor ip, String method, int connectivity) {
        ip.setAutoThreshold(method);
        List<Roi> rois = IJProcessing.thresholdToSplitRois(ip, connectivity);
        ip.resetThreshold();
        return rois;
    }

    public static Roi thresholdToRoi(ImageProcessor ip) {
        double max;
        if (!ip.isThreshold()) {
            return null;
        }
        int n = ip.getWidth() * ip.getHeight();
        boolean noPixels = true;
        double min = ip.getMinThreshold();
        if (min <= (max = ip.getMaxThreshold())) {
            for (int i = 0; i < n; ++i) {
                double val = ip.getf(i);
                if (!(val >= min) || !(val <= max)) continue;
                noPixels = false;
                break;
            }
        }
        if (noPixels) {
            return null;
        }
        return new ThresholdToSelection().convert(ip);
    }

    public static List<Roi> thresholdToSplitRois(ImageProcessor ip, int connectivity) {
        ImageProcessor ipLabels = IJProcessing.labelImage(ip, connectivity);
        return IJProcessing.labelsToRois(ipLabels);
    }

    public static ImageProcessor labelImage(ImageProcessor ip, int connectivity) {
        DoublePredicate predicate = IJProcessing.createThresholdPredicate(ip);
        return IJProcessing.labelImage(ip, connectivity, predicate);
    }

    private static DoublePredicate createThresholdPredicate(ImageProcessor ip) {
        if (!ip.isThreshold()) {
            return v -> false;
        }
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        return v -> v >= minThreshold && v <= maxThreshold;
    }

    public static ImageProcessor labelImage(ImageProcessor ip, int connectivity, DoublePredicate predicate) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        short shortMax = -1;
        ShortProcessor ipLabels = new ShortProcessor(w, h);
        short[] pxShort = (short[])ipLabels.getPixels();
        for (int i = 0; i < w * h; ++i) {
            double val = ip.getf(i);
            if (!predicate.test(val)) continue;
            pxShort[i] = shortMax;
        }
        FloodFiller ff = new FloodFiller((ImageProcessor)ipLabels);
        double label = 0.0;
        double maxSupported = 65535.0;
        for (int i = 0; i < pxShort.length; ++i) {
            if (pxShort[i] != shortMax) continue;
            if ((label += 1.0) == maxSupported) {
                ipLabels = ipLabels.convertToFloatProcessor();
                ff = new FloodFiller((ImageProcessor)ipLabels);
                maxSupported = -1.0;
            }
            ipLabels.setValue(label);
            if (connectivity == CONNECTIVITY_8) {
                ff.fill8(i % w, i / w);
                continue;
            }
            if (connectivity == CONNECTIVITY_4) {
                ff.fill(i % w, i / w);
                continue;
            }
            throw new IllegalArgumentException("Connectivity must be 4 or 8, but found " + connectivity);
        }
        ipLabels.setMinAndMax(0.0, label);
        return ipLabels;
    }

    public static Roi[] labelsToRoisArray(ImageProcessor ipLabels) {
        int n = (int)Math.ceil(ipLabels.getStatistics().max);
        return IJProcessing.labelsToRoisImpl(ipLabels, n);
    }

    public static List<Roi> labelsToRois(ImageProcessor ipLabels) {
        Roi[] rois = IJProcessing.labelsToRoisArray(ipLabels);
        ArrayList<Roi> list = new ArrayList<Roi>(rois.length);
        for (Roi r : rois) {
            if (r == null) continue;
            list.add(r);
        }
        return list;
    }

    private static Roi[] labelsToRoisImpl(ImageProcessor ipLabels, int n) {
        Roi[] rois = new Roi[n];
        int w = ipLabels.getWidth();
        int h = ipLabels.getHeight();
        ByteProcessor bpCompleted = new ByteProcessor(w, h);
        bpCompleted.setValue(255.0);
        ThresholdToSelection tts = new ThresholdToSelection();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float val;
                if (bpCompleted.get(x, y) != 0 || !((val = ipLabels.getf(x, y)) > 0.0f) || !(val <= (float)n)) continue;
                Wand wand = new Wand(ipLabels);
                ipLabels.resetThreshold();
                wand.autoOutline(x, y, (double)val, (double)val, 8);
                PolygonRoi roi = IJProcessing.wandToRoi(wand);
                ipLabels.setRoi((Roi)roi);
                ImageStatistics stats = ipLabels.getStatistics();
                if (stats.max != stats.min || rois[(int)val - 1] != null) {
                    ipLabels.setThreshold((double)val - 0.25, (double)val + 0.25, 2);
                    roi = tts.convert(ipLabels);
                }
                rois[(int)val - 1] = roi;
                bpCompleted.fill((Roi)roi);
            }
        }
        return rois;
    }

    public static PolygonRoi wandToRoi(Wand wand) {
        int n = wand.npoints;
        int[] x = Arrays.copyOf(wand.xpoints, n);
        int[] y = Arrays.copyOf(wand.ypoints, n);
        return new PolygonRoi(x, y, n, 4);
    }

    public static Overlay createOverlay(Collection<? extends Roi> rois) {
        Overlay overlay = new Overlay();
        for (Roi roi : rois) {
            overlay.add(roi);
        }
        return overlay;
    }

    public static <T extends ImageProcessor> T subtract(T ip, ImageProcessor ... ipOthers) {
        return IJProcessing.blitter(4, ip, ipOthers);
    }

    public static <T extends ImageProcessor> T add(T ip, ImageProcessor ... ipOthers) {
        return IJProcessing.blitter(3, ip, ipOthers);
    }

    public static <T extends ImageProcessor> T multiply(T ip, ImageProcessor ... ipOthers) {
        return IJProcessing.blitter(5, ip, ipOthers);
    }

    public static <T extends ImageProcessor> T divide(T ip, ImageProcessor ... ipOthers) {
        return IJProcessing.blitter(6, ip, ipOthers);
    }

    public static <T extends ImageProcessor> T max(T ip, ImageProcessor ... ipOthers) {
        return IJProcessing.blitter(13, ip, ipOthers);
    }

    public static <T extends ImageProcessor> T min(T ip, ImageProcessor ... ipOthers) {
        return IJProcessing.blitter(12, ip, ipOthers);
    }

    private static <T extends ImageProcessor> T blitter(int operation, T ip, ImageProcessor ... ipOthers) {
        ImageProcessor ipResult = ip.duplicate();
        for (ImageProcessor ip2 : ipOthers) {
            ipResult.copyBits(ip2, 0, 0, operation);
        }
        return (T)ipResult;
    }
}

