/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.processing;

import ij.plugin.filter.RankFilters;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.function.Consumer;
import qupath.imagej.processing.IJProcessing;
import qupath.imagej.processing.MorphologicalReconstruction;
import qupath.imagej.processing.SimpleThresholding;

public class IJFilters {
    public static ImageProcessor mean(ImageProcessor ip, double radius) {
        return IJFilters.rankFilter(ip, radius, 0);
    }

    public static ImageProcessor median(ImageProcessor ip, double radius) {
        return IJFilters.rankFilter(ip, radius, 4);
    }

    public static ImageProcessor maximum(ImageProcessor ip, double radius) {
        return IJFilters.rankFilter(ip, radius, 2);
    }

    public static ImageProcessor minimum(ImageProcessor ip, double radius) {
        return IJFilters.rankFilter(ip, radius, 1);
    }

    public static ImageProcessor dilate(ImageProcessor ip, double radius) {
        return IJFilters.maximum(ip, radius);
    }

    public static ImageProcessor erode(ImageProcessor ip, double radius) {
        return IJFilters.minimum(ip, radius);
    }

    public static ImageProcessor open(ImageProcessor ip, double radius) {
        ImageProcessor ip2 = ip.duplicate();
        IJFilters.rankFilterInPlace(ip2, radius, 1);
        IJFilters.rankFilterInPlace(ip2, radius, 2);
        return ip2;
    }

    public static ImageProcessor close(ImageProcessor ip, double radius) {
        ImageProcessor ip2 = ip.duplicate();
        IJFilters.rankFilterInPlace(ip2, radius, 2);
        IJFilters.rankFilterInPlace(ip2, radius, 1);
        return ip2;
    }

    public static ImageProcessor blackTopHat(ImageProcessor ip, double radius) {
        return IJProcessing.subtract(ip, IJFilters.open(ip, radius));
    }

    public static ImageProcessor whiteTopHat(ImageProcessor ip, double radius) {
        return IJProcessing.subtract(IJFilters.close(ip, radius), ip);
    }

    public static ImageProcessor openingByReconstruction(ImageProcessor ip, double radius) {
        return MorphologicalReconstruction.openingByReconstruction(ip, radius);
    }

    public static ImageProcessor closingByReconstruction(ImageProcessor ip, double radius) {
        return MorphologicalReconstruction.closingByReconstruction(ip, radius);
    }

    public static ByteProcessor regionalMaxima(ImageProcessor ip) {
        FloatProcessor ipMask = ip.convertToFloatProcessor();
        ImageProcessor ipMarker = ipMask.duplicate();
        ipMask.add(1.0);
        MorphologicalReconstruction.morphologicalReconstruction(ipMarker, (ImageProcessor)ipMask);
        return SimpleThresholding.greaterThan((ImageProcessor)ipMask, ipMarker);
    }

    public static ByteProcessor regionalMinima(ImageProcessor ip) {
        ImageProcessor ip2 = ip.duplicate();
        ip2.invert();
        return IJFilters.regionalMaxima(ip2);
    }

    public static FloatProcessor hMaxima(ImageProcessor ip, double h) {
        FloatProcessor fpMarker = ip.convertToFloatProcessor();
        ImageProcessor fpMask = fpMarker.duplicate();
        fpMarker.subtract(h);
        MorphologicalReconstruction.morphologicalReconstruction((ImageProcessor)fpMarker, fpMask);
        return fpMarker;
    }

    public static FloatProcessor hMinima(ImageProcessor ip, double h) {
        FloatProcessor fpMarker = ip.convertToFloatProcessor();
        fpMarker.multiply(-1.0);
        ImageProcessor fpMask = fpMarker.duplicate();
        fpMarker.subtract(h);
        MorphologicalReconstruction.morphologicalReconstruction((ImageProcessor)fpMarker, fpMask);
        fpMarker.multiply(-1.0);
        return fpMarker;
    }

    public static ByteProcessor extendedMaxima(ImageProcessor ip, double h) {
        FloatProcessor hmax = IJFilters.hMaxima(ip, h);
        return IJFilters.regionalMaxima((ImageProcessor)hmax);
    }

    public static ByteProcessor extendedMinima(ImageProcessor ip, double h) {
        ImageProcessor ipDuplicate = ip.duplicate();
        ipDuplicate.invert();
        return IJFilters.extendedMaxima(ipDuplicate, h);
    }

    public static ImageProcessor gaussian(ImageProcessor ip, double sigma) {
        return IJFilters.applyToDuplicateInPlace(ip, ip2 -> ip2.blurGaussian(sigma));
    }

    public static FloatProcessor differenceOfGaussians(ImageProcessor ip, double sigma1, double sigma2) {
        FloatProcessor fp1 = ip.convertToFloatProcessor();
        ImageProcessor fp2 = fp1.duplicate();
        fp1.blurGaussian(sigma1);
        fp2.blurGaussian(sigma2);
        return IJProcessing.subtract(fp1, fp2);
    }

    private static ImageProcessor rankFilter(ImageProcessor ip, double radius, int type) {
        return IJFilters.applyToDuplicateInPlace(ip, ip2 -> IJFilters.rankFilterInPlace(ip2, radius, type));
    }

    private static ImageProcessor applyToDuplicateInPlace(ImageProcessor ip, Consumer<ImageProcessor> consumer) {
        ImageProcessor ipDuplicate = ip.duplicate();
        consumer.accept(ipDuplicate);
        return ipDuplicate;
    }

    private static void rankFilterInPlace(ImageProcessor ip, double radius, int type) {
        new RankFilters().rank(ip, radius, type);
    }
}

