/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.images.writers;

import ij.ImagePlus;
import ij.io.FileSaver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import qupath.imagej.images.writers.AbstractWriterIJ;
import qupath.lib.common.GeneralTools;

public class ZipWriterIJ
extends AbstractWriterIJ {
    public String getName() {
        return "Zip (ImageJ)";
    }

    public String getDetails() {
        return "Write image as an ImageJ TIFF, zipped up inside a zip file. Preserves basic image metadata (e.g. pixel calibration).";
    }

    public boolean supportsRGB() {
        return true;
    }

    public Collection<String> getExtensions() {
        return Collections.singleton("zip");
    }

    @Override
    public void writeImage(ImagePlus imp, OutputStream stream) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(stream);){
            Object name = GeneralTools.stripExtension((String)imp.getTitle());
            if (name == null || ((String)name).isBlank()) {
                name = "image";
            }
            name = (String)name + ".tif";
            zos.putNextEntry(new ZipEntry(imp.getTitle()));
            zos.write(new FileSaver(imp).serialize());
        }
    }
}

