/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.images.writers;

import ij.IJ;
import ij.ImagePlus;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import qupath.imagej.tools.IJTools;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.writers.ImageWriter;
import qupath.lib.regions.RegionRequest;

abstract class AbstractWriterIJ
implements ImageWriter<BufferedImage> {
    AbstractWriterIJ() {
    }

    public boolean supportsT() {
        return true;
    }

    public boolean supportsZ() {
        return true;
    }

    public boolean supportsImageType(ImageServer<BufferedImage> server) {
        return true;
    }

    public boolean supportsPyramidal() {
        return false;
    }

    public boolean supportsPixelSize() {
        return true;
    }

    public void writeImage(ImageServer<BufferedImage> server, RegionRequest request, String pathOutput) throws IOException {
        PathImage<ImagePlus> pathImage = IJTools.convertToImagePlus(server, request);
        if (pathImage == null) {
            throw new IOException("Unable to extract region from from " + server.getPath());
        }
        this.writeImage((ImagePlus)pathImage.getImage(), pathOutput);
    }

    public void writeImage(ImageServer<BufferedImage> server, String pathOutput) throws IOException {
        ImagePlus imp = IJTools.extractHyperstack(server, RegionRequest.createInstance(server));
        if (imp == null) {
            throw new IOException("Unable to extract region from from " + server.getPath());
        }
        this.writeImage(imp, pathOutput);
    }

    public void writeImage(BufferedImage img, String pathOutput) throws IOException {
        ImagePlus imp = IJTools.convertToUncalibratedImagePlus("Title", img);
        this.writeImage(imp, pathOutput);
        imp.close();
    }

    public void writeImage(ImageServer<BufferedImage> server, RegionRequest region, OutputStream stream) throws IOException {
        PathImage<ImagePlus> pathImage = IJTools.convertToImagePlus(server, region);
        if (pathImage == null) {
            throw new IOException("Unable to extract region from from " + server.getPath());
        }
        this.writeImage((ImagePlus)pathImage.getImage(), stream);
    }

    public void writeImage(BufferedImage img, OutputStream stream) throws IOException {
        ImagePlus imp = IJTools.convertToUncalibratedImagePlus("Title", img);
        this.writeImage(imp, stream);
        imp.close();
    }

    public void writeImage(ImageServer<BufferedImage> server, OutputStream stream) throws IOException {
        ImagePlus imp = IJTools.extractHyperstack(server, RegionRequest.createInstance(server));
        if (imp == null) {
            throw new IOException("Unable to extract region from from " + server.getPath());
        }
        this.writeImage(imp, stream);
    }

    public Class<BufferedImage> getImageClass() {
        return BufferedImage.class;
    }

    public void writeImage(ImagePlus imp, String pathOutput) throws IOException {
        IJ.save((ImagePlus)imp, (String)pathOutput);
    }

    public abstract void writeImage(ImagePlus var1, OutputStream var2) throws IOException;
}

