/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.images.servers;

import ij.io.Opener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.images.servers.ImageJServer;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.FileFormatInfo;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;

public class ImageJServerBuilder
implements ImageServerBuilder<BufferedImage> {
    private static Logger logger = LoggerFactory.getLogger(ImageJServerBuilder.class);
    private static Set<String> UNSUPPORTED_FORMATS = IntStream.of(0, 10, 11, 18, 12).mapToObj(i -> Opener.types[i]).collect(Collectors.toSet());

    public ImageServer<BufferedImage> buildServer(URI uri, String ... args) {
        try {
            return new ImageJServer(uri, args);
        }
        catch (IOException e) {
            logger.debug("Unable to open {} with ImageJ: {}", (Object)uri, (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public ImageServerBuilder.UriImageSupport<BufferedImage> checkImageSupport(URI uri, String ... args) {
        float supportLevel = this.supportLevel(uri, args);
        return ImageServerBuilder.UriImageSupport.createInstance(this.getClass(), (float)supportLevel, (ImageServerBuilder.ServerBuilder)ImageServerBuilder.DefaultImageServerBuilder.createInstance(this.getClass(), null, (URI)uri, (String[])args));
    }

    private float supportLevel(URI uri, String ... args) {
        FileFormatInfo.ImageCheckType type = FileFormatInfo.checkType((URI)uri);
        String description = type.getDescription();
        if (description != null && description.toLowerCase().contains("imagej=")) {
            return 4.0f;
        }
        if (type.isURL()) {
            return 0.0f;
        }
        long width = type.getLargestImageWidth();
        long height = type.getLargestImageHeight();
        if (width > 0L && height > 0L && width * height >= Integer.MAX_VALUE) {
            return 0.0f;
        }
        Path path = GeneralTools.toPath((URI)uri);
        if (path == null) {
            return 0.0f;
        }
        String format = Opener.getFileFormat((String)path.toAbsolutePath().toString());
        Set unsupportedFormats = IntStream.of(0, 10, 11, 18, 12).mapToObj(i -> Opener.types[i]).collect(Collectors.toSet());
        if (unsupportedFormats.contains(format)) {
            return 0.0f;
        }
        return 1.0f;
    }

    public String getName() {
        return "ImageJ builder";
    }

    public String getDescription() {
        return "Read images using ImageJ's default methods - best for TIFF files originally written by ImageJ, with calibration data available";
    }

    public Class<BufferedImage> getImageType() {
        return BufferedImage.class;
    }

    public boolean matchClassName(String ... classNames) {
        for (String className : classNames) {
            if (!this.getClass().getName().equals(className) && !this.getClass().getSimpleName().equals(className) && !ImageJServer.class.getName().equals(className) && !ImageJServer.class.getSimpleName().equals(className) && !"imagej".equalsIgnoreCase(className)) continue;
            return true;
        }
        return false;
    }
}

