/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.images.servers;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.plugin.ImageInfo;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.images.servers.ImageJServerBuilder;
import qupath.imagej.tools.IJTools;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectReader;
import qupath.lib.objects.PathObjects;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class ImageJServer
extends AbstractTileableImageServer
implements PathObjectReader {
    private static final Logger logger = LoggerFactory.getLogger(ImageJServer.class);
    private ImageServerMetadata originalMetadata;
    private URI uri;
    private String[] args;
    private ImagePlus imp;
    private ColorModel colorModel;

    public ImageJServer(URI uri, String ... args) throws IOException {
        ArrayList<ImageChannel> channels;
        boolean is2D;
        PixelType pixelType;
        FileInfo[] info;
        long maxFileLength;
        long fileLength;
        this.uri = uri;
        Path filePath = GeneralTools.toPath((URI)uri);
        File file = filePath != null ? filePath.toFile() : null;
        String path = file == null ? uri.toString() : file.getAbsolutePath();
        long maxMemory = Runtime.getRuntime().maxMemory();
        if ((file != null && path.toLowerCase().endsWith(".tif") || path.toLowerCase().endsWith(".tiff")) && (fileLength = file == null ? Long.MAX_VALUE : file.length()) > (maxFileLength = Math.max(0xA00000L, maxMemory / 8L)) && (info = Opener.getTiffFileInfo((String)path)) != null && (info.length > 1 || info.length == 1 && info[0].nImages > 1)) {
            logger.debug("Opening {} as virtual stack", (Object)uri);
            this.imp = IJ.openVirtual((String)path);
        }
        if (this.imp == null) {
            logger.debug("Opening {} as ImagePlus", (Object)uri);
            this.imp = IJ.openImage((String)path);
        }
        if (this.imp == null) {
            throw new IOException("Could not open " + path + " with ImageJ");
        }
        double sizeBytes = this.imp.getSizeInBytes();
        if (!this.imp.getStack().isVirtual() && sizeBytes > (double)maxMemory / 16.0) {
            logger.warn("The image is very large relative to the available memory ({} MB / {} MB, {} %)", new Object[]{GeneralTools.formatNumber((double)(sizeBytes / 1048576.0), (int)1), GeneralTools.formatNumber((double)((double)maxMemory / 1048576.0), (int)1), GeneralTools.formatNumber((double)(sizeBytes / (double)maxMemory * 100.0), (int)1)});
            logger.warn("Consider saving the image in a pyramidal format, e.g. using 'QuPath convert-ome' from the command line to create a pyramidal OME-TIFF.");
        }
        Calibration cal = this.imp.getCalibration();
        double xMicrons = IJTools.tryToParseMicrons(cal.pixelWidth, cal.getXUnit());
        double yMicrons = IJTools.tryToParseMicrons(cal.pixelHeight, cal.getYUnit());
        double zMicrons = IJTools.tryToParseMicrons(cal.pixelDepth, cal.getZUnit());
        TimeUnit timeUnit = ImageJServer.parseTimeUnit(cal.getTimeUnit());
        double[] timepoints = null;
        if (timeUnit != null) {
            timepoints = new double[this.imp.getNFrames()];
            for (int i = 0; i < timepoints.length; ++i) {
                timepoints[i] = (double)i * cal.frameInterval;
            }
        }
        boolean isRGB = false;
        switch (this.imp.getType()) {
            case 4: {
                isRGB = true;
            }
            case 0: 
            case 3: {
                pixelType = PixelType.UINT8;
                break;
            }
            case 1: {
                pixelType = PixelType.UINT16;
                break;
            }
            case 2: {
                pixelType = PixelType.FLOAT32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImagePlus type " + this.imp.getType());
            }
        }
        boolean bl = is2D = this.imp.getNFrames() == 1 && this.imp.getNSlices() == 1;
        if (isRGB) {
            channels = ImageChannel.getDefaultRGBChannels();
        } else {
            String[] sliceLabels = null;
            int nChannels = this.imp.getNChannels();
            if (is2D && nChannels == this.imp.getStackSize()) {
                sliceLabels = new String[nChannels];
                HashSet<String> sliceLabelSet = new HashSet<String>();
                for (int s = 1; s <= nChannels; ++s) {
                    String sliceLabel = this.imp.getStack().getSliceLabel(s);
                    if (sliceLabel == null || !is2D || (sliceLabel = sliceLabel.split("\\R", 2)[0]).isBlank()) continue;
                    sliceLabels[s - 1] = sliceLabel;
                    sliceLabelSet.add(sliceLabel);
                }
                if (sliceLabelSet.size() < nChannels) {
                    sliceLabels = null;
                }
            }
            channels = new ArrayList<ImageChannel>(ImageChannel.getDefaultChannelList((int)this.imp.getNChannels()));
            if (sliceLabels != null || this.imp instanceof CompositeImage) {
                for (int channel = 0; channel < this.imp.getNChannels(); ++channel) {
                    String name = ((ImageChannel)channels.get(channel)).getName();
                    Integer color = ((ImageChannel)channels.get(channel)).getColor();
                    if (this.imp instanceof CompositeImage) {
                        LUT lut = ((CompositeImage)this.imp).getChannelLut(channel + 1);
                        int ind = lut.getMapSize() - 1;
                        color = lut.getRGB(ind);
                    }
                    if (sliceLabels != null) {
                        name = sliceLabels[channel];
                    }
                    channels.set(channel, ImageChannel.getInstance((String)name, (Integer)color));
                }
            }
        }
        this.args = args;
        ImageServerMetadata.Builder builder = new ImageServerMetadata.Builder().width(this.imp.getWidth()).height(this.imp.getHeight()).name(this.imp.getTitle()).channels(channels).sizeZ(this.imp.getNSlices()).sizeT(this.imp.getNFrames()).rgb(isRGB).pixelType(pixelType).zSpacingMicrons((Number)zMicrons).preferredTileSize(this.imp.getWidth(), this.imp.getHeight());
        if (!Double.isNaN(xMicrons + yMicrons)) {
            builder = builder.pixelSizeMicrons((Number)xMicrons, (Number)yMicrons);
        }
        if (timeUnit != null) {
            builder = builder.timepoints(timeUnit, timepoints);
        }
        this.originalMetadata = builder.build();
    }

    private static TimeUnit parseTimeUnit(String unit) {
        if (unit == null || unit.isBlank()) {
            return null;
        }
        switch (unit = unit.toLowerCase().strip()) {
            case "s": 
            case "sec": 
            case "second": 
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "ms": 
            case "msec": 
            case "millisecond": 
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "us": 
            case "usec": 
            case "microsecond": 
            case "microseconds": {
                return TimeUnit.MICROSECONDS;
            }
            case "ns": 
            case "nsec": 
            case "nanosecond": 
            case "nanoseconds": {
                return TimeUnit.NANOSECONDS;
            }
            case "min": 
            case "minute": 
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "h": 
            case "hr": 
            case "hour": 
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "d": 
            case "day": 
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        for (TimeUnit timeUnit : TimeUnit.values()) {
            if (!timeUnit.toString().equalsIgnoreCase((String)unit)) continue;
            return timeUnit;
        }
        return null;
    }

    public Collection<PathObject> readPathObjects() {
        Roi roi = this.imp.getRoi();
        Overlay overlay = this.imp.getOverlay();
        if (roi == null && (overlay == null || overlay.size() == 0)) {
            return Collections.emptyList();
        }
        ArrayList<PathObject> list = new ArrayList<PathObject>();
        if (roi != null) {
            list.add(this.roiToAnnotation(roi));
        }
        if (overlay != null) {
            for (Roi r : overlay.toArray()) {
                list.add(this.roiToAnnotation(r));
            }
        }
        return list;
    }

    private PathObject roiToAnnotation(Roi roiIJ) {
        ROI roi = IJTools.convertToROI(roiIJ, 0.0, 0.0, 1.0, IJTools.getImagePlane(roiIJ, this.imp));
        PathObject annotation = PathObjects.createAnnotationObject((ROI)roi);
        annotation.setLocked(true);
        IJTools.calibrateObject(annotation, roiIJ);
        return annotation;
    }

    public String dumpMetadata() {
        return new ImageInfo().getImageInfo(this.imp);
    }

    public Collection<URI> getURIs() {
        return Collections.singletonList(this.uri);
    }

    protected String createID() {
        return ((Object)((Object)this)).getClass().getName() + ": " + this.uri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage readTile(TileRequest tile) {
        BufferedImage img;
        ImagePlus imp2;
        RegionRequest request = tile.getRegionRequest();
        int z = request.getZ() + 1;
        int t = request.getT() + 1;
        int nChannels = this.nChannels();
        if (this.imp.getType() == 4) {
            nChannels = 1;
        }
        double downsample = request.getDownsample();
        int w = (int)Math.max(1L, Math.round((double)this.imp.getWidth() / downsample));
        int h = (int)Math.max(1L, Math.round((double)this.imp.getHeight() / downsample));
        Rectangle roi = null;
        if (request.getX() != 0 || request.getY() != 0 || request.getWidth() != this.imp.getWidth() || request.getHeight() != this.imp.getHeight()) {
            roi = new Rectangle(request.getX(), request.getY(), request.getWidth(), request.getHeight());
            ImagePlus imagePlus = this.imp;
            synchronized (imagePlus) {
                if (nChannels == 1) {
                    int ind = this.imp.getStackIndex(1, z, t);
                    ImageProcessor ip = this.imp.getStack().getProcessor(ind);
                    ip.setRoi(roi);
                    ip = ip.crop();
                    imp2 = this.imp.createImagePlus();
                    imp2.setProcessor(ip);
                    ip.resetRoi();
                } else {
                    this.imp.setRoi(roi);
                    Duplicator duplicator = new Duplicator();
                    imp2 = duplicator.run(this.imp, 1, nChannels, z, z, t, t);
                    this.imp.killRoi();
                }
            }
            if (imp2.getHeight() != request.getHeight() || imp2.getWidth() != request.getWidth()) {
                logger.warn("Unexpected image size {}x{} for request {}", new Object[]{this.imp.getWidth(), this.imp.getHeight(), request});
            }
            z = 1;
            t = 1;
            imp2.killRoi();
        } else {
            imp2 = this.imp;
        }
        if (downsample != 1.0) {
            if (roi != null) {
                w = (int)Math.max(1L, Math.round(roi.getWidth() / downsample));
                h = (int)Math.max(1L, Math.round(roi.getHeight() / downsample));
            }
            ImageStack stackNew = null;
            ImagePlus imagePlus = imp2;
            synchronized (imagePlus) {
                for (int i = 1; i <= nChannels; ++i) {
                    int ind = imp2.getStackIndex(i, z, t);
                    ImageProcessor ip = imp2.getStack().getProcessor(ind);
                    ip.setInterpolationMethod(1);
                    ip = ip.resize(w, h, true);
                    if (stackNew == null) {
                        stackNew = new ImageStack(ip.getWidth(), ip.getHeight());
                    }
                    stackNew.addSlice("Channel " + i, ip);
                }
            }
            imp2 = new ImagePlus(imp2.getTitle(), stackNew);
            imp2.setDimensions(nChannels, 1, 1);
            z = 1;
            t = 1;
        }
        ImagePlus imagePlus = imp2;
        synchronized (imagePlus) {
            img = ImageJServer.convertToBufferedImage(imp2, z, t, this.colorModel);
        }
        if (this.imp != imp2) {
            imp2.changes = false;
            imp2.close();
        }
        if (this.colorModel == null) {
            this.colorModel = img.getColorModel();
        }
        return img;
    }

    private static BufferedImage convertToBufferedImage(ImagePlus imp2, int z, int t, ColorModel colorModel) {
        int nChannels = imp2.getNChannels();
        int ind = imp2.getStackIndex(1, z, t);
        ImageProcessor ip = imp2.getStack().getProcessor(ind);
        BufferedImage img = null;
        int w = ip.getWidth();
        int h = ip.getHeight();
        if (!(ip instanceof ColorProcessor)) {
            if (colorModel == null) {
                colorModel = ip instanceof ByteProcessor ? ColorModelFactory.createColorModel((PixelType)PixelType.UINT8, (List)ImageChannel.getDefaultChannelList((int)nChannels)) : (ip instanceof ShortProcessor ? ColorModelFactory.createColorModel((PixelType)PixelType.UINT16, (List)ImageChannel.getDefaultChannelList((int)nChannels)) : ColorModelFactory.createColorModel((PixelType)PixelType.FLOAT32, (List)ImageChannel.getDefaultChannelList((int)nChannels)));
            }
            ImageProcessor imageProcessor = ip;
            Objects.requireNonNull(imageProcessor);
            ImageProcessor imageProcessor2 = imageProcessor;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteProcessor.class, ShortProcessor.class, FloatProcessor.class}, (Object)imageProcessor2, n)) {
                case 0: {
                    ByteProcessor byteProcessor = (ByteProcessor)imageProcessor2;
                    BandedSampleModel model = new BandedSampleModel(0, w, h, nChannels);
                    byte[][] bytes = new byte[nChannels][w * h];
                    for (int i = 0; i < nChannels; ++i) {
                        int sliceInd = imp2.getStackIndex(i + 1, z, t);
                        bytes[i] = (byte[])((byte[])imp2.getStack().getPixels(sliceInd)).clone();
                    }
                    DataBufferByte buffer = new DataBufferByte(bytes, w * h);
                    return new BufferedImage(colorModel, Raster.createWritableRaster(model, buffer, null), false, null);
                }
                case 1: {
                    ShortProcessor shortProcessor = (ShortProcessor)imageProcessor2;
                    BandedSampleModel model = new BandedSampleModel(1, w, h, nChannels);
                    short[][] bytes = new short[nChannels][w * h];
                    for (int i = 0; i < nChannels; ++i) {
                        int sliceInd = imp2.getStackIndex(i + 1, z, t);
                        bytes[i] = (short[])((short[])imp2.getStack().getPixels(sliceInd)).clone();
                    }
                    DataBufferUShort buffer = new DataBufferUShort(bytes, w * h);
                    return new BufferedImage(colorModel, Raster.createWritableRaster(model, buffer, null), false, null);
                }
                case 2: {
                    FloatProcessor floatProcessor = (FloatProcessor)imageProcessor2;
                    BandedSampleModel model = new BandedSampleModel(4, w, h, nChannels);
                    float[][] bytes = new float[nChannels][w * h];
                    for (int i = 0; i < nChannels; ++i) {
                        int sliceInd = imp2.getStackIndex(i + 1, z, t);
                        bytes[i] = (float[])((float[])imp2.getStack().getPixels(sliceInd)).clone();
                    }
                    DataBufferFloat buffer = new DataBufferFloat(bytes, w * h);
                    return new BufferedImage(colorModel, Raster.createWritableRaster(model, buffer, null), false, null);
                }
            }
            logger.error("Sorry, currently only RGB & single-channel images supported with ImageJ");
            return null;
        }
        img = ip.getBufferedImage();
        return img;
    }

    public String getServerType() {
        return "ImageJ server";
    }

    public ImageServerMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return ImageServerBuilder.DefaultImageServerBuilder.createInstance(ImageJServerBuilder.class, (ImageServerMetadata)this.getMetadata(), (URI)this.uri, (String[])this.args);
    }

    public void close() throws Exception {
        super.close();
        if (this.imp != null) {
            this.imp.changes = false;
            this.imp.close();
            this.imp = null;
        }
    }
}

