/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.tissue;

import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.RankFilters;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.MorphologicalReconstruction;
import qupath.imagej.processing.RoiLabeling;
import qupath.imagej.processing.SimpleThresholding;
import qupath.imagej.tools.IJTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractDetectionPlugin;
import qupath.lib.plugins.DetectionPluginTools;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.ShapeSimplifier;
import qupath.lib.roi.interfaces.ROI;

public class SimpleTissueDetection2
extends AbstractDetectionPlugin<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleTissueDetection2.class);
    private ParameterList params = new ParameterList().addIntParameter("threshold", "Threshold", 127, null, 0.0, 255.0, "Global threshold to use - defined in the range 0-255");
    private String lastResults = null;

    public SimpleTissueDetection2() {
        this.params.addDoubleParameter("requestedPixelSizeMicrons", "Requested pixel size", 20.0, GeneralTools.micrometerSymbol(), "Requested pixel size for detection resolution - higher values mean a less detailed (but faster) result.\nNote that if the resolution is set too high (leading to a huge image) it will be adjusted automatically.");
        this.params.addDoubleParameter("minAreaMicrons", "Minimum area", 10000.0, GeneralTools.micrometerSymbol() + "^2", "The minimum area for a detected region - smaller regions will be discarded");
        this.params.addDoubleParameter("maxHoleAreaMicrons", "Max fill area", 1000000.0, GeneralTools.micrometerSymbol() + "^2", "'Holes' occurring within the detected regions that are smaller than this will be filled in");
        this.params.addDoubleParameter("requestedDownsample", "Downsample", 50.0, null, "Amount to downsample the image - higher values indicate smaller images (and less detection).\nNote that if the downsample is set too low (leading to a huge image) it will be adjusted automatically.");
        this.params.addDoubleParameter("minAreaPixels", "Minimum area", 100000.0, "px^2", "The minimum area for a detected region - smaller regions will be discarded");
        this.params.addDoubleParameter("maxHoleAreaPixels", "Max fill area", 500.0, "px^2", "'Holes' occurring within the detected regions that are smaller than this will be filled in");
        this.params.addBooleanParameter("darkBackground", "Dark background", false, "Choose this option if the background is darker (e.g. in a fluorescence image) rather than brighter than the tissue");
        this.params.addBooleanParameter("smoothImage", "Smooth image", true, "Apply 3x3 mean filter to (downsampled) image to reduce noise before thresholding");
        this.params.addBooleanParameter("medianCleanup", "Cleanup with median filter", true, "Apply median filter to thresholded image to reduce small variations");
        this.params.addBooleanParameter("dilateBoundaries", "Expand boundaries", false, "Apply 3x3 maximum filter to binary image to increase region sizes");
        this.params.addBooleanParameter("smoothCoordinates", "Smooth coordinates", true, "Apply smoothing to region boundaries, to reduce 'blocky' appearance");
        this.params.addBooleanParameter("excludeOnBoundary", "Exclude on boundary", false, "Discard detection regions that touch the image boundary");
        this.params.addBooleanParameter("singleAnnotation", "Single annotation", true, "Create a single annotation object from all (possibly-disconnected) regions");
    }

    private static List<PathObject> convertToPathObjects(ByteProcessor bp, double minArea, boolean smoothCoordinates, Calibration cal, double downsample, double maxHoleArea, boolean excludeOnBoundary, boolean singleAnnotation, ImagePlane plane, List<PathObject> pathObjects) {
        List<PolygonRoi> rois = RoiLabeling.getFilledPolygonROIs((ImageProcessor)bp, 4);
        if (pathObjects == null) {
            pathObjects = new ArrayList<PathObject>(rois.size());
        }
        boolean fillAllHoles = maxHoleArea <= 0.0;
        ByteProcessor bpOrig = !fillAllHoles ? (ByteProcessor)bp.duplicate() : null;
        bp.setValue(255.0);
        for (PolygonRoi r : rois) {
            if (excludeOnBoundary) {
                Rectangle bounds = r.getBounds();
                if (bounds.x <= 0 || bounds.y <= 0 || bounds.x + bounds.width >= bp.getWidth() - 1 || bounds.y + bounds.height >= bp.getHeight() - 1) continue;
            }
            bp.setRoi((Roi)r);
            if (bp.getStatistics().area < minArea) continue;
            bp.fill((Roi)r);
            PolygonROI pathPolygon = IJTools.convertToPolygonROI(r, cal, downsample, plane);
            if (smoothCoordinates) {
                pathPolygon = ROIs.createPolygonROI((List)ShapeSimplifier.smoothPoints((List)pathPolygon.getAllPoints()), (ImagePlane)ImagePlane.getPlaneWithChannel((ROI)pathPolygon));
                pathPolygon = ShapeSimplifier.simplifyPolygon((PolygonROI)pathPolygon, (double)(downsample / 2.0));
            }
            pathObjects.add(PathObjects.createAnnotationObject((ROI)pathPolygon));
        }
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (!fillAllHoles) {
            bp.copyBits((ImageProcessor)bpOrig, 0, 0, 8);
            bp.setThreshold(127.0, Double.POSITIVE_INFINITY, 2);
            List<PathObject> holes = SimpleTissueDetection2.convertToPathObjects(bp, maxHoleArea, smoothCoordinates, cal, downsample, 0.0, false, false, plane, null);
            ArrayList areaList = new ArrayList();
            for (int ind = 0; ind < pathObjects.size() && !holes.isEmpty(); ++ind) {
                Object hole;
                PathObject pathObject = pathObjects.get(ind);
                PreparedGeometry geom = PreparedGeometryFactory.prepare((Geometry)pathObject.getROI().getGeometry());
                areaList.clear();
                Iterator<PathObject> iter = holes.iterator();
                while (iter.hasNext()) {
                    hole = iter.next();
                    if (!geom.covers(hole.getROI().getGeometry())) continue;
                    areaList.add(RoiTools.getArea((ROI)hole.getROI()));
                    iter.remove();
                }
                if (areaList.isEmpty()) continue;
                hole = (Area)areaList.get(0);
                for (int i = 1; i < areaList.size(); ++i) {
                    ((Area)hole).add((Area)areaList.get(i));
                    if (i % 100 != 0) continue;
                    logger.debug("Added hole " + i + "/" + areaList.size());
                    if (!Thread.currentThread().isInterrupted()) continue;
                    return null;
                }
                ROI pathROI = pathObject.getROI();
                if (!RoiTools.isShapeROI((ROI)pathROI)) continue;
                Area areaMain = RoiTools.getArea((ROI)pathROI);
                areaMain.subtract((Area)hole);
                pathROI = RoiTools.getShapeROI((Area)areaMain, (ImagePlane)pathROI.getImagePlane());
                pathObjects.set(ind, PathObjects.createAnnotationObject((ROI)pathROI));
            }
        }
        if (singleAnnotation) {
            ROI roi = null;
            for (PathObject annotation : pathObjects) {
                ROI currentShape = annotation.getROI();
                if (roi == null) {
                    roi = currentShape;
                    continue;
                }
                roi = RoiTools.combineROIs((ROI)roi, (ROI)currentShape, (RoiTools.CombineOp)RoiTools.CombineOp.ADD);
            }
            pathObjects.clear();
            if (roi != null) {
                pathObjects.add(PathObjects.createAnnotationObject(roi));
            }
        }
        for (PathObject pathObject : pathObjects) {
            ((PathAnnotationObject)pathObject).setLocked(true);
        }
        return pathObjects;
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        boolean micronsKnown = imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        this.params.setHiddenParameters(!micronsKnown, new String[]{"requestedPixelSizeMicrons", "minAreaMicrons", "maxHoleAreaMicrons"});
        this.params.setHiddenParameters(micronsKnown, new String[]{"requestedDownsample", "minAreaPixels", "maxHoleAreaPixels"});
        return this.params;
    }

    public String getName() {
        return "Simple tissue detection";
    }

    public String getLastResultsDescription() {
        return this.lastResults;
    }

    public String getDescription() {
        return "Detect one or more regions of interest by applying a global threshold";
    }

    protected void addRunnableTasks(ImageData<BufferedImage> imageData, PathObject parentObject, List<Runnable> tasks) {
        tasks.add(DetectionPluginTools.createRunnableTask((ObjectDetector)new GlobalThresholder(), (ParameterList)this.getParameterList(imageData), imageData, (PathObject)parentObject));
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        if (hierarchy.getTMAGrid() == null) {
            return Collections.singleton(hierarchy.getRootObject());
        }
        return hierarchy.getSelectionModel().getSelectedObjects().stream().filter(p -> p.isTMACore()).toList();
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        ArrayList<Class<? extends PathObject>> list = new ArrayList<Class<? extends PathObject>>();
        list.add(TMACoreObject.class);
        list.add(PathRootObject.class);
        return list;
    }

    class GlobalThresholder
    implements ObjectDetector<BufferedImage> {
        GlobalThresholder() {
        }

        public Collection<PathObject> runDetection(ImageData<BufferedImage> imageData, ParameterList params, ROI pathROI) throws IOException {
            double maxHoleArea;
            double minArea;
            double maxDimLimit;
            PixelCalibration cal;
            double downsample;
            ImageServer server;
            double maxDim = pathROI == null ? (double)Math.max(server.getWidth(), server.getHeight()) : Math.max(pathROI.getBoundsWidth(), pathROI.getBoundsHeight());
            if (!(maxDim / (downsample = (cal = (server = imageData.getServer()).getPixelCalibration()).hasPixelSizeMicrons() ? params.getDoubleParameterValue("requestedPixelSizeMicrons") / cal.getAveragedPixelSizeMicrons() : params.getDoubleParameterValue("requestedDownsample")) <= (maxDimLimit = 4000.0))) {
                logger.warn("Invalid requested downsample {} - will use {} instead", (Object)downsample, (Object)(maxDim / maxDimLimit));
                downsample = maxDim / maxDimLimit;
            }
            RegionRequest request = !RoiTools.isShapeROI((ROI)pathROI) ? RegionRequest.createInstance((String)server.getPath(), (double)downsample, (int)0, (int)0, (int)server.getWidth(), (int)server.getHeight()) : RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)pathROI);
            PathImage<ImagePlus> pathImage = IJTools.convertToImagePlus((ImageServer<BufferedImage>)server, request);
            double threshold = params.getIntParameterValue("threshold").intValue();
            double minAreaMicrons = 1.0;
            double maxHoleAreaMicrons = 1.0;
            double minAreaPixels = 1.0;
            double maxHoleAreaPixels = 1.0;
            if (cal.hasPixelSizeMicrons()) {
                minAreaMicrons = params.getDoubleParameterValue("minAreaMicrons");
                maxHoleAreaMicrons = params.getDoubleParameterValue("maxHoleAreaMicrons");
            } else {
                minAreaPixels = params.getDoubleParameterValue("minAreaPixels");
                maxHoleAreaPixels = params.getDoubleParameterValue("maxHoleAreaPixels");
            }
            boolean smoothImage = params.getBooleanParameterValue("smoothImage");
            boolean darkBackground = params.getBooleanParameterValue("darkBackground");
            boolean smoothCoordinates = params.getBooleanParameterValue("smoothCoordinates");
            boolean medianCleanup = params.getBooleanParameterValue("medianCleanup");
            boolean excludeOnBoundary = params.getBooleanParameterValue("excludeOnBoundary");
            boolean dilateBoundaries = params.getBooleanParameterValue("dilateBoundaries");
            boolean singleAnnotation = Boolean.TRUE.equals(params.getBooleanParameterValue("singleAnnotation"));
            ImagePlus imp = (ImagePlus)pathImage.getImage();
            ByteProcessor bp = imp.getProcessor().convertToByteProcessor();
            if (smoothImage) {
                bp.smooth();
            }
            bp = darkBackground ? SimpleThresholding.thresholdAbove((ImageProcessor)bp, threshold) : SimpleThresholding.thresholdBelow((ImageProcessor)bp, threshold);
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            if (medianCleanup) {
                RankFilters rf = new RankFilters();
                rf.rank((ImageProcessor)bp, 1.0, 4);
            }
            if (dilateBoundaries) {
                bp.filter(4);
            }
            Roi roiIJ = null;
            if (pathROI != null) {
                roiIJ = IJTools.convertToIJRoi(pathROI, imp.getCalibration(), downsample);
                RoiLabeling.clearOutside((ImageProcessor)bp, roiIJ);
            }
            if (excludeOnBoundary) {
                ByteProcessor bpMarker = new ByteProcessor(bp.getWidth(), bp.getHeight());
                bpMarker.setValue(255.0);
                bpMarker.drawRect(0, 0, bp.getWidth(), bp.getHeight());
                if (roiIJ != null) {
                    bpMarker.draw(roiIJ);
                }
                bpMarker.copyBits((ImageProcessor)bp, 0, 0, 9);
                ByteProcessor bpBoundary = MorphologicalReconstruction.binaryReconstruction(bpMarker, bp, false);
                bp.copyBits((ImageProcessor)bpBoundary, 0, 0, 4);
            }
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            if (cal.hasPixelSizeMicrons()) {
                double areaScale = 1.0 / (cal.getAveragedPixelSizeMicrons() * cal.getAveragedPixelSizeMicrons() * downsample * downsample);
                minArea = minAreaMicrons * areaScale;
                maxHoleArea = maxHoleAreaMicrons * areaScale;
            } else {
                minArea = minAreaPixels / (downsample * downsample);
                maxHoleArea = maxHoleAreaPixels / (downsample * downsample);
            }
            logger.debug("Min area: {}", (Object)minArea);
            logger.debug("Max hole area: {}", (Object)maxHoleArea);
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            bp.setThreshold(127.0, Double.POSITIVE_INFINITY, 2);
            List<PathObject> pathObjects = SimpleTissueDetection2.convertToPathObjects(bp, minArea, smoothCoordinates, imp.getCalibration(), downsample, maxHoleArea, excludeOnBoundary, singleAnnotation, pathImage.getImageRegion().getImagePlane(), null);
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            SimpleTissueDetection2.this.lastResults = pathObjects == null || pathObjects.isEmpty() ? "No regions detected!" : (pathObjects.size() == 1 ? "1 region detected" : pathObjects.size() + " regions detected");
            return pathObjects;
        }

        public String getLastResultsDescription() {
            return SimpleTissueDetection2.this.lastResults;
        }
    }
}

