/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.tissue;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.tools.IJTools;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.plugins.AbstractDetectionPlugin;
import qupath.lib.plugins.DetectionPluginTools;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

public class PositivePixelCounterIJ
extends AbstractDetectionPlugin<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(PositivePixelCounterIJ.class);
    private transient PositivePixelDetector detector;

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
        String stain1Name = stains == null ? "Hematoxylin" : stains.getStain(1).getName();
        String stain2Name = stains == null ? "DAB" : stains.getStain(2).getName();
        ParameterList params = new ParameterList().addIntParameter("downsampleFactor", "Downsample factor", 4, "", 1.0, 32.0, "Amount to downsample image prior to detection - higher values lead to smaller images (and faster but less accurate processing)").addDoubleParameter("gaussianSigmaMicrons", "Gaussian sigma", 2.0, GeneralTools.micrometerSymbol(), "Gaussian filter size - higher values give a smoother (less-detailed) result").addDoubleParameter("thresholdStain1", stain1Name + " threshold ('Negative')", 0.1, "OD units", "Threshold to use for 'Negative' detection").addDoubleParameter("thresholdStain2", stain2Name + " threshold ('Positive')", 0.3, "OD units", "Threshold to use for 'Positive' stain detection").addBooleanParameter("addSummaryMeasurements", "Add summary measurements to parent", true, "Add summary measurements to parent objects").addBooleanParameter("clearParentMeasurements", "Clear existing parent measurements", true, "Remove any existing measurements from parent objects").addBooleanParameter("appendDetectionParameters", "Add parameters to measurement names", false, "Append the detection parameters to any measurement names").addBooleanParameter("legacyMeasurements0.1.2", "Use legacy measurements (v0.1.2)", false, "Generate measurements compatible with QuPath v0.1.2");
        return params;
    }

    public String getName() {
        return "Detect positive staining (TMA, IHC)";
    }

    public String getDescription() {
        return "Determine positive pixel counts in an H-DAB stained image";
    }

    public String getLastResultsDescription() {
        return this.detector == null ? "" : this.detector.getLastResultsDescription();
    }

    protected void addRunnableTasks(ImageData<BufferedImage> imageData, PathObject parentObject, List<Runnable> tasks) {
        this.detector = new PositivePixelDetector(parentObject);
        tasks.add(DetectionPluginTools.createRunnableTask((ObjectDetector)this.detector, (ParameterList)this.getParameterList(imageData), imageData, (PathObject)parentObject));
    }

    static class PositivePixelDetector
    implements ObjectDetector<BufferedImage> {
        private final PathObject parent;
        private String lastMessage = null;

        PositivePixelDetector(PathObject parent) {
            this.parent = parent;
        }

        public Collection<PathObject> runDetection(ImageData<BufferedImage> imageData, ParameterList params, ROI pathROI) throws IOException {
            boolean isRGB;
            boolean useLegacyMeasurements;
            ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
            double downsample = Math.max(1, params.getIntParameterValue("downsampleFactor"));
            double thresholdStain1 = params.getDoubleParameterValue("thresholdStain1");
            double thresholdStain2 = params.getDoubleParameterValue("thresholdStain2");
            double gaussianSigmaMicrons = params.getDoubleParameterValue("gaussianSigmaMicrons");
            boolean clearParentMeasurements = Boolean.TRUE.equals(params.getBooleanParameterValue("clearParentMeasurements"));
            boolean appendDetectionParameters = Boolean.TRUE.equals(params.getBooleanParameterValue("appendDetectionParameters"));
            boolean bl = useLegacyMeasurements = params.containsKey((Object)"legacyMeasurements0.1.2") ? params.getBooleanParameterValue("legacyMeasurements0.1.2") : true;
            if (useLegacyMeasurements) {
                logger.warn("Legacy measurements will be made for compatibility with QuPath v0.1.2 - note that pixel counts will depend on the downsample selected!");
            }
            PixelCalibration cal = imageData.getServer().getPixelCalibration();
            double pixelSize = cal.getAveragedPixelSizeMicrons() * downsample;
            double gaussianSigma = gaussianSigmaMicrons / pixelSize;
            RegionRequest request = RegionRequest.createInstance((String)imageData.getServerPath(), (double)downsample, (ROI)pathROI);
            PathImage<ImagePlus> pathImage = IJTools.convertToImagePlus((ImageServer<BufferedImage>)imageData.getServer(), request);
            ImagePlus imp = (ImagePlus)pathImage.getImage();
            int w = imp.getWidth();
            int h = imp.getHeight();
            ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
            boolean bl2 = isRGB = stains != null && imp.getType() == 4;
            if (!isRGB) {
                logger.error("Only brightfield RGB images are supported!");
                return Collections.emptyList();
            }
            ColorProcessor cp = (ColorProcessor)imp.getProcessor();
            int[] rgb = (int[])cp.getPixels();
            float[] pxHematoxylin = ColorTransformer.getTransformedPixels((int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_1, null, (ColorDeconvolutionStains)stains);
            float[] pxDAB = ColorTransformer.getTransformedPixels((int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_2, null, (ColorDeconvolutionStains)stains);
            FloatProcessor fpHematoxylin = new FloatProcessor(w, h, pxHematoxylin);
            FloatProcessor fpDAB = new FloatProcessor(w, h, pxDAB);
            fpHematoxylin.blurGaussian(gaussianSigma);
            fpDAB.blurGaussian(gaussianSigma);
            ByteProcessor bpH = new ByteProcessor(w, h);
            ByteProcessor bpDAB = new ByteProcessor(w, h);
            if (pathROI != null && !(pathROI instanceof RectangleROI)) {
                bpH.set(1.0);
                Roi roi = IJTools.convertToIJRoi(pathROI, pathImage);
                bpH.setValue(0.0);
                bpH.fill(roi);
            }
            int nNegative = 0;
            int nPositive = 0;
            double sumPositive = 0.0;
            double sumNegative = 0.0;
            for (int i = 0; i < w * h; ++i) {
                if (bpH.get(i) != 0) continue;
                float valH = fpHematoxylin.getf(i);
                float valDAB = fpDAB.getf(i);
                if ((double)valDAB >= thresholdStain2) {
                    bpDAB.set(i, -1);
                    sumPositive += (double)valDAB;
                    ++nPositive;
                    continue;
                }
                if (!((double)valH >= thresholdStain1)) continue;
                bpH.set(i, -1);
                sumNegative += (double)valH;
                ++nNegative;
            }
            bpH.setThreshold(128.0, Double.MAX_VALUE, 2);
            bpDAB.setThreshold(128.0, Double.MAX_VALUE, 2);
            Roi roiStained = nNegative > 0 ? new ThresholdToSelection().convert((ImageProcessor)bpH) : null;
            Roi roiDAB = nPositive > 0 ? new ThresholdToSelection().convert((ImageProcessor)bpDAB) : null;
            double meanPositive = nPositive == 0 ? Double.NaN : sumPositive / (double)nPositive;
            double meanNegative = nNegative == 0 ? Double.NaN : sumNegative / (double)nNegative;
            boolean hasPixelSizeMicrons = cal.hasPixelSizeMicrons();
            Object areaUnits = hasPixelSizeMicrons ? GeneralTools.micrometerSymbol() + "^2" : "px^2";
            double pixelWidth = hasPixelSizeMicrons ? cal.getPixelWidthMicrons() : 1.0;
            double pixelHeight = hasPixelSizeMicrons ? cal.getPixelHeightMicrons() : 1.0;
            double areaNegative = 0.0;
            double areaPositive = 0.0;
            int maxDP = 3;
            String paramsString = "";
            if (appendDetectionParameters) {
                paramsString = String.format(" (d=%s, s=%s, tN=%s, tP=%s)", GeneralTools.formatNumber((double)downsample, (int)maxDP), GeneralTools.formatNumber((double)gaussianSigmaMicrons, (int)maxDP), GeneralTools.formatNumber((double)thresholdStain1, (int)maxDP), GeneralTools.formatNumber((double)thresholdStain2, (int)maxDP));
            }
            if (roiStained != null) {
                ROI roiTissue = IJTools.convertToROI(roiStained, pathImage);
                PathObject pathObject = PathObjects.createDetectionObject((ROI)roiTissue);
                PathClass pathClass = null;
                if (useLegacyMeasurements) {
                    pathObject.getMeasurementList().put("Num pixels", (double)nNegative);
                    pathObject.getMeasurementList().put("Mean hematoxylin OD", meanNegative);
                    pathClass = PathClass.getNegative(null);
                } else {
                    areaNegative = roiTissue.getScaledArea(pixelWidth, pixelHeight);
                    pathObject.getMeasurementList().put("Stained area " + (String)areaUnits + paramsString, areaNegative);
                    pathObject.getMeasurementList().put("Mean " + stains.getStain(1).getName() + " OD" + paramsString, meanNegative);
                    pathClass = PathClass.getInstance((String)"Pixel count negative", (Integer)ColorTools.makeScaledRGB((int)PathClass.getNegative(null).getColor(), (double)1.25));
                }
                pathObject.setPathClass(pathClass);
                pathObject.getMeasurementList().close();
                pathObjects.add(pathObject);
            }
            if (roiDAB != null) {
                ROI roiPositive = IJTools.convertToROI(roiDAB, pathImage);
                PathClass pathClass = null;
                PathObject pathObject = PathObjects.createDetectionObject((ROI)roiPositive);
                if (useLegacyMeasurements) {
                    pathObject.getMeasurementList().put("Num pixels", (double)nPositive);
                    pathObject.getMeasurementList().put("Mean DAB OD", meanPositive);
                    pathClass = PathClass.getPositive(null);
                } else {
                    areaPositive = roiPositive.getScaledArea(pixelWidth, pixelHeight);
                    pathObject.getMeasurementList().put("Stained area " + (String)areaUnits + paramsString, areaPositive);
                    pathObject.getMeasurementList().put("Mean " + stains.getStain(2).getName() + " OD" + paramsString, meanPositive);
                    pathClass = PathClass.getInstance((String)"Pixel count positive", (Integer)ColorTools.makeScaledRGB((int)PathClass.getPositive(null).getColor(), (double)1.25));
                }
                pathObject.setPathClass(pathClass);
                pathObject.getMeasurementList().close();
                pathObjects.add(pathObject);
            }
            boolean addMeasurements = params.getBooleanParameterValue("addSummaryMeasurements");
            double positivePercentage = (double)nPositive * 100.0 / (double)(nPositive + nNegative);
            if (clearParentMeasurements && !this.parent.getMeasurementList().isEmpty()) {
                this.parent.getMeasurementList().clear();
                this.parent.getMeasurementList().close();
            }
            if (addMeasurements) {
                if (useLegacyMeasurements) {
                    this.parent.getMeasurementList().put("Positive pixel %", positivePercentage);
                    this.parent.getMeasurementList().put("Positive pixel count", (double)nPositive);
                    this.parent.getMeasurementList().put("Negative pixel count", (double)nNegative);
                    this.parent.getMeasurementList().put("Mean positive DAB staining OD", meanPositive);
                    this.parent.getMeasurementList().put("Stained pixel count", (double)(nPositive + nNegative));
                    this.parent.getMeasurementList().close();
                } else {
                    boolean roisMatch;
                    this.parent.getMeasurementList().put("Positive % of stained pixels" + paramsString, positivePercentage);
                    this.parent.getMeasurementList().put("Positive pixel area " + (String)areaUnits + paramsString, areaPositive);
                    this.parent.getMeasurementList().put("Negative pixel area " + (String)areaUnits + paramsString, areaNegative);
                    this.parent.getMeasurementList().put("Stained area (Positive + Negative)" + (String)areaUnits + paramsString, areaPositive + areaNegative);
                    ROI roiParent = this.parent.getROI();
                    boolean bl3 = roisMatch = roiParent == pathROI;
                    if (!roisMatch) {
                        logger.warn("Unexpected mismatch between parent ROI & analysis ROI! No measurements based on ROI area will be added.");
                    }
                    if (roisMatch && roiParent.isArea()) {
                        double areaROI = roiParent.getScaledArea(pixelWidth, pixelHeight);
                        this.parent.getMeasurementList().put("Total ROI area " + (String)areaUnits + paramsString, areaROI);
                        this.parent.getMeasurementList().put("Positive % of total ROI area" + paramsString, Math.min(100.0, areaPositive / areaROI * 100.0));
                    }
                    this.parent.getMeasurementList().close();
                }
            }
            this.lastMessage = String.format("Stained positive percentage: %.2f%%", positivePercentage);
            return pathObjects;
        }

        public String getLastResultsDescription() {
            return this.lastMessage;
        }
    }
}

