/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.dearray;

import ij.ImagePlus;
import ij.plugin.ZProjector;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.detect.dearray.TMADearrayer;
import qupath.imagej.tools.IJTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.DefaultTMAGrid;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.SimplePluginWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class TMADearrayerPluginIJ
extends AbstractInteractivePlugin<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(TMADearrayerPluginIJ.class);
    private ParameterList params = new ParameterList();
    private transient Dearrayer dearrayer;

    public TMADearrayerPluginIJ() {
        this.params.addDoubleParameter("coreDiameterMM", "TMA core diameter", 1.2, "mm", "Enter the approximate diameter or each TMA core in mm");
        this.params.addDoubleParameter("coreDiameterPixels", "TMA core diameter", 5000.0, "px", "Enter the approximate diameter or each TMA core in pixels");
        this.params.addEmptyParameter("Enter the horizontal and vertical labels for each core, with a space between each label.");
        this.params.addEmptyParameter("The number of labels will define the array dimensions.");
        this.params.addEmptyParameter("Labels may also be entered as a range (e.g. 1-10 or A-G).");
        this.params.addStringParameter("labelsHorizontal", "Column labels", "1-16", "Enter column labels.\nThis can be a continuous range of letters or numbers (e.g. 1-10 or A-J),\nor a discontinuous list separated by spaces (e.g. A B C E F G).");
        this.params.addStringParameter("labelsVertical", "Row labels", "A-J", "Enter row labels.\nThis can be a continuous range of letters or numbers (e.g. 1-10 or A-J),\nor a discontinuous list separated by spaces (e.g. A B C E F G).");
        this.params.addChoiceParameter("labelOrder", "Label order", (Object)"Row first", Arrays.asList("Column first", "Row first"), "Create TMA labels either in the form Row-Column or Column-Row");
        this.params.addIntParameter("densityThreshold", "Density threshold", 5, "%", 0.0, 100.0, "Cores where a low density of tissue can be detected and excluded from later analysis (marked as 'missing').\nSet to 0 to include all cores (i.e. do not apply a density threshold).");
        this.params.addIntParameter("boundsScale", "Bounds scale factor", 105, "%", 50.0, 150.0, "Scaling factor to adjust the core size.\nA scale factor of 100% will give cores with the diameter specified above.\nA higher scale factor will increase the size, a lower factor will decrease the size.");
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        ArrayList<Class<? extends PathObject>> list = new ArrayList<Class<? extends PathObject>>(1);
        list.add(PathRootObject.class);
        return list;
    }

    protected void addRunnableTasks(ImageData<BufferedImage> imageData, PathObject parentObject, List<Runnable> tasks) {
        if (this.dearrayer == null) {
            this.dearrayer = new Dearrayer();
        }
        tasks.add(() -> {
            try {
                this.dearrayer.runDetection(imageData, this.getParameterList(imageData), null);
                TMAGrid tmaGrid = this.dearrayer.getTMAGrid();
                if (tmaGrid != null) {
                    imageData.getHierarchy().setTMAGrid(tmaGrid);
                }
            }
            catch (Exception e) {
                logger.error("Error running TMA dearrayer", (Throwable)e);
            }
        });
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        if (imageData.getServer().getPixelCalibration().hasPixelSizeMicrons()) {
            ((Parameter)this.params.getParameters().get("coreDiameterPixels")).setHidden(true);
            ((Parameter)this.params.getParameters().get("coreDiameterMM")).setHidden(false);
        } else {
            ((Parameter)this.params.getParameters().get("coreDiameterPixels")).setHidden(false);
            ((Parameter)this.params.getParameters().get("coreDiameterMM")).setHidden(true);
        }
        return this.params;
    }

    public String getName() {
        return "TMA dearrayer";
    }

    public String getLastResultsDescription() {
        return this.dearrayer == null ? "" : this.dearrayer.getLastResultsDescription();
    }

    public String getDescription() {
        return "Detect a grid of tissue cores on a Tissue Microarray";
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
        return Collections.singletonList(imageData.getHierarchy().getRootObject());
    }

    protected void addWorkflowStep(ImageData<BufferedImage> imageData, String arg) {
        SimplePluginWorkflowStep step = new SimplePluginWorkflowStep(this.getName(), ((Object)((Object)this)).getClass(), arg, "if (!isTMADearrayed()) {\n\t", "\n\treturn;\n}");
        imageData.getHistoryWorkflow().addStep((WorkflowStep)step);
        logger.info("{}", (Object)step);
    }

    static class Dearrayer
    implements ObjectDetector<BufferedImage> {
        private static final Logger logger = LoggerFactory.getLogger(Dearrayer.class);
        private ImageProcessor ip;
        private TMAGrid tmaGrid = null;
        private String lastMessage = null;
        private double fullCoreDiameterPx;
        private double downsample;
        private boolean isFluorescence;
        private String[] hLabels;
        private String[] vLabels;
        protected ByteProcessor bp = null;
        protected Polygon polyGrid = null;

        Dearrayer() {
        }

        public Collection<PathObject> runDetection(ImageData<BufferedImage> imageData, ParameterList params, ROI pathROI) throws IOException {
            PathImage<ImagePlus> pathImage;
            ImagePlus imp;
            double preferredPixelSizeMicrons;
            double downsample2;
            ImageServer server = imageData.getServer();
            PixelCalibration cal = server.getPixelCalibration();
            double fullCoreDiameterPx = cal.hasPixelSizeMicrons() ? params.getDoubleParameterValue("coreDiameterMM") / cal.getAveragedPixelSizeMicrons() * 1000.0 : params.getDoubleParameterValue("coreDiameterPixels");
            String horizontalLabels = params.getStringParameterValue("labelsHorizontal").trim();
            String verticalLabels = params.getStringParameterValue("labelsVertical").trim();
            boolean horizontalLabelFirst = params.getChoiceParameterValue("labelOrder").toString().startsWith("Column");
            boolean isFluorescence = imageData.isFluorescence();
            double densityThreshold = (double)params.getIntParameterValue("densityThreshold").intValue() * 0.01;
            double roiScaleFactor = (double)params.getIntParameterValue("boundsScale").intValue() * 0.01;
            logger.trace("ROI scale: " + roiScaleFactor);
            double maxDimLength = Math.max(server.getWidth(), server.getHeight());
            double dimRequested = 1200.0;
            double downsample = Math.pow(2.0, Math.round(Math.log(maxDimLength / dimRequested) / Math.log(2.0)));
            PixelCalibration pixelCalibration = server.getPixelCalibration();
            if (pixelCalibration.hasPixelSizeMicrons() && (downsample2 = (double)Math.round((preferredPixelSizeMicrons = 25.0) / pixelCalibration.getAveragedPixelSizeMicrons())) > 1.0 && maxDimLength / downsample2 < dimRequested * 2.0) {
                downsample = downsample2;
            }
            if ((imp = (ImagePlus)(pathImage = IJTools.convertToImagePlus((ImageServer<BufferedImage>)server, RegionRequest.createInstance((String)server.getPath(), (double)downsample, (int)0, (int)0, (int)server.getWidth(), (int)server.getHeight()))).getImage()).getType() == 4 || imp.getNChannels() == 1) {
                this.ip = imp.getProcessor();
            } else {
                ZProjector zProjector = new ZProjector(imp);
                zProjector.setMethod(0);
                zProjector.doProjection();
                this.ip = zProjector.getProjection().getProcessor();
            }
            this.bp = null;
            String[] hLabelsSplit = PathObjectTools.parseTMALabelString((String)horizontalLabels);
            String[] vLabelsSplit = PathObjectTools.parseTMALabelString((String)verticalLabels);
            this.updateGrid(this.tmaGrid, downsample);
            this.tmaGrid = this.doDearraying(fullCoreDiameterPx, downsample, densityThreshold, roiScaleFactor, isFluorescence, hLabelsSplit, vLabelsSplit, horizontalLabelFirst);
            return this.tmaGrid == null ? null : new ArrayList(this.tmaGrid.getTMACoreList());
        }

        public boolean updateGrid(TMAGrid tmaGrid, double downsample) {
            if (tmaGrid == null) {
                return false;
            }
            this.polyGrid = new Polygon();
            for (TMACoreObject core : tmaGrid.getTMACoreList()) {
                double x = core.getROI().getCentroidX() / downsample + 0.5;
                double y = core.getROI().getCentroidY() / downsample + 0.5;
                this.polyGrid.addPoint((int)x, (int)y);
            }
            return true;
        }

        public TMAGrid doDearraying(double fullCoreDiameterPx, double downsample, double densityThreshold, double roiScaleFactor, boolean isFluorescence, String[] hLabelsSplit, String[] vLabelsSplit, boolean horizontalLabelFirst) {
            this.lastMessage = null;
            if (this.fullCoreDiameterPx != fullCoreDiameterPx || this.downsample != downsample || this.isFluorescence != isFluorescence) {
                this.fullCoreDiameterPx = fullCoreDiameterPx;
                this.downsample = downsample;
                this.isFluorescence = isFluorescence;
                this.bp = null;
            }
            boolean recomputeGrid = true;
            if (this.hLabels == null || this.hLabels.length != hLabelsSplit.length || this.vLabels == null || this.vLabels.length != vLabelsSplit.length) {
                this.hLabels = hLabelsSplit;
                this.vLabels = vLabelsSplit;
                recomputeGrid = true;
                logger.info("Will (re)compute TMA grid...");
            }
            int nHorizontal = hLabelsSplit.length;
            int nVertical = vLabelsSplit.length;
            double coreDiameterPx = fullCoreDiameterPx / downsample;
            if (this.bp == null) {
                this.bp = TMADearrayer.makeBinaryImage(this.ip, coreDiameterPx, null, isFluorescence);
            }
            if (recomputeGrid) {
                TMADearrayer.TMAGridShape tmaGridShape = TMADearrayer.detectTMACoresFromBinary(this.bp, coreDiameterPx, nHorizontal, nVertical, null);
                if (tmaGridShape == null || tmaGridShape.nHorizontal * tmaGridShape.nVertical == 0) {
                    this.polyGrid = null;
                } else {
                    this.polyGrid = tmaGridShape.polyGrid;
                    nHorizontal = tmaGridShape.nHorizontal;
                    nVertical = tmaGridShape.nVertical;
                }
            }
            if (Thread.currentThread().isInterrupted() || this.polyGrid == null) {
                return null;
            }
            double[] coreDensities = TMADearrayer.computeDensities(this.bp, this.polyGrid, coreDiameterPx);
            ArrayList<TMACoreObject> coords = new ArrayList<TMACoreObject>();
            double coreSize = fullCoreDiameterPx * roiScaleFactor;
            int ind = 0;
            int nMissing = 0;
            for (int y = 0; y < nVertical; ++y) {
                for (int x = 0; x < nHorizontal && ind < this.polyGrid.npoints; ++x) {
                    double xx = (double)this.polyGrid.xpoints[ind] * downsample;
                    double yy = (double)this.polyGrid.ypoints[ind] * downsample;
                    String hLabel = hLabelsSplit[x];
                    String vLabel = vLabelsSplit[y];
                    Object name = "";
                    name = horizontalLabelFirst ? (String)name + hLabel + "-" + vLabel : (String)name + vLabel + "-" + hLabel;
                    boolean missing = coreDensities[ind] < densityThreshold;
                    TMACoreObject core = PathObjects.createTMACoreObject((double)xx, (double)yy, (double)coreSize, (boolean)missing);
                    core.setName((String)name);
                    coords.add(core);
                    ++ind;
                    if (!missing) continue;
                    ++nMissing;
                }
            }
            TMAGrid tmaGrid = DefaultTMAGrid.create(coords, (int)nHorizontal);
            this.lastMessage = String.format("%d x %d TMA grid created (%d missing)", nHorizontal, nVertical, nMissing);
            return tmaGrid;
        }

        public String getLastResultsDescription() {
            return this.lastMessage;
        }

        public TMAGrid getTMAGrid() {
            return this.tmaGrid;
        }
    }
}

