/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.dearray;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.ResultsTable;
import ij.plugin.RoiScaler;
import ij.plugin.filter.EDM;
import ij.plugin.filter.MaximumFinder;
import ij.plugin.filter.ParticleAnalyzer;
import ij.plugin.filter.RankFilters;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import qupath.imagej.processing.RoiLabeling;

public class TMADearrayer {
    static double[] computeDensities(ByteProcessor bp, Polygon polyGrid, double coreDiameterPx) {
        RankFilters rf = new RankFilters();
        FloatProcessor fp = bp.convertToFloatProcessor();
        fp.max(1.0);
        rf.rank((ImageProcessor)fp, coreDiameterPx * 0.5, 0);
        double[] densities = new double[polyGrid.npoints];
        for (int i = 0; i < densities.length; ++i) {
            int x = polyGrid.xpoints[i];
            int y = polyGrid.ypoints[i];
            if (x < 0 || y < 0 || x >= bp.getWidth() || y >= bp.getHeight()) continue;
            densities[i] = fp.getf(x, y);
        }
        return densities;
    }

    public static TMAGridShape detectTMACoresFromBinary(ByteProcessor bp, double coreDiameterPx, int nHorizontal, int nVertical, Roi roi) {
        return TMADearrayer.detectTMACoresFromBinary(null, bp, coreDiameterPx, nHorizontal, nVertical, roi);
    }

    private static TMAGridShape detectTMACoresFromBinary(FloatProcessor fpOrig, ByteProcessor bp, double coreDiameterPx, int nHorizontal, int nVertical, Roi roi) {
        Polygon polyDetected = new Polygon();
        ImageProcessor ipGood = TMADearrayer.identifyGoodCores(bp, coreDiameterPx, false, polyDetected);
        double angle = TMADearrayer.estimateRotation(polyDetected, coreDiameterPx);
        bp = (ByteProcessor)bp.duplicate();
        if (!Double.isNaN(angle)) {
            ipGood.setBackgroundValue(0.0);
            ipGood.max(1.0);
            ipGood.rotate(-angle);
            bp.setBackgroundValue(0.0);
            bp.rotate(-angle);
        }
        ByteProcessor bpGood = (ByteProcessor)ipGood.convertToByte(false);
        int[] xLocs = new int[nHorizontal];
        int[] yLocs = new int[nVertical];
        int nHorizontalDetected = TMADearrayer.estimateGrid(bpGood, xLocs, (int)coreDiameterPx, false);
        if (nHorizontalDetected <= 0) {
            return null;
        }
        int nVerticalDetected = TMADearrayer.estimateGrid(bpGood, yLocs, (int)coreDiameterPx, true);
        if (nVerticalDetected <= 0) {
            return null;
        }
        if (nHorizontalDetected < nHorizontal || nVerticalDetected < nVertical) {
            IJ.log((String)("Ensure the grid labels are correct - I can detect at most " + nVerticalDetected + " rows and " + nHorizontalDetected + " columns with the current settings (" + nVertical + " and " + nHorizontal + " requested)."));
        }
        Polygon polyGrid = new Polygon();
        for (int j = 0; j < nVerticalDetected; ++j) {
            int y = yLocs[j];
            for (int i = 0; i < nHorizontalDetected; ++i) {
                int x = xLocs[i];
                polyGrid.addPoint(x, y);
            }
        }
        TMADearrayer.refineGridCoordinatesByShifting(bp, polyGrid, nHorizontalDetected, coreDiameterPx);
        if (!Double.isNaN(angle) && angle != 0.0) {
            double xcenter = bpGood.getWidth() / 2;
            double ycenter = bpGood.getHeight() / 2;
            double theta = -angle * Math.PI / 180.0;
            for (int i = 0; i < polyGrid.npoints; ++i) {
                double dx = (double)polyGrid.xpoints[i] - xcenter;
                double dy = ycenter - (double)polyGrid.ypoints[i];
                double radius = Math.sqrt(dx * dx + dy * dy);
                double a = Math.atan2(dy, dx);
                double xNew = xcenter + radius * Math.cos(a + theta);
                double yNew = ycenter - radius * Math.sin(a + theta);
                polyGrid.xpoints[i] = (int)(xNew + 0.5);
                polyGrid.ypoints[i] = (int)(yNew + 0.5);
            }
        }
        return new TMAGridShape(polyGrid, nVerticalDetected, nHorizontalDetected);
    }

    private static ImageProcessor identifyGoodCores(ByteProcessor bp, double coreDiameterPx, boolean labelCores, Polygon polyCentroids) {
        double estimatedArea = Math.PI * (coreDiameterPx * coreDiameterPx) * 0.25;
        double minArea = estimatedArea * 0.5;
        double maxArea = estimatedArea * 2.0;
        return TMADearrayer.identifyGoodCores(bp, minArea, maxArea, 0.8, labelCores, polyCentroids);
    }

    private static ImageProcessor identifyGoodCores(ByteProcessor bp, double minArea, double maxArea, double minCircularity, boolean labelCores, Polygon polyCentroids) {
        bp.setThreshold(127.0, 512.0, 2);
        int options = labelCores ? 16 : 4096;
        int measurements = 32;
        ResultsTable rt = new ResultsTable();
        ParticleAnalyzer pa = new ParticleAnalyzer(options, measurements, rt, minArea, maxArea, minCircularity, 1.0);
        pa.setHideOutputImage(true);
        pa.analyze(new ImagePlus("Temp", (ImageProcessor)bp), (ImageProcessor)bp);
        if (polyCentroids != null) {
            for (int i = 0; i < rt.getCounter(); ++i) {
                int x = (int)(rt.getValueAsDouble(6, i) + 0.5);
                int y = (int)(rt.getValueAsDouble(7, i) + 0.5);
                polyCentroids.addPoint(x, y);
            }
        }
        return pa.getOutputImage().getProcessor();
    }

    public static ByteProcessor makeBinaryImage(ImageProcessor ip, double coreDiameterPx, Roi roi, boolean isFluorescence) {
        ip = ip instanceof ColorProcessor ? ip.convertToByte(false) : ip.duplicate();
        ip.resetRoi();
        RankFilters rf = new RankFilters();
        rf.rank(ip, 1.0, 4);
        if (!isFluorescence) {
            ip.invert();
        }
        double filterRadius = coreDiameterPx * 0.6;
        ImageProcessor ip2 = ip.duplicate();
        double downsample = Math.round(filterRadius / 10.0);
        if (downsample > 1.0) {
            ip2 = ip.resize((int)((double)ip.getWidth() / downsample + 0.5), (int)((double)ip.getHeight() / downsample + 0.5), true);
            rf.rank(ip2, filterRadius / downsample, 1);
            rf.rank(ip2, filterRadius / downsample, 2);
            ip2 = ip2.resize(ip.getWidth(), ip.getHeight());
        }
        ip.copyBits(ip2, 0, 0, 4);
        ip.smooth();
        ip.setAutoThreshold(AutoThresholder.Method.Triangle, true);
        ByteProcessor bp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        byte[] bpPixels = (byte[])bp.getPixels();
        double threshold = ip.getMinThreshold();
        for (int i = 0; i < bpPixels.length; ++i) {
            bpPixels[i] = (double)ip.getf(i) > threshold ? -1 : 0;
        }
        filterRadius = Math.max(1.0, coreDiameterPx * 0.02);
        rf.rank((ImageProcessor)bp, filterRadius, 2);
        rf.rank((ImageProcessor)bp, filterRadius, 1);
        rf.rank((ImageProcessor)bp, filterRadius, 1);
        rf.rank((ImageProcessor)bp, filterRadius, 2);
        RoiLabeling.fillHoles(bp);
        if (roi != null && roi.isArea()) {
            ip.setValue(0.0);
            ip.fillOutside(roi);
        }
        return bp;
    }

    private static boolean pointTooCloseX(Collection<Point> points, Point newPoint, double minDistance) {
        for (Point p : points) {
            if (!((double)Math.abs(p.x - newPoint.x) < minDistance)) continue;
            return true;
        }
        return false;
    }

    private static List<Point> processTopRowOfPoints(List<Point> sortedPoints, double coreDiameterPx, int nPointsPerRow) {
        ArrayList<Point> pointRow = new ArrayList<Point>(nPointsPerRow);
        pointRow.add(sortedPoints.remove(0));
        Iterator<Point> iter = sortedPoints.iterator();
        while (iter.hasNext()) {
            Point p = iter.next();
            if (TMADearrayer.pointTooCloseX(pointRow, p, coreDiameterPx)) continue;
            iter.remove();
            pointRow.add(p);
            if (pointRow.size() != nPointsPerRow) continue;
            break;
        }
        Collections.sort(pointRow, new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                return Integer.valueOf(p1.x).compareTo(p2.x);
            }
        });
        return pointRow;
    }

    public static Polygon fitCorePolygonToGrid(Polygon poly, double coreDiameterPx, int nHorizontal, int nVertical) {
        if (poly.npoints != nHorizontal * nVertical) {
            return null;
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < poly.npoints; ++i) {
            points.add(new Point(poly.xpoints[i], poly.ypoints[i]));
        }
        Collections.sort(points, new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                return Integer.valueOf(p1.y).compareTo(p2.y);
            }
        });
        Polygon poly2 = new Polygon();
        for (int j = 0; j < nVertical; ++j) {
            List<Point> pointRow = TMADearrayer.processTopRowOfPoints(points, coreDiameterPx, nHorizontal);
            for (int i = 0; i < pointRow.size(); ++i) {
                Point p = pointRow.get(i);
                poly2.addPoint(p.x, p.y);
            }
        }
        return poly2;
    }

    private static double estimateRotation(Polygon poly, double coreDiameterPx) {
        ArrayList<Double> angles = new ArrayList<Double>();
        for (int i = 0; i < poly.npoints; ++i) {
            int x = poly.xpoints[i];
            int y = poly.ypoints[i];
            for (int j = 0; j < poly.npoints; ++j) {
                int x2 = poly.xpoints[j];
                int y2 = poly.ypoints[j];
                if (x2 <= x || !((double)(x2 - x) < coreDiameterPx * 2.0) || !((double)Math.abs(y - y2) < coreDiameterPx)) continue;
                double angle = 57.29577951308232 * Math.atan2(y2 - y, x2 - x);
                angles.add(angle);
            }
        }
        if (angles.isEmpty()) {
            return Double.NaN;
        }
        Collections.sort(angles);
        if (angles.size() % 2 == 0) {
            return 0.5 * ((Double)angles.get(angles.size() / 2) + (Double)angles.get(angles.size() / 2 - 1));
        }
        return (Double)angles.get(angles.size() / 2);
    }

    private static boolean checkNewIndSeparated(int[] inds, int newInd, int nInds, int minSeparation) {
        for (int i = 0; i < nInds; ++i) {
            if (Math.abs(newInd - inds[i]) >= minSeparation) continue;
            return false;
        }
        return true;
    }

    private static int estimateGrid(ByteProcessor bp, int[] locs, int minSeparation, boolean doHorizontal) {
        int nMaxima = locs.length;
        int[] maxima = new int[nMaxima];
        Arrays.fill(maxima, -1);
        ImagePlus impTemp = new ImagePlus("Temp", (ImageProcessor)bp);
        impTemp.setRoi(new Roi(0, 0, bp.getWidth(), bp.getHeight()));
        double[] prof = new ProfilePlot(impTemp, doHorizontal).getProfile();
        double tolerance = 0.0;
        int[] peakLocs = MaximumFinder.findMaxima((double[])prof, (double)tolerance, (boolean)false);
        int n = 0;
        for (int p : peakLocs) {
            if (!TMADearrayer.checkNewIndSeparated(maxima, p, n, minSeparation)) continue;
            maxima[n] = p;
            if (++n == nMaxima) break;
        }
        Arrays.sort(maxima);
        int counter = 0;
        for (int m : maxima) {
            if (counter == nMaxima) break;
            if (m < 0) continue;
            locs[counter] = m;
            ++counter;
        }
        return counter;
    }

    private static Roi roiFromWand(Wand wand) {
        return new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 2);
    }

    private static Point findClosestMaximumInROI(ImageProcessor ip, Roi roi, Point p) {
        Rectangle bounds = roi.getBounds();
        Float maxVal = Float.valueOf(Float.NEGATIVE_INFINITY);
        Double minDist = Double.POSITIVE_INFINITY;
        Point maxPoint = null;
        int y1 = Math.max(0, bounds.y);
        int y2 = Math.min(ip.getHeight(), bounds.y + bounds.height);
        int x1 = Math.max(0, bounds.x);
        int x2 = Math.min(ip.getWidth(), bounds.x + bounds.width);
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                float val;
                if (!roi.contains(x, y) || !((val = ip.getf(x, y)) > maxVal.floatValue()) && (val != maxVal.floatValue() || !(p.distance(x, y) < minDist))) continue;
                maxVal = Float.valueOf(val);
                maxPoint = new Point(x, y);
                minDist = p.distance(x, y);
            }
        }
        return maxPoint;
    }

    private static void refineGridCoordinatesByShifting(ByteProcessor bp, Polygon polyGrid, int nHorizontal, double coreDiameterPx) {
        new EDM().toWatershed((ImageProcessor)bp);
        double estimatedArea = Math.PI * coreDiameterPx * coreDiameterPx * 0.25;
        FloatProcessor fpDensity = TMADearrayer.identifyGoodCores(bp, estimatedArea * 0.1, estimatedArea * 2.0, 0.0, false, null).convertToFloatProcessor();
        fpDensity.max(1.0);
        double minDiameter = coreDiameterPx * 0.7;
        Wand wand = new Wand((ImageProcessor)bp);
        boolean[] confirmed = new boolean[polyGrid.npoints];
        for (int i = 0; i < polyGrid.npoints; ++i) {
            boolean inside;
            int x = polyGrid.xpoints[i];
            int y = polyGrid.ypoints[i];
            boolean bl = inside = fpDensity.getf(x, y) > 0.0f;
            if (!inside) continue;
            wand.autoOutline(x, y, 0.0, 4);
            Roi roi = TMADearrayer.roiFromWand(wand);
            Rectangle bounds = roi.getBounds();
            if (!((double)bounds.width >= minDiameter) || !((double)bounds.height >= minDiameter)) continue;
            polyGrid.xpoints[i] = bounds.x + bounds.width / 2;
            polyGrid.ypoints[i] = bounds.y + bounds.height / 2;
            roi = RoiScaler.scale((Roi)roi, (double)1.0, (double)1.0, (boolean)true);
            fpDensity.setValue(-10000.0);
            fpDensity.fill(roi);
            confirmed[i] = true;
        }
        ByteProcessor bpTest = new ByteProcessor(bp.getWidth(), bp.getHeight());
        for (int i = 0; i < polyGrid.npoints; ++i) {
            if (confirmed[i]) continue;
            int x = polyGrid.xpoints[i];
            int y = polyGrid.ypoints[i];
            bpTest.setf(x, y, 255.0f);
        }
        try {
            FloatProcessor fpEDM = new EDM().makeFloatEDM((ImageProcessor)bpTest, -1, false);
            for (int i = 0; i < fpEDM.getWidth() * fpEDM.getHeight(); ++i) {
                fpEDM.setf(i, bpTest.getf(i) - fpEDM.getf(i));
            }
            ByteProcessor bpRegions = new MaximumFinder().findMaxima((ImageProcessor)fpEDM, 255.0, -808080.0, 2, false, false);
            byte[] pxRegions = (byte[])bpRegions.getPixels();
            float[] pxDensity = (float[])fpDensity.getPixels();
            for (int i = 0; i < pxRegions.length; ++i) {
                if (pxRegions[i] != 0) continue;
                pxDensity[i] = -10000.0f;
            }
        }
        catch (Exception e) {
            return;
        }
        new RankFilters().rank((ImageProcessor)fpDensity, coreDiameterPx * 0.5, 0);
        for (int i = 0; i < polyGrid.npoints; ++i) {
            int y;
            int x;
            OvalRoi roiRegion;
            Point maxPoint;
            if (confirmed[i] || (maxPoint = TMADearrayer.findClosestMaximumInROI((ImageProcessor)fpDensity, (Roi)(roiRegion = new OvalRoi((double)(x = polyGrid.xpoints[i]) - coreDiameterPx * 0.5, (double)(y = polyGrid.ypoints[i]) - coreDiameterPx * 0.5, coreDiameterPx, coreDiameterPx)), new Point(x, y))) == null) continue;
            polyGrid.xpoints[i] = maxPoint.x;
            polyGrid.ypoints[i] = maxPoint.y;
            confirmed[i] = true;
        }
    }

    static class TMAGridShape {
        public final int nVertical;
        public final int nHorizontal;
        public final Polygon polyGrid;

        private TMAGridShape(Polygon polyGrid, int nVertical, int nHorizontal) {
            this.polyGrid = polyGrid;
            this.nVertical = nVertical;
            this.nHorizontal = nHorizontal;
        }
    }
}

