/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.cells;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.EDM;
import ij.plugin.filter.MaximumFinder;
import ij.plugin.filter.RankFilters;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.detect.cells.ObjectMeasurements;
import qupath.imagej.processing.MorphologicalReconstruction;
import qupath.imagej.processing.RoiLabeling;
import qupath.imagej.processing.SimpleThresholding;
import qupath.imagej.processing.Watershed;
import qupath.imagej.tools.IJTools;
import qupath.imagej.tools.PixelImageIJ;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.stats.RunningStatistics;
import qupath.lib.analysis.stats.StatisticsHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.measurements.MeasurementListFactory;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.plugins.AbstractTileableDetectionPlugin;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.ShapeSimplifier;
import qupath.lib.roi.interfaces.ROI;

public class WatershedCellMembraneDetection
extends AbstractTileableDetectionPlugin<BufferedImage> {
    private static String[] micronParameters = new String[]{"requestedPixelSizeMicrons", "backgroundRadiusMicrons", "medianRadiusMicrons", "sigmaMicrons", "minAreaMicrons", "maxAreaMicrons", "cellExpansionMicrons"};
    private static String[] pixelParameters = new String[]{"backgroundRadius", "medianRadius", "sigma", "minArea", "maxArea", "cellExpansion"};
    private transient CellDetector detector;
    static String IMAGE_OPTICAL_DENSITY = "Optical density sum";
    static String IMAGE_HEMATOXYLIN = "Hematoxylin";
    private ParameterList params;

    public WatershedCellMembraneDetection() {
        Prefs.setThreads((int)1);
        this.params = new ParameterList();
        String microns = GeneralTools.micrometerSymbol();
        this.params.addTitleParameter("Setup parameters");
        this.params.addChoiceParameter("detectionImageBrightfield", "Choose detection image", (Object)IMAGE_HEMATOXYLIN, Arrays.asList(IMAGE_HEMATOXYLIN, IMAGE_OPTICAL_DENSITY), "Transformed image to which to apply the detection");
        this.params.addDoubleParameter("requestedPixelSizeMicrons", "Requested pixel size", 0.5, microns, "Choose pixel size at which detection will be performed - higher values are likely to be faster, but may be less accurate; set <= 0 to use the full image resolution");
        this.params.addTitleParameter("Nucleus parameters");
        this.params.addDoubleParameter("backgroundRadiusMicrons", "Background radius", 8.0, microns, "Radius for background estimation, should be > the largest nucleus radius, or <= 0 to turn off background subtraction");
        this.params.addDoubleParameter("medianRadiusMicrons", "Median filter radius", 0.0, microns, "Radius of median filter used to reduce image texture (optional)");
        this.params.addDoubleParameter("sigmaMicrons", "Sigma", 1.5, microns, "Sigma value for Gaussian filter used to reduce noise; increasing the value stops nuclei being fragmented, but may reduce the accuracy of boundaries");
        this.params.addDoubleParameter("minAreaMicrons", "Minimum area", 10.0, microns + "^2", "Detected nuclei with an area < minimum area will be discarded");
        this.params.addDoubleParameter("maxAreaMicrons", "Maximum area", 1000.0, microns + "^2", "Detected nuclei with an area > maximum area will be discarded");
        this.params.addDoubleParameter("backgroundRadius", "Background radius", 15.0, "px", "Radius for background estimation, should be > the largest nucleus radius, or <= 0 to turn off background subtraction");
        this.params.addDoubleParameter("medianRadius", "Median filter radius", 0.0, "px", "Radius of median filter used to reduce image texture (optional)");
        this.params.addDoubleParameter("sigma", "Sigma", 3.0, "px", "Sigma value for Gaussian filter used to reduce noise; increasing the value stops nuclei being fragmented, but may reduce the accuracy of boundaries");
        this.params.addDoubleParameter("minArea", "Minimum area", 10.0, "px^2", "Detected nuclei with an area < minimum area will be discarded");
        this.params.addDoubleParameter("maxArea", "Maximum area", 1000.0, "px^2", "Detected nuclei with an area > maximum area will be discarded");
        this.params.addDoubleParameter("threshold", "Threshold", 0.1, null, 0.0, 2.5, "Intensity threshold - detected nuclei must have a mean intensity >= threshold");
        this.params.addDoubleParameter("maxBackground", "Max background intensity", 2.0, null, "If background radius > 0, detected nuclei occurring on a background > max background intensity will be discarded");
        this.params.addBooleanParameter("watershedPostProcess", "Split by shape", true, "Split merged detected nuclei based on shape ('roundness')");
        this.params.addBooleanParameter("excludeDAB", "Exclude DAB (membrane staining)", true, "Set to 'true' if regions of high DAB staining should not be considered nuclei; useful if DAB stains cell membranes");
        this.params.addTitleParameter("Cell parameters");
        this.params.addDoubleParameter("cellExpansionMicrons", "Cell expansion", 8.0, microns, 0.0, 25.0, "Amount by which to expand detected nuclei to approximate the full cell area");
        this.params.addDoubleParameter("cellExpansion", "Cell expansion", 10.0, "px", "Amount by which to expand detected nuclei to approximate the full cell area");
        this.params.addBooleanParameter("limitExpansionByNucleusSize", "Limit cell expansion by nucleus size", false, "If checked, nuclei will not be expanded by more than their (estimated) smallest diameter in any direction - may give more realistic results for smaller, or 'thinner' nuclei");
        this.params.addBooleanParameter("includeNuclei", "Include cell nucleus", true, "If cell expansion is used, optionally include/exclude the nuclei within the detected cells");
        this.params.addTitleParameter("General parameters");
        this.params.addBooleanParameter("smoothBoundaries", "Smooth boundaries", false, "Smooth the detected nucleus/cell boundaries");
        this.params.addBooleanParameter("makeMeasurements", "Make measurements", true, "Add default shape & intensity measurements during detection");
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        Map map = this.params.getParameters();
        boolean pixelSizeKnown = imageData.getServer() != null && imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        for (String name : micronParameters) {
            ((Parameter)map.get(name)).setHidden(!pixelSizeKnown);
        }
        for (String name : pixelParameters) {
            ((Parameter)map.get(name)).setHidden(pixelSizeKnown);
        }
        ((Parameter)map.get("detectionImageBrightfield")).setHidden(imageData.getColorDeconvolutionStains() == null);
        ((Parameter)map.get("excludeDAB")).setHidden(imageData.getColorDeconvolutionStains() == null || !imageData.getColorDeconvolutionStains().isH_DAB());
        ((Parameter)map.get("makeMeasurements")).setHidden(!imageData.isBrightfield());
        return this.params;
    }

    public String getName() {
        return "Watershed cell detection";
    }

    public String getLastResultsDescription() {
        return this.detector == null ? "" : this.detector.getLastResultsDescription();
    }

    public String getDescription() {
        return "Default cell detection algorithm for brightfield images with membrane staining";
    }

    protected double getPreferredPixelSizeMicrons(ImageData<BufferedImage> imageData, ParameterList params) {
        return CellDetector.getPreferredPixelSizeMicrons(imageData, params);
    }

    protected ObjectDetector<BufferedImage> createDetector(ImageData<BufferedImage> imageData, ParameterList params) {
        return new CellDetector();
    }

    protected int getTileOverlap(ImageData<BufferedImage> imageData, ParameterList params) {
        double pxSize = imageData.getServer().getPixelCalibration().getAveragedPixelSizeMicrons();
        if (Double.isNaN(pxSize)) {
            return params.getDoubleParameterValue("cellExpansion") > 0.0 ? 25 : 10;
        }
        double cellExpansion = params.getDoubleParameterValue("cellExpansionMicrons") / pxSize;
        int overlap = cellExpansion > 0.0 ? (int)(cellExpansion * 2.0) : 10;
        return overlap;
    }

    static class CellDetector
    implements ObjectDetector<BufferedImage> {
        private List<PathObject> pathObjects = null;
        private boolean nucleiClassified = false;

        CellDetector() {
        }

        public static double getPreferredPixelSizeMicrons(ImageData<BufferedImage> imageData, ParameterList params) {
            PixelCalibration cal = imageData.getServer().getPixelCalibration();
            if (cal.hasPixelSizeMicrons()) {
                double requestedPixelSize = params.getDoubleParameterValue("requestedPixelSizeMicrons");
                double averagedPixelSize = cal.getAveragedPixelSizeMicrons();
                if (requestedPixelSize < 0.0) {
                    requestedPixelSize = averagedPixelSize * -requestedPixelSize;
                }
                requestedPixelSize = Math.max(requestedPixelSize, averagedPixelSize);
                return requestedPixelSize;
            }
            return Double.NaN;
        }

        public Collection<PathObject> runDetection(ImageData<BufferedImage> imageData, ParameterList params, ROI pathROI) throws IOException {
            double cellExpansion;
            double maxArea;
            double minArea;
            double sigma;
            double medianRadius;
            double backgroundRadius;
            if (pathROI == null) {
                return null;
            }
            PathImage<ImagePlus> pathImage = null;
            ImageServer server = imageData.getServer();
            pathImage = IJTools.convertToImagePlus((ImageServer<BufferedImage>)server, RegionRequest.createInstance((String)server.getPath(), (double)ServerTools.getDownsampleFactor((ImageServer)server, (double)CellDetector.getPreferredPixelSizeMicrons(imageData, params)), (ROI)pathROI));
            boolean isBrightfield = imageData.isBrightfield();
            FloatProcessor fpDetection = null;
            FloatProcessor fpH = null;
            FloatProcessor fpDAB = null;
            ImageProcessor ip = ((ImagePlus)pathImage.getImage()).getProcessor();
            ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
            if (ip instanceof ColorProcessor && stains != null) {
                FloatProcessor[] fps = IJTools.colorDeconvolve((ColorProcessor)ip, stains);
                fpH = fps[0];
                fpDAB = stains.isH_DAB() ? fps[1] : null;
                if (!((Parameter)params.getParameters().get("detectionImageBrightfield")).isHidden()) {
                    fpDetection = params.getChoiceParameterValue("detectionImageBrightfield").equals(IMAGE_OPTICAL_DENSITY) ? IJTools.convertToOpticalDensitySum((ColorProcessor)ip, stains.getMaxRed(), stains.getMaxGreen(), stains.getMaxBlue()) : (FloatProcessor)fpH.duplicate();
                }
            }
            if (fpDetection == null) {
                fpDetection = ip.convertToFloatProcessor();
                fpH = ip.convertToFloatProcessor();
                fpDAB = null;
            }
            Roi roi = null;
            if (pathROI != null) {
                roi = IJTools.convertToIJRoi(pathROI, pathImage);
            }
            WatershedCellDetector detector2 = new WatershedCellDetector(fpDetection, fpH, fpDAB, roi, pathImage);
            if (this.pathObjects == null) {
                this.pathObjects = new ArrayList<PathObject>();
            } else {
                this.pathObjects.clear();
            }
            if (pathImage.getPixelCalibration().hasPixelSizeMicrons()) {
                double pixelSize = pathImage.getPixelCalibration().getAveragedPixelSizeMicrons();
                backgroundRadius = params.getDoubleParameterValue("backgroundRadiusMicrons") / pixelSize;
                medianRadius = params.getDoubleParameterValue("medianRadiusMicrons") / pixelSize;
                sigma = params.getDoubleParameterValue("sigmaMicrons") / pixelSize;
                minArea = params.getDoubleParameterValue("minAreaMicrons") / (pixelSize * pixelSize);
                maxArea = params.getDoubleParameterValue("maxAreaMicrons") / (pixelSize * pixelSize);
                cellExpansion = params.getDoubleParameterValue("cellExpansionMicrons") / pixelSize;
            } else {
                backgroundRadius = params.getDoubleParameterValue("backgroundRadius");
                medianRadius = params.getDoubleParameterValue("medianRadius");
                sigma = params.getDoubleParameterValue("sigma");
                minArea = params.getDoubleParameterValue("minArea");
                maxArea = params.getDoubleParameterValue("maxArea");
                cellExpansion = params.getDoubleParameterValue("cellExpansion");
            }
            detector2.runDetection(backgroundRadius, params.getDoubleParameterValue("maxBackground"), medianRadius, sigma, params.getDoubleParameterValue("threshold"), minArea, maxArea, true, params.getBooleanParameterValue("watershedPostProcess"), params.getBooleanParameterValue("excludeDAB"), cellExpansion, params.getBooleanParameterValue("limitExpansionByNucleusSize"), params.getBooleanParameterValue("smoothBoundaries"), params.getBooleanParameterValue("includeNuclei"), params.getBooleanParameterValue("makeMeasurements") != false && isBrightfield);
            this.pathObjects.addAll(detector2.getPathObjects());
            return this.pathObjects;
        }

        public String getLastResultsDescription() {
            if (this.pathObjects == null) {
                return null;
            }
            int nDetections = this.pathObjects.size();
            if (nDetections == 1) {
                return "1 nucleus detected";
            }
            String s = String.format("%d nuclei detected", nDetections);
            if (this.nucleiClassified) {
                int nPositive = PathObjectTools.countObjectsWithClass(this.pathObjects, (PathClass)PathClass.getPositive(null), (boolean)false);
                int nNegative = PathObjectTools.countObjectsWithClass(this.pathObjects, (PathClass)PathClass.getNegative(null), (boolean)false);
                return String.format("%s (%.3f%% positive)", s, (double)nPositive * 100.0 / (double)(nPositive + nNegative));
            }
            return s;
        }
    }

    static class WatershedCellDetector {
        private static final Logger logger = LoggerFactory.getLogger(WatershedCellDetector.class);
        private boolean refineBoundary = true;
        private double backgroundRadius = 15.0;
        private double maxBackground = 0.3;
        private boolean lastRunCompleted = false;
        private boolean includeNuclei = true;
        private double cellExpansion = 0.0;
        private double minArea = 0.0;
        private double maxArea = 0.0;
        private double medianRadius = 2.0;
        private double sigma = 2.5;
        private double threshold = 0.3;
        private boolean mergeAll = true;
        private boolean watershedPostProcess = true;
        private boolean excludeDAB = false;
        private boolean smoothBoundaries = false;
        private boolean limitExpansionByNucleusSize = false;
        private boolean makeMeasurements = true;
        private Roi roi = null;
        private FloatProcessor fpDetection = null;
        private FloatProcessor fpH = null;
        private FloatProcessor fpDAB = null;
        private ImageProcessor ipToMeasure = null;
        private ImageProcessor ipBackground = null;
        private List<PolygonRoi> rois = null;
        private ByteProcessor bpLoG = null;
        private List<PolygonRoi> roisNuclei = new ArrayList<PolygonRoi>();
        private List<PathObject> pathObjects = new ArrayList<PathObject>();
        private PathImage<ImagePlus> pathImage = null;

        public WatershedCellDetector(FloatProcessor fpDetection, FloatProcessor fpH, FloatProcessor fpDAB, Roi roi, PathImage<ImagePlus> pathImage) {
            this.fpDetection = fpDetection;
            this.fpH = fpH;
            this.fpDAB = fpDAB;
            this.roi = roi;
            this.pathImage = pathImage;
        }

        public static ByteProcessor limitedOpeningByReconstruction(ImageProcessor ip, ImageProcessor ipBackground, double radius, double maxBackground) {
            RankFilters rf = new RankFilters();
            ipBackground.setRoi(ip.getRoi());
            rf.rank(ipBackground, radius, 1);
            ByteProcessor bpMask = null;
            if (!Double.isNaN(maxBackground) && maxBackground > 0.0) {
                int i;
                int w = ip.getWidth();
                int h = ip.getHeight();
                for (i = 0; i < w * h; ++i) {
                    if (!((double)ipBackground.getf(i) > maxBackground)) continue;
                    if (bpMask == null) {
                        bpMask = new ByteProcessor(w, h);
                    }
                    bpMask.setf(i, 1.0f);
                }
                if (bpMask != null) {
                    rf.rank(bpMask, radius * 2.0, 2);
                    for (i = 0; i < w * h; ++i) {
                        if (bpMask.getf(i) == 0.0f) continue;
                        ipBackground.setf(i, Float.NEGATIVE_INFINITY);
                    }
                }
            }
            MorphologicalReconstruction.morphologicalReconstruction(ipBackground, ip);
            return bpMask;
        }

        /*
         * WARNING - void declaration
         */
        private void doDetection(boolean regenerateROIs) {
            int i;
            FloatProcessor fpLoG;
            int width = this.fpDetection.getWidth();
            int height = this.fpDetection.getHeight();
            this.lastRunCompleted = false;
            this.pathObjects.clear();
            ByteProcessor bp = null;
            ByteProcessor bpBackgroundMask = null;
            this.fpDetection.setRoi(this.roi);
            if (regenerateROIs) {
                this.rois = null;
                this.bpLoG = null;
                fpLoG = (FloatProcessor)this.fpDetection.duplicate();
                RankFilters rankFilters = new RankFilters();
                if (this.medianRadius > 0.0) {
                    rankFilters.rank((ImageProcessor)fpLoG, this.medianRadius, 4);
                }
                if (this.backgroundRadius > 0.0) {
                    this.ipBackground = fpLoG.duplicate();
                    bpBackgroundMask = WatershedCellDetector.limitedOpeningByReconstruction((ImageProcessor)fpLoG, this.ipBackground, this.backgroundRadius, this.maxBackground);
                    fpLoG.copyBits(this.ipBackground, 0, 0, 4);
                    this.ipToMeasure = fpLoG.duplicate();
                } else {
                    this.ipToMeasure = this.fpDetection;
                    this.ipBackground = null;
                }
                if (this.excludeDAB && this.fpH != null && this.fpDAB != null) {
                    this.fpDAB.setRoi(this.roi);
                    ByteProcessor byteProcessor = SimpleThresholding.greaterThanOrEqual((ImageProcessor)this.fpH, (ImageProcessor)this.fpDAB);
                    byteProcessor.multiply(0.00392156862745098);
                    rankFilters.rank((ImageProcessor)byteProcessor, 2.5, 4);
                    rankFilters.rank((ImageProcessor)byteProcessor, 2.5, 2);
                    fpLoG.copyBits((ImageProcessor)byteProcessor, 0, 0, 5);
                }
                fpLoG.blurGaussian(this.sigma);
                fpLoG.convolve(new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f}, 3, 3);
                this.bpLoG = SimpleThresholding.thresholdAbove((ImageProcessor)fpLoG, 0.0);
                fpLoG.setRoi(this.roi);
                ImageProcessor imageProcessor = MorphologicalReconstruction.findRegionalMaxima((ImageProcessor)fpLoG, 0.001f, false);
                ImageProcessor ipLabels = RoiLabeling.labelImage(imageProcessor, 0.0f, false);
                Watershed.doWatershed((ImageProcessor)fpLoG, ipLabels, 0.0, false);
                ipLabels.setThreshold(0.5, Double.POSITIVE_INFINITY, 2);
                this.rois = RoiLabeling.getFilledPolygonROIs(ipLabels, 4);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
            }
            if (bp == null) {
                bp = new ByteProcessor(width, height);
            }
            bp.setValue(255.0);
            for (Roi roi : this.rois) {
                this.ipToMeasure.setRoi(roi);
                double d = this.ipToMeasure.getStatistics().mean;
                if (d <= this.threshold) continue;
                if (bpBackgroundMask != null) {
                    bpBackgroundMask.setRoi(roi);
                    if (bpBackgroundMask.getStatistics().mean > 0.0) continue;
                }
                bp.fill(roi);
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            bp.setThreshold(127.0, Double.POSITIVE_INFINITY, 2);
            if (this.mergeAll) {
                bp.filter(4);
                bp.copyBits((ImageProcessor)this.bpLoG, 0, 0, 9);
                if (this.watershedPostProcess) {
                    List<PolygonRoi> rois2 = RoiLabeling.getFilledPolygonROIs((ImageProcessor)bp, 4);
                    bp.setValue(255.0);
                    for (Roi roi : rois2) {
                        bp.fill(roi);
                    }
                    new EDM().toWatershed((ImageProcessor)bp);
                }
            }
            if (this.roi != null) {
                RoiLabeling.clearOutside((ImageProcessor)bp, this.roi);
            }
            bp.setThreshold(127.0, Double.POSITIVE_INFINITY, 2);
            if (this.refineBoundary && this.sigma > 1.5) {
                fpLoG = (FloatProcessor)this.fpDetection.duplicate();
                fpLoG.blurGaussian(1.0);
                fpLoG.convolve(new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f}, 3, 3);
                ByteProcessor byteProcessor = SimpleThresholding.thresholdAbove((ImageProcessor)fpLoG, 0.0);
                byteProcessor.copyBits((ImageProcessor)bp, 0, 0, 12);
                bp.filter(3);
                bp.copyBits((ImageProcessor)byteProcessor, 0, 0, 13);
                regenerateROIs = true;
            }
            this.roisNuclei = RoiLabeling.getFilledPolygonROIs((ImageProcessor)bp, 4);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (this.minArea > 0.0 || this.maxArea > 0.0) {
                bp.setValue(0.0);
                Iterator<PolygonRoi> iter = this.roisNuclei.iterator();
                while (iter.hasNext()) {
                    Roi roi = (Roi)iter.next();
                    this.fpDetection.setRoi(roi);
                    double d = ImageStatistics.getStatistics((ImageProcessor)this.fpDetection, (int)1, null).pixelCount;
                    if (!(this.minArea > 0.0 && d < this.minArea) && (!(this.maxArea > 0.0) || !(d > this.maxArea))) continue;
                    iter.remove();
                    bp.fill(roi);
                }
                this.fpDetection.resetRoi();
            }
            ShortProcessor ipLabels = new ShortProcessor(width, height);
            RoiLabeling.labelROIs((ImageProcessor)ipLabels, this.roisNuclei);
            Object var7_16 = null;
            Object var8_24 = null;
            int nCells = 0;
            if (this.excludeDAB && this.fpDAB != null) {
                FloatProcessor fpMembranes = (FloatProcessor)this.fpDAB.duplicate();
                fpMembranes.blurGaussian(2.0);
                float membraneThreshold = 0.2f;
                for (int i2 = 0; i2 < width * height; ++i2) {
                    fpMembranes.setf(i2, membraneThreshold - fpMembranes.getf(i2));
                }
                fpMembranes.max(0.0);
                fpMembranes.setValue(0.1);
                for (Roi roi : this.roisNuclei) {
                    fpMembranes.fill(roi);
                }
                ByteProcessor bpMarkers = new MaximumFinder().findMaxima((ImageProcessor)fpMembranes, 0.09, -808080.0, 1, false, false);
                RoiLabeling.removeByAreas(bpMarkers, 1.0, this.maxArea, true);
                ByteProcessor byteProcessor = (ByteProcessor)bpMarkers.duplicate();
                new RankFilters().rank((ImageProcessor)byteProcessor, this.cellExpansion, 2);
                for (int i3 = 0; i3 < width * height; ++i3) {
                    if (!(this.fpH.getf(i3) + this.fpDAB.getf(i3) < 0.025f)) continue;
                    byteProcessor.set(i3, 0);
                }
                float minThreshold = (float)(fpMembranes.getStatistics().min - 0.05);
                for (i = 0; i < width * height; ++i) {
                    if (byteProcessor.get(i) != 0) continue;
                    fpMembranes.setf(i, minThreshold);
                }
                fpMembranes.resetMinAndMax();
                int lastLabel = this.roisNuclei.size();
                ImageProcessor imageProcessor = ipLabels.duplicate();
                for (int i4 = 0; i4 < width * height; ++i4) {
                    if (bpMarkers.get(i4) == 0 || imageProcessor.get(i4) != 0) continue;
                    imageProcessor.set(i4, Short.MAX_VALUE);
                }
                FloodFiller ff = new FloodFiller(imageProcessor);
                for (int i5 = 0; i5 < width * height; ++i5) {
                    if (imageProcessor.get(i5) != Short.MAX_VALUE) continue;
                    imageProcessor.setValue((double)(++lastLabel));
                    ff.fill(i5 % width, i5 / width);
                }
                Watershed.doWatershed((ImageProcessor)fpMembranes, imageProcessor, (double)minThreshold + 0.025, false);
                imageProcessor.setThreshold(0.5, Double.POSITIVE_INFINITY, 2);
                Map<Float, PolygonRoi> map = RoiLabeling.getFilledPolygonROIsFromLabels(imageProcessor, 4);
                nCells = lastLabel;
            }
            List statsHematoxylin = null;
            List statsDAB = null;
            if (this.makeMeasurements) {
                statsHematoxylin = StatisticsHelper.createRunningStatisticsList((int)this.roisNuclei.size());
                PixelImageIJ imgLabels = new PixelImageIJ((ImageProcessor)ipLabels);
                StatisticsHelper.computeRunningStatistics((SimpleImage)new PixelImageIJ((ImageProcessor)this.fpH), (SimpleImage)imgLabels, (List)statsHematoxylin);
                if (this.fpDAB != null) {
                    statsDAB = StatisticsHelper.createRunningStatisticsList((int)this.roisNuclei.size());
                    StatisticsHelper.computeRunningStatistics((SimpleImage)new PixelImageIJ((ImageProcessor)this.fpDAB), (SimpleImage)imgLabels, (List)statsDAB);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<PathObject> nucleiObjects = new ArrayList<PathObject>();
            Calibration calibration = ((ImagePlus)this.pathImage.getImage()).getCalibration();
            ImagePlane plane = this.pathImage.getImageRegion().getImagePlane();
            for (i = 0; i < this.roisNuclei.size(); ++i) {
                PolygonRoi r = this.roisNuclei.get(i);
                if (this.smoothBoundaries) {
                    r = new PolygonRoi(r.getInterpolatedPolygon(Math.min(2.5, (double)r.getNCoordinates() * 0.1), true), 2);
                }
                PolygonROI pathROI = IJTools.convertToPolygonROI(r, calibration, this.pathImage.getDownsampleFactor(), plane);
                if (this.smoothBoundaries) {
                    int nBefore = pathROI.nVertices();
                    pathROI = ShapeSimplifier.simplifyPolygon((PolygonROI)pathROI, (double)(this.pathImage.getDownsampleFactor() / 4.0));
                    int nAfter = pathROI.nVertices();
                    logger.trace("Vertices removed: {}", (Object)(nBefore - nAfter));
                }
                MeasurementList measurementList = MeasurementListFactory.createMeasurementList((int)(this.makeMeasurements ? 30 : 0), (MeasurementList.MeasurementListType)MeasurementList.MeasurementListType.FLOAT);
                if (this.makeMeasurements) {
                    ObjectMeasurements.addShapeStatistics(measurementList, (Roi)r, (ImageProcessor)this.fpH, calibration, "Nucleus: ");
                    RunningStatistics stats = (RunningStatistics)statsHematoxylin.get(i);
                    measurementList.put("Nucleus: Hematoxylin OD mean", stats.getMean());
                    measurementList.put("Nucleus: Hematoxylin OD sum", stats.getSum());
                    measurementList.put("Nucleus: Hematoxylin OD std dev", stats.getStdDev());
                    measurementList.put("Nucleus: Hematoxylin OD max", stats.getMax());
                    measurementList.put("Nucleus: Hematoxylin OD min", stats.getMin());
                    measurementList.put("Nucleus: Hematoxylin OD range", stats.getRange());
                    if (statsDAB != null) {
                        stats = (RunningStatistics)statsDAB.get(i);
                        measurementList.put("Nucleus: DAB OD mean", stats.getMean());
                        measurementList.put("Nucleus: DAB OD sum", stats.getSum());
                        measurementList.put("Nucleus: DAB OD std dev", stats.getStdDev());
                        measurementList.put("Nucleus: DAB OD max", stats.getMax());
                        measurementList.put("Nucleus: DAB OD min", stats.getMin());
                        measurementList.put("Nucleus: DAB OD range", stats.getRange());
                    }
                }
                PathObject pathObject = PathObjects.createDetectionObject((ROI)pathROI, null, (MeasurementList)measurementList);
                nucleiObjects.add(pathObject);
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (this.cellExpansion > 0.0) {
                void var8_28;
                Map<Float, PolygonRoi> roisCells;
                void var7_18;
                if (var7_18 == null) {
                    FloatProcessor fpEDM = new EDM().makeFloatEDM((ImageProcessor)bp, -1, false);
                    fpEDM.multiply(-1.0);
                    double cellExpansionThreshold = -this.cellExpansion;
                    if (this.limitExpansionByNucleusSize) {
                        MaximumFinder mf = new MaximumFinder();
                        ByteProcessor bpVoronoi = mf.findMaxima((ImageProcessor)fpEDM, 0.5, cellExpansionThreshold, 2, false, false);
                        FloatProcessor floatProcessor = new EDM().makeFloatEDM((ImageProcessor)bp, 0, false);
                        FloatProcessor fpMarkers = new FloatProcessor(floatProcessor.getWidth(), floatProcessor.getHeight());
                        Arrays.fill((float[])fpMarkers.getPixels(), Float.NEGATIVE_INFINITY);
                        for (Roi roi : this.roisNuclei) {
                            floatProcessor.setRoi(roi);
                            double max = floatProcessor.getStatistics().max;
                            fpMarkers.setValue(-2.0 * max);
                            fpMarkers.fill(roi);
                        }
                        for (int i6 = 0; i6 < bpVoronoi.getWidth() * bpVoronoi.getHeight(); ++i6) {
                            if (bpVoronoi.getf(i6) != 0.0f) continue;
                            fpEDM.setf(i6, Float.NEGATIVE_INFINITY);
                        }
                        if (!MorphologicalReconstruction.morphologicalReconstruction((ImageProcessor)fpMarkers, (ImageProcessor)fpEDM)) {
                            logger.error("Problem during morphological reconstruction!");
                        }
                        ByteProcessor bpMax = mf.findMaxima((ImageProcessor)fpMarkers, 1.0E-4, 1, false);
                        fpEDM.copyBits((ImageProcessor)bpMax, 0, 0, 0);
                        cellExpansionThreshold = 128.0;
                    }
                    ImageProcessor imageProcessor = ipLabels.duplicate();
                    Watershed.doWatershed((ImageProcessor)fpEDM, imageProcessor, cellExpansionThreshold, false);
                    roisCells = RoiLabeling.getFilledPolygonROIsFromLabels(imageProcessor, this.roisNuclei.size());
                    nCells = roisCells.size();
                } else {
                    roisCells = var7_18;
                }
                List statsDABCell = null;
                if (this.fpDAB != null && this.makeMeasurements) {
                    statsDABCell = StatisticsHelper.createRunningStatisticsList((int)nCells);
                    StatisticsHelper.computeRunningStatistics((SimpleImage)new PixelImageIJ((ImageProcessor)this.fpDAB), (SimpleImage)new PixelImageIJ((ImageProcessor)var8_28), (List)statsDABCell);
                }
                for (int i7 = 0; i7 < ipLabels.getWidth() * ipLabels.getHeight(); ++i7) {
                    if (ipLabels.getf(i7) == 0.0f) continue;
                    var8_28.setf(i7, 0.0f);
                }
                List statsDABCytoplasm = null;
                if (this.includeNuclei && this.fpDAB != null && this.makeMeasurements) {
                    statsDABCytoplasm = StatisticsHelper.createRunningStatisticsList((int)nCells);
                    StatisticsHelper.computeRunningStatistics((SimpleImage)new PixelImageIJ((ImageProcessor)this.fpDAB), (SimpleImage)new PixelImageIJ((ImageProcessor)var8_28), (List)statsDABCytoplasm);
                }
                List statsDABMembrane = null;
                if (this.includeNuclei && this.excludeDAB && this.fpDAB != null && this.makeMeasurements) {
                    statsDABMembrane = StatisticsHelper.createRunningStatisticsList((int)nCells);
                    ShortProcessor ipLabelsMembrane = new ShortProcessor(width, height);
                    for (Map.Entry<Object, Object> entry : roisCells.entrySet()) {
                        Float label = (Float)entry.getKey();
                        PolygonRoi roiTemp = (PolygonRoi)entry.getValue();
                        ipLabelsMembrane.setValue(label.doubleValue());
                        ipLabelsMembrane.draw((Roi)roiTemp);
                    }
                    StatisticsHelper.computeRunningStatistics((SimpleImage)new PixelImageIJ((ImageProcessor)this.fpDAB), (SimpleImage)new PixelImageIJ((ImageProcessor)ipLabelsMembrane), (List)statsDABMembrane);
                }
                PathClass cellClass = null;
                for (Map.Entry entry : roisCells.entrySet()) {
                    void var24_72;
                    PolygonRoi r = (PolygonRoi)entry.getValue();
                    if (r == null) continue;
                    if (this.smoothBoundaries) {
                        r = new PolygonRoi(r.getInterpolatedPolygon(Math.min(2.5, (double)r.getNCoordinates() * 0.1), false), 2);
                    }
                    PolygonROI pathROI = IJTools.convertToPolygonROI(r, ((ImagePlus)this.pathImage.getImage()).getCalibration(), this.pathImage.getDownsampleFactor(), plane);
                    if (this.smoothBoundaries) {
                        pathROI = ShapeSimplifier.simplifyPolygon((PolygonROI)pathROI, (double)(this.pathImage.getDownsampleFactor() / 4.0));
                    }
                    Object var24_69 = null;
                    PathObject nucleus = null;
                    int label = ((Float)entry.getKey()).intValue();
                    if (label < nucleiObjects.size()) {
                        nucleus = (PathObject)nucleiObjects.get(label - 1);
                    }
                    if (nucleus == null && pathROI.getArea() > this.maxArea * 2.0) continue;
                    if (this.includeNuclei && nucleus != null) {
                        MeasurementList measurementList = nucleus.getMeasurementList();
                    } else {
                        MeasurementList measurementList = MeasurementListFactory.createMeasurementList((int)(this.makeMeasurements ? 12 : 0), (MeasurementList.MeasurementListType)MeasurementList.MeasurementListType.GENERAL);
                        nucleus = null;
                    }
                    if (this.makeMeasurements) {
                        RunningStatistics stats;
                        ObjectMeasurements.addShapeStatistics((MeasurementList)var24_72, (Roi)r, (ImageProcessor)this.fpDetection, ((ImagePlus)this.pathImage.getImage()).getCalibration(), "Cell: ");
                        if (statsDABCell != null) {
                            stats = (RunningStatistics)statsDABCell.get(label - 1);
                            var24_72.put("Cell: DAB OD mean", stats.getMean());
                            var24_72.put("Cell: DAB OD std dev", stats.getStdDev());
                            var24_72.put("Cell: DAB OD max", stats.getMax());
                            var24_72.put("Cell: DAB OD min", stats.getMin());
                        }
                        if (statsDABCytoplasm != null) {
                            stats = (RunningStatistics)statsDABCytoplasm.get(label - 1);
                            var24_72.put("Cytoplasm: DAB OD mean", stats.getMean());
                            var24_72.put("Cytoplasm: DAB OD std dev", stats.getStdDev());
                            var24_72.put("Cytoplasm: DAB OD max", stats.getMax());
                            var24_72.put("Cytoplasm: DAB OD min", stats.getMin());
                        }
                        if (statsDABMembrane != null) {
                            stats = (RunningStatistics)statsDABMembrane.get(label - 1);
                            var24_72.put("Membrane: DAB OD mean", stats.getMean());
                            var24_72.put("Membrane: DAB OD std dev", stats.getStdDev());
                            var24_72.put("Membrane: DAB OD max", stats.getMax());
                            var24_72.put("Membrane: DAB OD min", stats.getMin());
                        }
                        if (nucleus != null && nucleus.getROI().isArea()) {
                            double nucleusArea = nucleus.getROI().getArea();
                            double cellArea = pathROI.getArea();
                            var24_72.put("Nucleus/Cell area ratio", Math.min(nucleusArea / cellArea, 1.0));
                        }
                    }
                    PathObject pathObject = PathObjects.createCellObject((ROI)pathROI, (ROI)(nucleus == null ? null : nucleus.getROI()), cellClass, (MeasurementList)var24_72);
                    this.pathObjects.add(pathObject);
                }
            } else {
                this.pathObjects.addAll(nucleiObjects);
            }
            for (PathObject pathObject : this.pathObjects) {
                pathObject.getMeasurementList().close();
            }
            this.lastRunCompleted = true;
        }

        public List<PathObject> getPathObjects() {
            return this.pathObjects;
        }

        public void runDetection(double backgroundRadius, double maxBackground, double medianRadius, double sigma, double threshold, double minArea, double maxArea, boolean mergeAll, boolean watershedPostProcess, boolean excludeDAB, double cellExpansion, boolean limitExpansionByNucleusSize, boolean smoothBoundaries, boolean includeNuclei, boolean makeMeasurements) {
            boolean updateAnything;
            boolean updateNucleusROIs;
            boolean bl = updateNucleusROIs = this.rois == null || this.bpLoG == null;
            updateNucleusROIs = updateNucleusROIs ? updateNucleusROIs : this.medianRadius != medianRadius;
            this.medianRadius = medianRadius;
            updateNucleusROIs = updateNucleusROIs ? updateNucleusROIs : this.backgroundRadius != backgroundRadius;
            this.backgroundRadius = backgroundRadius;
            updateNucleusROIs = updateNucleusROIs ? updateNucleusROIs : this.sigma != sigma;
            this.sigma = sigma;
            updateNucleusROIs = updateNucleusROIs ? updateNucleusROIs : this.excludeDAB != excludeDAB;
            this.excludeDAB = excludeDAB;
            boolean bl2 = updateAnything = updateNucleusROIs || !this.lastRunCompleted;
            updateAnything = updateAnything ? updateAnything : this.minArea != minArea;
            this.minArea = minArea;
            updateAnything = updateAnything ? updateAnything : this.maxArea != maxArea;
            this.maxArea = maxArea;
            updateAnything = updateAnything ? updateAnything : this.maxBackground != maxBackground;
            this.maxBackground = maxBackground;
            updateAnything = updateAnything ? updateAnything : this.threshold != threshold;
            this.threshold = threshold;
            updateAnything = updateAnything ? updateAnything : this.mergeAll != mergeAll;
            this.mergeAll = mergeAll;
            updateAnything = updateAnything ? updateAnything : this.watershedPostProcess != watershedPostProcess;
            this.watershedPostProcess = watershedPostProcess;
            updateAnything = updateAnything ? updateAnything : this.cellExpansion != cellExpansion;
            this.cellExpansion = cellExpansion;
            updateAnything = updateAnything ? updateAnything : this.smoothBoundaries != smoothBoundaries;
            this.smoothBoundaries = smoothBoundaries;
            updateAnything = updateAnything ? updateAnything : this.includeNuclei != includeNuclei;
            this.includeNuclei = includeNuclei;
            updateAnything = updateAnything ? updateAnything : this.makeMeasurements != makeMeasurements;
            this.makeMeasurements = makeMeasurements;
            updateAnything = updateAnything ? updateAnything : this.limitExpansionByNucleusSize != limitExpansionByNucleusSize;
            this.limitExpansionByNucleusSize = limitExpansionByNucleusSize;
            try {
                this.doDetection(updateNucleusROIs);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

