/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.cells;

import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.EDM;
import ij.plugin.filter.MaximumFinder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.RoiLabeling;
import qupath.imagej.processing.SimpleThresholding;
import qupath.imagej.tools.IJTools;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleImages;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorTransformer;
import qupath.lib.color.StainVector;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.measurements.MeasurementListFactory;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class SubcellularDetection
extends AbstractInteractivePlugin<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(SubcellularDetection.class);

    public boolean runPlugin(TaskRunner taskRunner, ImageData<BufferedImage> imageData, String arg) {
        boolean success = super.runPlugin(taskRunner, imageData, arg);
        imageData.getHierarchy().fireHierarchyChangedEvent((Object)this);
        return success;
    }

    protected void addRunnableTasks(ImageData<BufferedImage> imageData, PathObject parentObject, List<Runnable> tasks) {
        ParameterList params = this.getParameterList(imageData);
        tasks.add(new SubcellularDetectionRunnable(imageData, parentObject, params));
    }

    static boolean processObject(PathObject pathObject, ParameterList params, ImageWrapper imageWrapper) throws InterruptedException, IOException {
        double maxSpotArea;
        double minSpotArea;
        double singleSpotArea;
        double pixelHeight;
        double pixelWidth;
        ROI pathROI;
        PathClass baseClass = PathClassTools.getNonIntensityAncestorClass((PathClass)pathObject.getPathClass());
        pathObject.clearChildObjects();
        String[] existingMeasurements = (String[])pathObject.getMeasurementList().getNames().stream().filter(n -> n.startsWith("Subcellular:")).toArray(String[]::new);
        if (existingMeasurements.length > 0) {
            pathObject.getMeasurementList().removeAll(existingMeasurements);
            pathObject.getMeasurementList().close();
        }
        if ((pathROI = pathObject.getROI()) == null || pathROI.isEmpty()) {
            return false;
        }
        double downsample = 1.0;
        ImageServer<BufferedImage> server = imageWrapper.getServer();
        PixelCalibration cal = server.getPixelCalibration();
        if (cal.hasPixelSizeMicrons()) {
            double spotSizeMicrons = params.getDoubleParameterValue("spotSizeMicrons");
            double minSpotSizeMicrons = params.getDoubleParameterValue("minSpotSizeMicrons");
            double maxSpotSizeMicrons = params.getDoubleParameterValue("maxSpotSizeMicrons");
            pixelWidth = cal.getPixelWidthMicrons() * downsample;
            pixelHeight = cal.getPixelHeightMicrons() * downsample;
            singleSpotArea = spotSizeMicrons / (pixelWidth * pixelHeight);
            minSpotArea = minSpotSizeMicrons / (pixelWidth * pixelHeight);
            maxSpotArea = maxSpotSizeMicrons / (pixelWidth * pixelHeight);
        } else {
            singleSpotArea = params.getDoubleParameterValue("spotSizePixels");
            minSpotArea = params.getDoubleParameterValue("minSpotSizePixels");
            maxSpotArea = params.getDoubleParameterValue("maxSpotSizePixels");
            pixelWidth = downsample;
            pixelHeight = downsample;
        }
        boolean includeClusters = Boolean.TRUE.equals(params.getBooleanParameterValue("includeClusters"));
        boolean doSmoothing = Boolean.TRUE.equals(params.getBooleanParameterValue("doSmoothing"));
        boolean splitByIntensity = Boolean.TRUE.equals(params.getBooleanParameterValue("splitByIntensity"));
        boolean splitByShape = Boolean.TRUE.equals(params.getBooleanParameterValue("splitByShape"));
        int xStart = (int)Math.max(0.0, pathROI.getBoundsX() - 1.0);
        int yStart = (int)Math.max(0.0, pathROI.getBoundsY() - 1.0);
        int width = (int)Math.min((double)(server.getWidth() - 1), pathROI.getBoundsX() + pathROI.getBoundsWidth() + 1.5) - xStart;
        int height = (int)Math.min((double)(server.getHeight() - 1), pathROI.getBoundsY() + pathROI.getBoundsHeight() + 1.5) - yStart;
        if (width <= 0 || height <= 0) {
            logger.error("Negative ROI size for {}", (Object)pathROI);
            pathObject.setPathClass(baseClass);
            return false;
        }
        int z = pathROI.getZ();
        int t = pathROI.getT();
        int c = -1;
        RegionRequest region = RegionRequest.createInstance((String)server.getPath(), (double)1.0, (int)xStart, (int)yStart, (int)width, (int)height, (int)z, (int)t);
        byte[] cellMask = null;
        for (String channelName : imageWrapper.getChannelNames(true, true)) {
            double detectionThreshold = params.getDoubleParameterValue("detection[" + channelName + "]");
            if (Double.isNaN(detectionThreshold) || detectionThreshold < 0.0) continue;
            SimpleImage img = imageWrapper.getRegion(region, channelName);
            Calibration calIJ = new Calibration();
            calIJ.xOrigin = (double)(-xStart) / downsample;
            calIJ.yOrigin = (double)(-yStart) / downsample;
            if (cellMask == null) {
                BufferedImage imgMask = new BufferedImage(img.getWidth(), img.getHeight(), 10);
                Graphics2D g2d = imgMask.createGraphics();
                if (downsample != 1.0) {
                    g2d.scale(1.0 / downsample, 1.0 / downsample);
                }
                g2d.translate(-xStart, -yStart);
                Shape shape = RoiTools.getShape((ROI)pathROI);
                g2d.setColor(Color.WHITE);
                g2d.fill(shape);
                g2d.dispose();
                cellMask = ((DataBufferByte)imgMask.getRaster().getDataBuffer()).getData(0);
            }
            int w = img.getWidth();
            int h = img.getHeight();
            FloatProcessor fpDetection = new FloatProcessor(w, h);
            if (doSmoothing) {
                for (i = 0; i < w * h; ++i) {
                    fpDetection.setf(i, img.getValue(i % w, i / w));
                }
                fpDetection.smooth();
                for (i = 0; i < w * h; ++i) {
                    if (cellMask[i] != false) continue;
                    fpDetection.setf(i, 0.0f);
                }
            } else {
                for (i = 0; i < w * h; ++i) {
                    if (cellMask[i] == false) {
                        fpDetection.setf(i, 0.0f);
                        continue;
                    }
                    fpDetection.setf(i, img.getValue(i % w, i / w));
                }
            }
            ByteProcessor bpSpots = splitByIntensity ? new MaximumFinder().findMaxima((ImageProcessor)fpDetection, detectionThreshold / 10.0, detectionThreshold, 2, false, false) : SimpleThresholding.thresholdAboveEquals((ImageProcessor)fpDetection, detectionThreshold);
            if (splitByShape) {
                new EDM().toWatershed((ImageProcessor)bpSpots);
            }
            bpSpots.setThreshold(1.0, -808080.0, 2);
            List<PolygonRoi> possibleSpotRois = RoiLabeling.getFilledPolygonROIs((ImageProcessor)bpSpots, 4);
            ArrayList<PathObject> spotObjects = new ArrayList<PathObject>();
            ArrayList<PathObject> clusterObjects = new ArrayList<PathObject>();
            double estimatedSpots = 0.0;
            for (PolygonRoi spotRoi : possibleSpotRois) {
                fpDetection.setRoi((Roi)spotRoi);
                ImageStatistics stats = fpDetection.getStatistics();
                ImagePlane plane = ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t);
                PathObject spotOrCluster = null;
                if ((double)stats.pixelCount >= minSpotArea && (double)stats.pixelCount <= maxSpotArea) {
                    ROI roi = IJTools.convertToROI((Roi)spotRoi, calIJ, downsample, plane);
                    spotOrCluster = SubcellularDetection.createSubcellularObject(roi, 1.0);
                    estimatedSpots += 1.0;
                } else if (includeClusters && (double)stats.pixelCount >= minSpotArea) {
                    ROI roi = IJTools.convertToROI((Roi)spotRoi, calIJ, downsample, plane);
                    double nSpots = (double)stats.pixelCount / singleSpotArea;
                    estimatedSpots += nSpots;
                    spotOrCluster = SubcellularDetection.createSubcellularObject(roi, nSpots);
                }
                if (spotOrCluster == null) continue;
                boolean isCluster = spotOrCluster.getMeasurementList().get("Num spots") > 1.0;
                int rgb = imageWrapper.getChannelColor(channelName);
                rgb = isCluster ? ColorTools.makeScaledRGB((int)rgb, (double)0.5) : ColorTools.makeScaledRGB((int)rgb, (double)1.5);
                PathClass pathClass = PathClass.getInstance((PathClass)spotOrCluster.getPathClass(), (String)(channelName + " object"), (Integer)rgb);
                spotOrCluster.setPathClass(pathClass);
                spotOrCluster.getMeasurementList().put("Subcellular cluster: " + channelName + ": Area", (double)stats.pixelCount * pixelWidth * pixelHeight);
                spotOrCluster.getMeasurementList().put("Subcellular cluster: " + channelName + ": Mean channel intensity", stats.mean);
                spotOrCluster.getMeasurementList().close();
                if (isCluster) {
                    clusterObjects.add(spotOrCluster);
                    continue;
                }
                spotObjects.add(spotOrCluster);
            }
            MeasurementList measurementList = pathObject.getMeasurementList();
            measurementList.put("Subcellular: " + channelName + ": Num spots estimated", estimatedSpots);
            measurementList.put("Subcellular: " + channelName + ": Num single spots", (double)spotObjects.size());
            measurementList.put("Subcellular: " + channelName + ": Num clusters", (double)clusterObjects.size());
            pathObject.addChildObjects(spotObjects);
            pathObject.addChildObjects(clusterObjects);
        }
        return true;
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        ParameterList params = new ParameterList().addTitleParameter("Detection parameters");
        for (String name : new ImageWrapper(imageData).getChannelNames(true, true)) {
            params.addDoubleParameter("detection[" + name + "]", "Detection threshold (" + name + ")", -1.0, "", "Intensity threshold for detection - if < 0, no detection will be applied to this channel");
        }
        params.addBooleanParameter("doSmoothing", "Smooth before detection", false, "Apply 3x3 smoothing filter to reduce noise prior to detection");
        params.addBooleanParameter("splitByIntensity", "Split by intensity", false, "Attempt to split merged spots based on intensity peaks");
        params.addBooleanParameter("splitByShape", "Split by shape", false, "Attempt to split merged spots according to shape (i.e. looking for rounder spots)");
        params.addTitleParameter("Spot & cluster parameters");
        boolean hasMicrons = imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        if (!hasMicrons) {
            params.addEmptyParameter("Subcellular detection works best if the pixel size information is available in " + GeneralTools.micrometerSymbol() + "!");
            params.addEmptyParameter("Because this information is missing, the following values are in pixels.");
            params.addEmptyParameter("If you change the pixel sizes in the image, restart this command to see the changes.");
        }
        params.addDoubleParameter("spotSizeMicrons", "Expected spot size", 1.0, GeneralTools.micrometerSymbol() + "^2", "Estimated area of a single spot - used to estimate total spot counts");
        params.addDoubleParameter("minSpotSizeMicrons", "Min spot size", 0.5, GeneralTools.micrometerSymbol() + "^2", "Minimum spot area - smaller spots will be excluded");
        params.addDoubleParameter("maxSpotSizeMicrons", "Max spot size", 2.0, GeneralTools.micrometerSymbol() + "^2", "Maximum spot area - larger spots will be counted as clusters");
        params.addDoubleParameter("spotSizePixels", "Expected spot size", 1.0, "px^2", "Estimated area of a single spot - used to estimate total spot counts");
        params.addDoubleParameter("minSpotSizePixels", "Min spot size", 1.0, "px^2", "Minimum spot area - smaller spots will be excluded");
        params.addDoubleParameter("maxSpotSizePixels", "Max spot size", 4.0, "px^2", "Maximum spot area - larger spots will be counted as clusters");
        params.addBooleanParameter("includeClusters", "Include clusters", true, "Store anything larger than 'Max spot size' as a cluster, instead of ignoring it");
        params.setHiddenParameters(!hasMicrons, new String[]{"spotSizeMicrons", "minSpotSizeMicrons", "maxSpotSizeMicrons"});
        params.setHiddenParameters(hasMicrons, new String[]{"spotSizePixels", "minSpotSizePixels", "maxSpotSizePixels"});
        return params;
    }

    public String getName() {
        return "Subcellular spot detection";
    }

    public String getLastResultsDescription() {
        return "";
    }

    public String getDescription() {
        return "Add subcellular detections to existing cells";
    }

    protected Collection<PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
        Collection<Class<? extends PathObject>> parentClasses = this.getSupportedParentObjectClasses();
        ArrayList<PathObject> parents = new ArrayList<PathObject>();
        block0: for (PathObject parent : imageData.getHierarchy().getSelectionModel().getSelectedObjects()) {
            for (Class<? extends PathObject> cls : parentClasses) {
                if (!cls.isAssignableFrom(parent.getClass())) continue;
                parents.add(parent);
                continue block0;
            }
        }
        return parents;
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        ArrayList<Class<? extends PathObject>> parents = new ArrayList<Class<? extends PathObject>>();
        parents.add(TMACoreObject.class);
        parents.add(PathAnnotationObject.class);
        parents.add(PathCellObject.class);
        return parents;
    }

    static PathObject createSubcellularObject(ROI roi, double nSpots) {
        PathObject pathObject = PathObjects.createDetectionObject((ROI)roi);
        if (nSpots != 1.0) {
            pathObject.setPathClass(PathClass.getInstance((String)"Subcellular cluster", (Integer)ColorTools.packRGB((int)220, (int)200, (int)50)));
        } else {
            pathObject.setPathClass(PathClass.getInstance((String)"Subcellular spot", (Integer)ColorTools.packRGB((int)100, (int)220, (int)50)));
        }
        pathObject.getMeasurementList().put("Num spots", nSpots);
        pathObject.getMeasurementList().close();
        return pathObject;
    }

    static class SubcellularDetectionRunnable
    implements Runnable {
        private ImageData<BufferedImage> imageData;
        private ParameterList params;
        private PathObject parentObject;

        public SubcellularDetectionRunnable(ImageData<BufferedImage> imageData, PathObject parentObject, ParameterList params) {
            this.imageData = imageData;
            this.parentObject = parentObject;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.parentObject instanceof PathCellObject) {
                    SubcellularDetection.processObject(this.parentObject, this.params, new ImageWrapper(this.imageData));
                } else {
                    List<PathObject> cellObjects = PathObjectTools.getFlattenedObjectList((PathObject)this.parentObject, null, (boolean)false).stream().filter(p -> p instanceof PathCellObject).toList();
                    for (PathObject cell : cellObjects) {
                        SubcellularDetection.processObject(cell, this.params, new ImageWrapper(this.imageData));
                    }
                }
            }
            catch (InterruptedException e) {
                logger.error("Processing interrupted", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error processing " + String.valueOf(this.parentObject), (Throwable)e);
            }
            finally {
                this.parentObject.getMeasurementList().close();
                this.imageData = null;
                this.params = null;
            }
        }

        public String toString() {
            return "Subcellular detection";
        }
    }

    static class ImageWrapper {
        private final ImageData<BufferedImage> imageData;
        private Map<RegionRequest, BufferedImage> cachedRegions = new HashMap<RegionRequest, BufferedImage>();

        public ImageWrapper(ImageData<BufferedImage> imageData) {
            this.imageData = imageData;
        }

        public ImageServer<BufferedImage> getServer() {
            return this.imageData.getServer();
        }

        public SimpleImage getRegion(RegionRequest region, String channelName) throws IOException {
            for (int i = 0; i < this.nChannels(); ++i) {
                if (!channelName.equals(this.getChannelName(i))) continue;
                return this.getRegion(region, i);
            }
            return null;
        }

        public SimpleImage getRegion(RegionRequest region, int channel) throws IOException {
            BufferedImage img = this.getBufferedImage(region);
            ColorDeconvolutionStains stains = this.imageData.getColorDeconvolutionStains();
            float[] pixels = null;
            int w = img.getWidth();
            int h = img.getHeight();
            if (stains != null) {
                int[] buf = img.getRGB(0, 0, w, h, null, 0, w);
                switch (channel) {
                    case 0: {
                        pixels = ColorTransformer.getTransformedPixels((int[])buf, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_1, (float[])pixels, (ColorDeconvolutionStains)stains);
                        break;
                    }
                    case 1: {
                        pixels = ColorTransformer.getTransformedPixels((int[])buf, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_2, (float[])pixels, (ColorDeconvolutionStains)stains);
                        break;
                    }
                    case 2: {
                        pixels = ColorTransformer.getTransformedPixels((int[])buf, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.Stain_3, (float[])pixels, (ColorDeconvolutionStains)stains);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Specified channel should be 0, 1, or 2!");
                    }
                }
            } else {
                pixels = img.getData().getSamples(0, 0, w, h, channel, pixels);
            }
            return SimpleImages.createFloatImage((float[])pixels, (int)w, (int)h);
        }

        public int getChannelColor(String channelName) {
            int i;
            ColorDeconvolutionStains stains = this.imageData.getColorDeconvolutionStains();
            if (stains != null) {
                for (i = 1; i <= 3; ++i) {
                    if (!channelName.equals(stains.getStain(i).getName())) continue;
                    return stains.getStain(i).getColor();
                }
            }
            for (i = 0; i < this.nChannels(); ++i) {
                if (!channelName.equals(this.getChannelName(i))) continue;
                return this.imageData.getServer().getChannel(i).getColor();
            }
            return 0;
        }

        public String getChannelName(int channel) {
            ColorDeconvolutionStains stains = this.imageData.getColorDeconvolutionStains();
            if (stains != null) {
                return stains.getStain(channel + 1).getName();
            }
            return "Channel " + (channel + 1);
        }

        public int nChannels() {
            return this.imageData.getServer().nChannels();
        }

        public List<String> getChannelNames(boolean skipHematoxylin, boolean skipResidual) {
            ArrayList<String> names = new ArrayList<String>();
            ColorDeconvolutionStains stains = this.imageData.getColorDeconvolutionStains();
            if (stains != null) {
                for (int i = 1; i <= 3; ++i) {
                    StainVector stain = stains.getStain(i);
                    if (skipResidual && stain.isResidual() || skipHematoxylin && ColorDeconvolutionStains.isHematoxylin((StainVector)stain)) continue;
                    names.add(stain.getName());
                }
            } else {
                for (int i = 0; i < this.nChannels(); ++i) {
                    names.add(this.getChannelName(i));
                }
            }
            return names;
        }

        private BufferedImage getBufferedImage(RegionRequest region) throws IOException {
            if (this.cachedRegions.containsKey(region)) {
                return this.cachedRegions.get(region);
            }
            BufferedImage img = (BufferedImage)this.imageData.getServer().readRegion(region);
            this.cachedRegions.put(region, img);
            return img;
        }
    }

    @Deprecated
    static class SubcellularObject
    extends PathDetectionObject {
        private static final long serialVersionUID = 1L;
        static Integer color = ColorTools.packRGB((int)200, (int)200, (int)50);

        public SubcellularObject() {
        }

        SubcellularObject(ROI roi, double nSpots) {
            super(roi, null);
            if (nSpots != 1.0) {
                this.setPathClass(PathClass.getInstance((String)"Subcellular cluster", (Integer)ColorTools.packRGB((int)220, (int)200, (int)50)));
            } else {
                this.setPathClass(PathClass.getInstance((String)"Subcellular spot", (Integer)ColorTools.packRGB((int)100, (int)220, (int)50)));
            }
            this.getMeasurementList().put("Num spots", nSpots);
            this.getMeasurementList().close();
        }

        public boolean isEditable() {
            return false;
        }

        protected MeasurementList createEmptyMeasurementList() {
            return MeasurementListFactory.createMeasurementList((int)0, (MeasurementList.MeasurementListType)MeasurementList.MeasurementListType.FLOAT);
        }

        public void setPathClass(PathClass pathClass, double probability) {
            super.setPathClass(pathClass, probability);
        }

        public String getName() {
            return super.getName();
        }

        public String getDisplayedName() {
            return super.getDisplayedName();
        }
    }
}

