/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.cells;

import ij.gui.Roi;
import ij.process.ImageStatistics;

class ShapeStatsIJ {
    public static int SHAPE_MEASUREMENT_OPTIONS = 149633;
    private double area;
    private double perimeter;
    private double xCentroid;
    private double yCentroid;
    private double majorAxisLength;
    private double minorAxisLength;
    private double maxCaliper;
    private double minCaliper;

    public ShapeStatsIJ(Roi roi, ImageStatistics stats) {
        this.area = stats.area;
        this.perimeter = roi.getLength();
        this.xCentroid = stats.xCentroid;
        this.yCentroid = stats.yCentroid;
        this.majorAxisLength = stats.major;
        this.minorAxisLength = stats.minor;
        double[] feretValues = roi.getFeretValues();
        this.maxCaliper = feretValues[0];
        this.minCaliper = feretValues[2];
    }

    public double area() {
        return this.area;
    }

    public double perimeter() {
        return this.perimeter;
    }

    public double maxCaliper() {
        return this.maxCaliper;
    }

    public double minCaliper() {
        return this.minCaliper;
    }

    public int xCentroidInt() {
        return (int)(this.xCentroid + 0.5);
    }

    public int yCentroidInt() {
        return (int)(this.yCentroid + 0.5);
    }

    public double xCentroid() {
        return this.xCentroid;
    }

    public double yCentroid() {
        return this.yCentroid;
    }

    public double majorAxisLength() {
        return this.majorAxisLength;
    }

    public double minorAxisLength() {
        return this.minorAxisLength;
    }

    public double eccentricity() {
        double majAxis = this.majorAxisLength();
        double minAxis = this.minorAxisLength();
        return 2.0 * Math.sqrt(majAxis * majAxis * 0.25 - minAxis * minAxis * 0.25) / majAxis;
    }

    public double aspectRatio() {
        return this.majorAxisLength / this.minorAxisLength;
    }

    public double roundness() {
        return 1.0 / this.aspectRatio();
    }

    public double circularity() {
        return Math.min(Math.PI * 4 * this.area / (this.perimeter * this.perimeter), 1.0);
    }
}

