/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.cells;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import qupath.imagej.detect.cells.WatershedCellDetection;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.StainVector;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelType;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.interfaces.ROI;

public class PositiveCellDetection
extends WatershedCellDetection {
    @Override
    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        if (this.parametersInitialized) {
            return super.getDefaultParameterList(imageData);
        }
        super.getDefaultParameterList(imageData);
        this.params.addTitleParameter("Intensity threshold parameters");
        ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
        LinkedHashSet<Object> channels = new LinkedHashSet<Object>();
        if (stains != null) {
            for (int i = 1; i <= 3; ++i) {
                StainVector stain = stains.getStain(i);
                if (ColorDeconvolutionStains.isHematoxylin((StainVector)stain) || stain.isResidual()) continue;
                channels.add(stain.getName() + " OD");
            }
        } else {
            ImageServer server = imageData.getServer();
            for (ImageChannel imageChannel : server.getMetadata().getChannels()) {
                channels.add(imageChannel.getName());
            }
        }
        ArrayList<CallSite> choices = new ArrayList<CallSite>();
        for (String string : channels) {
            choices.add((CallSite)((Object)("Nucleus: " + string + " mean")));
            choices.add((CallSite)((Object)("Nucleus: " + string + " max")));
            choices.add((CallSite)((Object)("Cytoplasm: " + string + " mean")));
            choices.add((CallSite)((Object)("Cytoplasm: " + string + " max")));
            choices.add((CallSite)((Object)("Cell: " + string + " mean")));
            choices.add((CallSite)((Object)("Cell: " + string + " max")));
        }
        ImageServer server = imageData.getServer();
        PixelType pixelType = server.getMetadata().getPixelType();
        double t1 = 0.2;
        double tMax = 1.5;
        if (stains == null && !pixelType.isFloatingPoint()) {
            t1 = pixelType.getBytesPerPixel() <= 1 ? 10.0 : 100.0;
            tMax = Math.min(10000.0, Math.pow(2.0, pixelType.getBitsPerPixel()) - 1.0);
        }
        this.params.addChoiceParameter("thresholdCompartment", "Score compartment", (Object)((String)choices.get(0)), choices, "Select the intensity measurement to threshold");
        this.params.addDoubleParameter("thresholdPositive1", "Threshold 1+", t1, null, 0.0, tMax, "Low positive intensity threshold");
        this.params.addDoubleParameter("thresholdPositive2", "Threshold 2+", t1 * 2.0, null, 0.0, tMax, "Moderate positive intensity threshold");
        this.params.addDoubleParameter("thresholdPositive3", "Threshold 3+", t1 * 3.0, null, 0.0, tMax, "High positive intensity threshold");
        this.params.addBooleanParameter("singleThreshold", "Single threshold", true);
        return this.params;
    }

    @Override
    public String getName() {
        return "Positive cell detection";
    }

    @Override
    protected ObjectDetector<BufferedImage> createDetector(ImageData<BufferedImage> imageData, ParameterList params) {
        ObjectDetector<BufferedImage> detector = super.createDetector(imageData, params);
        return new DetectorWrapper<BufferedImage>(detector);
    }

    static class DetectorWrapper<T>
    implements ObjectDetector<T> {
        private ObjectDetector<T> detector;

        public DetectorWrapper(ObjectDetector<T> detector) {
            this.detector = detector;
        }

        public Collection<PathObject> runDetection(ImageData<T> imageData, ParameterList params, ROI pathROI) throws IOException {
            Collection detections = this.detector.runDetection(imageData, params, pathROI);
            String measurement = (String)params.getChoiceParameterValue("thresholdCompartment");
            double threshold1 = params.getDoubleParameterValue("thresholdPositive1");
            double threshold2 = params.getDoubleParameterValue("thresholdPositive2");
            double threshold3 = params.getDoubleParameterValue("thresholdPositive3");
            boolean singleThreshold = params.getBooleanParameterValue("singleThreshold");
            for (PathObject pathObject : detections) {
                double val = pathObject.getMeasurementList().get(measurement);
                if (singleThreshold) {
                    if (val >= threshold1) {
                        pathObject.setPathClass(PathClass.getPositive((PathClass)pathObject.getPathClass()));
                        continue;
                    }
                    pathObject.setPathClass(PathClass.getNegative((PathClass)pathObject.getPathClass()));
                    continue;
                }
                if (val >= threshold3) {
                    pathObject.setPathClass(PathClass.getThreePlus((PathClass)pathObject.getPathClass()));
                    continue;
                }
                if (val >= threshold2) {
                    pathObject.setPathClass(PathClass.getTwoPlus((PathClass)pathObject.getPathClass()));
                    continue;
                }
                if (val >= threshold1) {
                    pathObject.setPathClass(PathClass.getOnePlus((PathClass)pathObject.getPathClass()));
                    continue;
                }
                pathObject.setPathClass(PathClass.getNegative((PathClass)pathObject.getPathClass()));
            }
            return detections;
        }

        public String getLastResultsDescription() {
            return this.detector.getLastResultsDescription();
        }
    }
}

