/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.detect.cells;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import qupath.imagej.detect.cells.ShapeStatsIJ;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

class ObjectMeasurements {
    ObjectMeasurements() {
    }

    public static void addShapeStatistics(MeasurementList measurementList, PolygonROI roi, double pixelWidth, double pixelHeight, String prefix) {
        measurementList.put(prefix + "Area", roi.getScaledArea(pixelWidth, pixelHeight));
        measurementList.put(prefix + "Perimeter", roi.getScaledLength(pixelWidth, pixelHeight));
        measurementList.put(prefix + "Circularity", RoiTools.getCircularity((ROI)roi, (double)pixelWidth, (double)pixelHeight));
        measurementList.put(prefix + "Solidity", roi.getSolidity());
    }

    public static void addShapeStatistics(MeasurementList measurementList, Roi roi, ImageProcessor ip, Calibration cal, String prefix) {
        boolean calibrationValid;
        ip.setRoi(roi);
        ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)ShapeStatsIJ.SHAPE_MEASUREMENT_OPTIONS, (Calibration)cal);
        ImagePlus impRoi = roi.getImage();
        boolean bl = calibrationValid = impRoi != null && impRoi.getCalibration().equals(cal);
        if (!calibrationValid) {
            ImagePlus impTemp = new ImagePlus("Temp", ip);
            impTemp.setCalibration(cal);
            roi.setImage(impTemp);
        }
        ShapeStatsIJ shapeStats = new ShapeStatsIJ(roi, stats);
        if (!calibrationValid) {
            roi.setImage(impRoi);
        }
        if (roi.isArea()) {
            measurementList.put(prefix + "Area", shapeStats.area());
        }
        measurementList.put(prefix + "Perimeter", shapeStats.perimeter());
        measurementList.put(prefix + "Circularity", shapeStats.circularity());
        measurementList.put(prefix + "Max caliper", shapeStats.maxCaliper());
        measurementList.put(prefix + "Min caliper", shapeStats.minCaliper());
        measurementList.put(prefix + "Eccentricity", shapeStats.eccentricity());
    }
}

