/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.utils.converters;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleConverter
extends StringConverter<Locale> {
    private static final Logger logger = LoggerFactory.getLogger(LocaleConverter.class);
    private final Locale baseLocale;

    public LocaleConverter() {
        this(Locale.US);
    }

    public LocaleConverter(Locale baseLocale) {
        Objects.requireNonNull(baseLocale, "Base locale cannot be null");
        this.baseLocale = baseLocale;
    }

    public String toString(Locale locale) {
        return locale == null ? null : locale.getDisplayName(this.baseLocale);
    }

    public Locale fromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Arrays.stream(Locale.getAvailableLocales()).filter(l -> Objects.equals(l.getDisplayName(this.baseLocale), string)).findFirst().orElse(null);
        }
        catch (Exception e) {
            logger.error("Could not parse file from " + string, (Throwable)e);
            return null;
        }
    }
}

