/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.utils.converters;

import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumConverter<T extends Enum>
extends StringConverter<T> {
    private static final Logger logger = LoggerFactory.getLogger(EnumConverter.class);
    private Class<? extends T> enumType;

    public EnumConverter(Class<? extends T> enumType) {
        this.enumType = enumType;
    }

    public String toString(T object) {
        return object == null ? null : ((Enum)object).name();
    }

    public T fromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumType, string);
        }
        catch (Exception e) {
            logger.error("Could not parse enum value: " + string, (Throwable)e);
            return null;
        }
    }
}

