/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.utils;

import java.util.Arrays;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;

public class GridPaneUtils {
    public static void addGridRow(GridPane pane, int row, int col, String tooltipText, Node ... nodes) {
        Node lastNode = null;
        Tooltip tooltip = tooltipText == null ? null : new Tooltip(tooltipText);
        for (Node n : nodes) {
            if (n == null) {
                ++col;
                continue;
            }
            if (lastNode == n) {
                Integer span = GridPane.getColumnSpan((Node)n);
                if (span == null) {
                    GridPane.setColumnSpan((Node)n, (Integer)2);
                } else {
                    GridPane.setColumnSpan((Node)n, (Integer)(span + 1));
                }
            } else {
                pane.add(n, col, row);
                GridPane.setColumnSpan((Node)n, (Integer)1);
                if (tooltip != null) {
                    GridPaneUtils.installTooltipRecursive(tooltip, n, false);
                }
            }
            lastNode = n;
            ++col;
        }
    }

    static void installTooltipRecursive(Tooltip tooltip, Node node, boolean overrideExisting) {
        if (node instanceof Control) {
            Control control = (Control)node;
            if (overrideExisting || control.getTooltip() == null) {
                control.setTooltip(tooltip);
            }
        } else {
            Tooltip.install((Node)node, (Tooltip)tooltip);
            if (node instanceof Region) {
                for (Node child : ((Region)node).getChildrenUnmodifiable()) {
                    GridPaneUtils.installTooltipRecursive(tooltip, child, overrideExisting);
                }
            }
        }
    }

    public static void setHGrowPriority(Priority priority, Node ... nodes) {
        for (Node n : nodes) {
            GridPane.setHgrow((Node)n, (Priority)priority);
        }
    }

    public static void setVGrowPriority(Priority priority, Node ... nodes) {
        for (Node n : nodes) {
            GridPane.setVgrow((Node)n, (Priority)priority);
        }
    }

    public static void setMaxWidth(double width, Region ... regions) {
        for (Region r : regions) {
            r.setMaxWidth(width);
        }
    }

    public static void setMaxHeight(double height, Region ... regions) {
        for (Region r : regions) {
            r.setMaxHeight(height);
        }
    }

    public static void setMinWidth(double width, Region ... regions) {
        for (Region r : regions) {
            r.setMinWidth(width);
        }
    }

    public static void setMinHeight(double height, Region ... regions) {
        for (Region r : regions) {
            r.setMinHeight(height);
        }
    }

    public static void setFillWidth(Boolean doFill, Node ... nodes) {
        for (Node n : nodes) {
            GridPane.setFillWidth((Node)n, (Boolean)doFill);
        }
    }

    public static void setToExpandGridPaneWidth(Node ... nodes) {
        GridPaneUtils.setFillWidth(Boolean.TRUE, nodes);
        GridPaneUtils.setHGrowPriority(Priority.ALWAYS, nodes);
        GridPaneUtils.setMaxWidth(Double.MAX_VALUE, (Region[])Arrays.stream(nodes).filter(n -> n instanceof Region).map(n -> (Region)n).toArray(Region[]::new));
    }

    public static void setToExpandGridPaneHeight(Node ... nodes) {
        GridPaneUtils.setFillHeight(Boolean.TRUE, nodes);
        GridPaneUtils.setVGrowPriority(Priority.ALWAYS, nodes);
        GridPaneUtils.setMaxHeight(Double.MAX_VALUE, (Region[])Arrays.stream(nodes).filter(n -> n instanceof Region).map(n -> (Region)n).toArray(Region[]::new));
    }

    public static void setFillHeight(Boolean doFill, Node ... nodes) {
        for (Node n : nodes) {
            GridPane.setFillHeight((Node)n, (Boolean)doFill);
        }
    }

    public static GridPane createRowGrid(Node ... nodes) {
        GridPane pane = new GridPane();
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            RowConstraints row = new RowConstraints();
            row.setPercentHeight(100.0 / (double)n);
            pane.getRowConstraints().add((Object)row);
            pane.add(nodes[i], 0, i);
        }
        ColumnConstraints col = new ColumnConstraints();
        col.setPercentWidth(100.0);
        pane.getColumnConstraints().add((Object)col);
        return pane;
    }

    public static GridPane createRowGridControls(Node ... nodes) {
        GridPane pane = new GridPane();
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            RowConstraints row = new RowConstraints();
            row.setPercentHeight(100.0 / (double)n);
            pane.getRowConstraints().add((Object)row);
            Node node = nodes[i];
            pane.add(node, 0, i);
            if (!(node instanceof Control)) continue;
            ((Control)node).prefWidthProperty().bind((ObservableValue)pane.widthProperty());
        }
        ColumnConstraints col = new ColumnConstraints();
        col.setPercentWidth(100.0);
        pane.getColumnConstraints().add((Object)col);
        return pane;
    }

    public static GridPane createColumnGridControls(Node ... nodes) {
        GridPane pane = new GridPane();
        int n = nodes.length;
        double maxMinWidth = 0.0;
        for (int i = 0; i < n; ++i) {
            ColumnConstraints col = new ColumnConstraints();
            col.setPercentWidth(100.0 / (double)n);
            pane.getColumnConstraints().add((Object)col);
            Node node = nodes[i];
            pane.add(node, i, 0);
            if (!(node instanceof Control)) continue;
            maxMinWidth = Math.max(maxMinWidth, ((Control)node).getPrefWidth());
            ((Control)node).prefWidthProperty().bind((ObservableValue)pane.widthProperty().divide(n));
        }
        RowConstraints row = new RowConstraints();
        row.setPercentHeight(100.0);
        pane.getRowConstraints().add((Object)row);
        pane.setMinWidth(maxMinWidth * (double)n);
        pane.setPrefWidth(maxMinWidth * (double)n);
        return pane;
    }

    public static GridPane createColumnGrid(Node ... nodes) {
        GridPane pane = new GridPane();
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            ColumnConstraints col = new ColumnConstraints();
            col.setPercentWidth(100.0 / (double)n);
            pane.getColumnConstraints().add((Object)col);
            pane.add(nodes[i], i, 0);
        }
        RowConstraints row = new RowConstraints();
        row.setPercentHeight(100.0);
        pane.getRowConstraints().add((Object)row);
        return pane;
    }

    public static GridPane createColumnGrid(int nCols) {
        GridPane pane = new GridPane();
        for (int i = 0; i < nCols; ++i) {
            ColumnConstraints col = new ColumnConstraints();
            col.setPercentWidth(100.0 / (double)nCols);
            pane.getColumnConstraints().add((Object)col);
        }
        RowConstraints row = new RowConstraints();
        row.setPercentHeight(100.0);
        pane.getRowConstraints().add((Object)row);
        return pane;
    }
}

