/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.utils;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.controlsfx.control.CheckComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.GridPaneUtils;

public class FXUtils {
    private static final Logger logger = LoggerFactory.getLogger(FXUtils.class);
    private static final Pattern pattern = Pattern.compile("[a-zA-Z&&[^Ee]]+");

    public static <T> T callOnApplicationThread(Callable<T> callable) {
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                logger.error("Error calling directly on Platform thread", (Throwable)e);
                return null;
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        SimpleObjectProperty result = new SimpleObjectProperty();
        Platform.runLater(() -> FXUtils.lambda$callOnApplicationThread$0(callable, (ObjectProperty)result, latch));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting result", (Throwable)e);
        }
        return (T)result.getValue();
    }

    public static void runOnApplicationThread(Runnable runnable) {
        FXUtils.callOnApplicationThread(() -> {
            runnable.run();
            return runnable;
        });
    }

    public static Window getWindow(Node node) {
        Scene scene = node.getScene();
        return scene == null ? null : scene.getWindow();
    }

    public static Screen getScreen(Node node) {
        Bounds bounds = node.localToScreen(node.getBoundsInLocal());
        return FXUtils.getMaxOverlapScreen(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    public static Screen getScreen(Window window) {
        if (window == null) {
            return null;
        }
        return FXUtils.getMaxOverlapScreen(window.getX(), window.getY(), window.getWidth(), window.getHeight());
    }

    public static Screen getScreenOrPrimary(Window window) {
        Screen screen = FXUtils.getScreen(window);
        return screen == null ? Screen.getPrimary() : screen;
    }

    public static Screen getMaxOverlapScreen(double x, double y, double width, double height) {
        return FXUtils.getMaxOverlapScreen(new Rectangle2D(x, y, width, height));
    }

    public static Screen getMaxOverlapScreen(Rectangle2D bounds) {
        ObservableList screens = Screen.getScreensForRectangle((Rectangle2D)bounds);
        return screens.stream().sorted(Comparator.comparingDouble(s -> -FXUtils.computeIntersection(bounds, s.getBounds())).thenComparing(s -> s == Screen.getPrimary() ? -1 : 1)).findFirst().orElse(null);
    }

    private static double computeIntersection(Rectangle2D b1, Rectangle2D b2) {
        double x1 = Math.max(b1.getMinX(), b2.getMinX());
        double y1 = Math.max(b1.getMinY(), b2.getMinY());
        double x2 = Math.min(b1.getMaxX(), b2.getMaxX());
        double y2 = Math.min(b1.getMaxY(), b2.getMaxY());
        return (x2 - x1) * (y2 - y1);
    }

    public static void makeDraggableStage(Stage stage) {
        new MoveablePaneHandler(stage);
    }

    public static void retainWindowPosition(Window window) {
        window.setX(window.getX());
        window.setY(window.getY());
        window.setWidth(window.getWidth());
        window.setHeight(window.getHeight());
    }

    public static Optional<Stage> findStageByTitle(String title) {
        return FXUtils.getStages().stream().filter(s -> Objects.equals(title, s.getTitle())).findFirst();
    }

    public static List<Stage> getStages() {
        return Window.getWindows().stream().filter(w -> w instanceof Stage).map(w -> (Stage)w).toList();
    }

    public static void makeTabUndockable(Tab tab) {
        MenuItem miUndock = new MenuItem("Undock tab");
        ContextMenu popup = new ContextMenu(new MenuItem[]{miUndock});
        tab.setContextMenu(popup);
        miUndock.setOnAction(e -> FXUtils.handleUndock(tab));
    }

    private static void handleUndock(Tab tab) {
        TabPane tabPane = tab.getTabPane();
        Window parent = tabPane.getScene() == null ? null : tabPane.getScene().getWindow();
        double width = tabPane.getWidth();
        double height = tabPane.getHeight();
        tabPane.getTabs().remove((Object)tab);
        Stage stage = new Stage();
        stage.initOwner(parent);
        stage.setTitle(tab.getText());
        Node content = tab.getContent();
        tab.setContent(null);
        BorderPane tabContent = new BorderPane(content);
        stage.setScene(new Scene((Parent)tabContent, width, height));
        stage.show();
        stage.setOnCloseRequest(e2 -> {
            tabContent.getChildren().remove((Object)tabContent);
            tab.setContent(content);
            tabPane.getTabs().add((Object)tab);
        });
    }

    public static void restrictTextFieldInputToNumber(TextField textField, boolean allowDecimals) {
        NumberFormat format = allowDecimals ? NumberFormat.getNumberInstance() : NumberFormat.getIntegerInstance();
        UnaryOperator filter = c -> {
            if (c.isContentChange()) {
                String text = c.getControlText().toUpperCase();
                String newText = c.getControlNewText().toUpperCase();
                Matcher matcher = pattern.matcher(newText);
                if (matcher.find()) {
                    return null;
                }
                if ((newText.length() == 1 || text.toUpperCase().endsWith("E")) && newText.endsWith("-")) {
                    return c;
                }
                if ((newText.length() > 1 && !newText.startsWith("-") || newText.length() > 2 && newText.startsWith("-")) && !text.toUpperCase().contains("E") && newText.toUpperCase().contains("E")) {
                    return c;
                }
                if (newText.isEmpty()) {
                    return c;
                }
                ParsePosition parsePosition = new ParsePosition(0);
                format.parse(newText, parsePosition);
                if (parsePosition.getIndex() < c.getControlNewText().length()) {
                    return null;
                }
            }
            return c;
        };
        TextFormatter normalizeFormatter = new TextFormatter(filter);
        textField.setTextFormatter(normalizeFormatter);
    }

    public static <T> void resetSpinnerNullToPrevious(Spinner<T> spinner) {
        spinner.valueProperty().addListener((v, o, n) -> {
            try {
                if (n == null) {
                    spinner.getValueFactory().setValue(o);
                }
            }
            catch (Exception e) {
                logger.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        });
    }

    public static DoubleProperty bindSliderAndTextField(Slider slider, TextField tf, boolean expandLimits) {
        return FXUtils.bindSliderAndTextField(slider, tf, expandLimits, -1);
    }

    public static DoubleProperty bindSliderAndTextField(Slider slider, TextField tf, boolean expandLimits, int ndp) {
        SimpleDoubleProperty numberProperty = new SimpleDoubleProperty(slider.getValue());
        new NumberAndText((DoubleProperty)numberProperty, tf.textProperty(), ndp).synchronizeTextToNumber();
        if (expandLimits) {
            numberProperty.addListener((v, o, n) -> {
                double val = n.doubleValue();
                if (Double.isFinite(val)) {
                    if (val < slider.getMin()) {
                        slider.setMin(val);
                    }
                    if (val > slider.getMax()) {
                        slider.setMax(val);
                    }
                    slider.setValue(val);
                }
            });
            slider.valueProperty().addListener((v, o, n) -> numberProperty.setValue(n));
        } else {
            slider.valueProperty().bindBidirectional((Property)numberProperty);
        }
        return numberProperty;
    }

    public static void installSelectAllOrNoneMenu(CheckComboBox<?> combo) {
        MenuItem miAll = new MenuItem("Select all");
        MenuItem miNone = new MenuItem("Select none");
        miAll.setOnAction(e -> combo.getCheckModel().checkAll());
        miNone.setOnAction(e -> combo.getCheckModel().clearChecks());
        ContextMenu menu = new ContextMenu(new MenuItem[]{miAll, miNone});
        combo.setContextMenu(menu);
        combo.addEventFilter(MouseEvent.ANY, e -> {
            if (!e.isPopupTrigger() && e.getButton().equals((Object)MouseButton.SECONDARY)) {
                e.consume();
            }
        });
    }

    public static <T> ListCell<T> createCustomListCell(Function<T, String> stringFun, Function<T, Node> graphicFun) {
        return new CustomListCell<T>(stringFun, graphicFun);
    }

    public static <T> ListCell<T> createCustomListCell(Function<T, String> stringFun) {
        return FXUtils.createCustomListCell(stringFun, t -> null);
    }

    public static Spinner<Double> createDynamicStepSpinner(double minValue, double maxValue, double defaultValue, double minStepValue, int scale) {
        SpinnerValueFactory.DoubleSpinnerValueFactory factory = new SpinnerValueFactory.DoubleSpinnerValueFactory(minValue, maxValue, defaultValue);
        factory.amountToStepByProperty().bind((ObservableValue)FXUtils.createStepBinding((ObservableValue<Double>)factory.valueProperty(), minStepValue, scale));
        Spinner spinner = new Spinner((SpinnerValueFactory)factory);
        return spinner;
    }

    public static DoubleBinding createStepBinding(ObservableValue<Double> value, double minStep, int scale) {
        return Bindings.createDoubleBinding(() -> {
            double val = (Double)value.getValue();
            if (!Double.isFinite(val)) {
                return 1.0;
            }
            val = Math.abs(val);
            return Math.max(Math.pow(10.0, Math.floor(Math.log10(val) - (double)scale)), minStep);
        }, (Observable[])new Observable[]{value});
    }

    public static void refreshAllListsAndTables() {
        for (Window window : Window.getWindows()) {
            Scene scene;
            if (!window.isShowing() || (scene = window.getScene()) == null) continue;
            FXUtils.refreshAllListsAndTables(scene.getRoot());
        }
    }

    public static void refreshAllListsAndTables(Parent parent) {
        if (parent == null) {
            return;
        }
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (child instanceof TreeView) {
                ((TreeView)child).refresh();
                continue;
            }
            if (child instanceof ListView) {
                ((ListView)child).refresh();
                continue;
            }
            if (child instanceof TableView) {
                ((TableView)child).refresh();
                continue;
            }
            if (child instanceof TreeTableView) {
                ((TreeTableView)child).refresh();
                continue;
            }
            if (!(child instanceof Parent)) continue;
            FXUtils.refreshAllListsAndTables((Parent)child);
        }
    }

    public static Collection<Node> getContents(Parent parent, Collection<Node> collection, boolean doRecursive) {
        ObservableList children;
        if (collection == null) {
            collection = new ArrayList<Node>();
        }
        if ((children = parent.getChildrenUnmodifiable()).isEmpty() && parent instanceof SplitPane) {
            children = ((SplitPane)parent).getItems();
        }
        for (Node child : children) {
            collection.add(child);
            if (!doRecursive || !(child instanceof Parent)) continue;
            FXUtils.getContents((Parent)child, collection, doRecursive);
        }
        return collection;
    }

    public static <T extends Node> Collection<T> getContentsOfType(Parent parent, Class<T> cls, boolean doRecursive) {
        return FXUtils.getContents(parent, new ArrayList<Node>(), doRecursive).stream().filter(p -> cls.isInstance(p)).map(p -> (Node)cls.cast(p)).toList();
    }

    public static void simplifyTitledPane(TitledPane pane, boolean boldTitle) {
        String css = GridPaneUtils.class.getClassLoader().getResource("css/titled_plain.css").toExternalForm();
        pane.getStylesheets().add((Object)css);
        if (boldTitle) {
            String css2 = GridPaneUtils.class.getClassLoader().getResource("css/titled_bold.css").toExternalForm();
            pane.getStylesheets().add((Object)css2);
        }
    }

    public static void addCloseWindowShortcuts(Stage stage) {
        FXUtils.addCloseWindowShortcuts(stage, Arrays.asList(new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}), new KeyCodeCombination(KeyCode.ESCAPE, new KeyCombination.Modifier[0])));
    }

    public static void addCloseWindowShortcuts(Stage stage, Collection<? extends KeyCombination> keyCombinations) {
        if (keyCombinations.isEmpty()) {
            logger.warn("Empty list of close window shortcuts - ignoring request");
            return;
        }
        stage.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            if (e.isConsumed()) {
                return;
            }
            if (keyCombinations.stream().anyMatch(kc -> kc.match(e))) {
                stage.fireEvent((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$callOnApplicationThread$0(Callable callable, ObjectProperty result, CountDownLatch latch) {
        try {
            Object value = callable.call();
            result.setValue(value);
        }
        catch (Exception e) {
            logger.error("Error calling on Platform thread", (Throwable)e);
        }
        finally {
            latch.countDown();
        }
    }

    private static class MoveablePaneHandler
    implements EventHandler<MouseEvent> {
        private final Stage stage;
        private double xOffset = 0.0;
        private double yOffset = 0.0;

        private MoveablePaneHandler(Stage stage) {
            this.stage = stage;
            Scene scene = stage.getScene();
            if (scene == null) {
                throw new IllegalArgumentException("Scene must be set on the stage!");
            }
            scene.addEventFilter(MouseEvent.ANY, (EventHandler)this);
        }

        public void handle(MouseEvent event) {
            if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                this.xOffset = this.stage.getX() - event.getScreenX();
                this.yOffset = this.stage.getY() - event.getScreenY();
            } else if (event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                this.stage.setX(event.getScreenX() + this.xOffset);
                this.stage.setY(event.getScreenY() + this.yOffset);
            }
        }
    }

    private static class NumberAndText {
        private static final Logger logger = LoggerFactory.getLogger(NumberAndText.class);
        private boolean synchronizingNumber = false;
        private boolean synchronizingText = false;
        private final DoubleProperty number;
        private final StringProperty text;
        private final int ndp;
        private final NumberFormat defaultFormatter;
        private final Map<Integer, NumberFormat> formatters = new HashMap<Integer, NumberFormat>();

        NumberAndText(DoubleProperty number, StringProperty text, int ndp) {
            this.number = number;
            this.text = text;
            this.number.addListener((v, o, n) -> this.synchronizeTextToNumber());
            this.text.addListener((v, o, n) -> this.synchronizeNumberToText());
            this.ndp = ndp;
            this.defaultFormatter = this.formatters.computeIfAbsent(ndp, NumberAndText::createFormatter);
        }

        public void synchronizeNumberToText() {
            if (this.synchronizingText) {
                return;
            }
            this.synchronizingNumber = true;
            String value = (String)this.text.get();
            if (value.isBlank()) {
                return;
            }
            try {
                Number n = this.defaultFormatter.parse(value);
                this.number.setValue(n);
            }
            catch (Exception e) {
                logger.debug("Error parsing number from '{}' ({})", (Object)value, (Object)e.getLocalizedMessage());
            }
            this.synchronizingNumber = false;
        }

        public void synchronizeTextToNumber() {
            String s;
            if (this.synchronizingNumber) {
                return;
            }
            this.synchronizingText = true;
            double value = this.number.get();
            if (Double.isNaN(value)) {
                s = "";
            } else if (Double.isFinite(value)) {
                if (this.ndp < 0) {
                    double log10 = Math.round(Math.log10(value));
                    int ndp2 = (int)Math.max(4.0, -log10 + 2.0);
                    s = this.formatters.computeIfAbsent(ndp2, NumberAndText::createFormatter).format(value);
                } else {
                    s = this.defaultFormatter.format(value);
                }
            } else {
                s = Double.toString(value);
            }
            this.text.set((Object)s);
            this.synchronizingText = false;
        }

        private static NumberFormat createFormatter(int nDecimalPlaces) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(nDecimalPlaces);
            return nf;
        }
    }

    private static class CustomListCell<T>
    extends ListCell<T> {
        private final Function<T, String> funString;
        private final Function<T, Node> funGraphic;

        private CustomListCell(Function<T, String> funString, Function<T, Node> funGraphic) {
            this.funString = funString;
            this.funGraphic = funGraphic;
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setText(this.funString.apply(item));
                this.setGraphic(this.funGraphic.apply(item));
            }
        }
    }
}

