/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx.items;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.controlsfx.control.PropertySheet;
import qupath.fx.localization.LocalizedResourceManager;

public abstract class PropertyItem
implements PropertySheet.Item {
    private static LocalizedResourceManager DEFAULT_MANAGER = LocalizedResourceManager.createInstance(null);
    private final LocalizedResourceManager manager;
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty category = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final StringProperty prompt = new SimpleStringProperty();

    PropertyItem(LocalizedResourceManager manager) {
        this.manager = manager == null ? DEFAULT_MANAGER : manager;
    }

    public PropertyItem category(String category) {
        this.category.set((Object)category);
        return this;
    }

    public PropertyItem description(String description) {
        this.description.set((Object)description);
        return this;
    }

    public PropertyItem name(String name) {
        this.name.set((Object)name);
        return this;
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public StringProperty promptProperty() {
        return this.prompt;
    }

    public PropertyItem key(String bundle, String key) {
        if (bundle != null && bundle.isBlank()) {
            bundle = null;
        }
        this.manager.registerProperty(this.name, bundle, key);
        if (this.manager.hasString(bundle, key + ".description")) {
            this.manager.registerProperty(this.description, bundle, key + ".description");
        }
        if (this.manager.hasString(bundle, key + ".prompt")) {
            this.manager.registerProperty(this.prompt, bundle, key + ".prompt");
        }
        return this;
    }

    public PropertyItem categoryKey(String bundle, String key) {
        this.manager.registerProperty(this.category, bundle, key);
        return this;
    }

    public String getCategory() {
        return (String)this.category.get();
    }

    public String getName() {
        return (String)this.name.get();
    }

    public String getDescription() {
        return (String)this.description.get();
    }
}

