/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx.items;

import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.controlsfx.items.PropertyItem;

public class ColorPropertyItem
extends PropertyItem {
    private IntegerProperty prop;
    private ObservableValue<Color> value;

    public ColorPropertyItem(LocalizedResourceManager manager, IntegerProperty prop) {
        super(manager);
        this.prop = prop;
        this.value = Bindings.createObjectBinding(() -> ColorPropertyItem.integerToColor(prop.getValue()), (Observable[])new Observable[]{prop});
    }

    public Class<?> getType() {
        return Color.class;
    }

    public Object getValue() {
        return this.value.getValue();
    }

    public void setValue(Object value) {
        if (value instanceof Color) {
            Color color = (Color)value;
            value = ColorPropertyItem.colorToInteger(color);
        }
        if (value instanceof Integer) {
            this.prop.setValue((Number)((Integer)value));
        } else if (value == null) {
            this.prop.setValue(null);
        } else {
            throw new IllegalArgumentException("Unsupported color value " + String.valueOf(value));
        }
    }

    private static Integer colorToInteger(Color color) {
        if (color == null) {
            return null;
        }
        int a = (int)Math.round(color.getOpacity() * 255.0);
        int r = (int)Math.round(color.getRed() * 255.0);
        int g = (int)Math.round(color.getGreen() * 255.0);
        int b = (int)Math.round(color.getBlue() * 255.0);
        int argb = a << 24 | r << 16 | g << 8 | b;
        return argb;
    }

    private static Color integerToColor(Integer argb) {
        if (argb == null) {
            return null;
        }
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb >> 0 & 0xFF;
        return Color.color((double)((double)r / 255.0), (double)((double)g / 255.0), (double)((double)b / 255.0), (double)((double)a / 255.0));
    }

    public Optional<ObservableValue<?>> getObservableValue() {
        return Optional.of(this.value);
    }
}

