/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx.items;

import java.io.File;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.controlsfx.items.PropertyItem;

abstract class AbstractFilePropertyItem
extends PropertyItem {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFilePropertyItem.class);
    private Property<String> prop;
    private ObservableValue<File> fileValue;

    AbstractFilePropertyItem(LocalizedResourceManager manager, Property<String> prop) {
        super(manager);
        this.prop = prop;
        this.fileValue = Bindings.createObjectBinding(() -> this.pathToFile((String)prop.getValue()), (Observable[])new Observable[]{prop});
    }

    protected File pathToFile(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    public Class<?> getType() {
        return File.class;
    }

    public Object getValue() {
        return this.fileValue.getValue();
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.prop.setValue((Object)((String)value));
        } else if (value instanceof File) {
            this.prop.setValue((Object)((File)value).getAbsolutePath());
        } else if (value == null) {
            this.prop.setValue(null);
        } else {
            logger.error("Cannot set property {} with value {}", this.prop, value);
        }
    }

    public Property<String> getFilePathProperty() {
        return this.prop;
    }

    public Optional<ObservableValue<?>> getObservableValue() {
        return Optional.of(this.fileValue);
    }
}

