/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx.editors;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.util.Duration;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.controlsfx.items.DirectoryPropertyItem;
import qupath.fx.prefs.controlsfx.items.FilePropertyItem;
import qupath.fx.prefs.controlsfx.items.PropertyItem;

abstract class AbstractFileEditor
extends AbstractPropertyEditor<File, FileChoiceControl> {
    AbstractFileEditor(PropertySheet.Item property, Collection<? extends FileChooser.ExtensionFilter> filters) {
        super(property, (Node)new FileChoiceControl(filters), true);
        this.init();
    }

    AbstractFileEditor(PropertySheet.Item property) {
        super(property, (Node)new DirectoryChoiceControl(), true);
        this.init();
    }

    private void init() {
        PropertyItem prop;
        this.configureTooltip();
        PropertySheet.Item item = this.getProperty();
        if (item instanceof FilePropertyItem) {
            prop = (FilePropertyItem)item;
            tf = ((FileChoiceControl)this.getEditor()).getTextField();
            tf.textProperty().bindBidirectional(((FilePropertyItem)prop).getFilePathProperty());
        } else {
            tf = this.getProperty();
            if (tf instanceof DirectoryPropertyItem) {
                DirectoryPropertyItem prop2 = (DirectoryPropertyItem)tf;
                tf = ((FileChoiceControl)this.getEditor()).getTextField();
                tf.textProperty().bindBidirectional(prop2.getFilePathProperty());
            }
        }
        PropertySheet.Item item2 = this.getProperty();
        if (item2 instanceof PropertyItem) {
            prop = (PropertyItem)item2;
            ((FileChoiceControl)this.getEditor()).getTextField().promptTextProperty().bind((ObservableValue)prop.promptProperty());
        }
    }

    private void configureTooltip() {
        FileChoiceControl control = (FileChoiceControl)this.getEditor();
        PropertySheet.Item property = this.getProperty();
        if (property.getDescription() != null) {
            String description = property.getDescription();
            Tooltip tooltip = new Tooltip(description);
            tooltip.setShowDuration(Duration.millis((double)10000.0));
            Tooltip.install((Node)control, (Tooltip)tooltip);
        }
    }

    public void setValue(File value) {
        ((FileChoiceControl)this.getEditor()).getTextField().setText(value == null ? null : value.getAbsolutePath());
    }

    protected ObservableValue<File> getObservableValue() {
        return ((FileChoiceControl)this.getEditor()).getObservableFile();
    }

    public static class FileChoiceControl
    extends HBox {
        static LocalizedResourceManager resources = LocalizedResourceManager.createInstance("qupath.fx.localization.strings");
        private TextField textField = new TextField();
        private Button button = new Button();
        private ObservableValue<File> value;
        private FileChooser.ExtensionFilter[] extensionFilters;

        private FileChoiceControl(Collection<? extends FileChooser.ExtensionFilter> extensionFilters) {
            this.extensionFilters = extensionFilters == null ? new FileChooser.ExtensionFilter[]{} : (FileChooser.ExtensionFilter[])extensionFilters.toArray(FileChooser.ExtensionFilter[]::new);
            this.button = this.createButton();
            this.textField = this.createTextField();
            this.configureButton(this.button);
            this.configureTextField(this.textField);
            this.setSpacing(5.0);
            this.getChildren().addAll((Object[])new Node[]{this.textField, this.button});
        }

        private Button createButton() {
            Button button = new Button();
            button.setMaxWidth(Double.MAX_VALUE);
            button.setMaxHeight(Double.MAX_VALUE);
            button.setGraphic(this.createIcon(12));
            return button;
        }

        protected void configureButton(Button button) {
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind((ObservableValue)resources.createProperty("chooseFile"));
            button.setOnAction(e -> {
                File dirNew = FileChoosers.promptForFile(button.getScene().getWindow(), null, this.extensionFilters);
                if (dirNew != null) {
                    this.textField.textProperty().set((Object)dirNew.getAbsolutePath());
                }
                e.consume();
            });
        }

        private TextField createTextField() {
            TextField textField = new TextField();
            textField.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
            return textField;
        }

        private void configureTextField(TextField textField) {
            StringProperty textProperty = textField.textProperty();
            this.value = Bindings.createObjectBinding(() -> this.textToFile(textField.getText()), (Observable[])new Observable[]{textProperty});
        }

        protected File textToFile(String text) {
            if (text == null || text.trim().isEmpty() || !new File(text).isFile()) {
                return null;
            }
            return new File(text);
        }

        ObservableValue<File> getObservableFile() {
            return this.value;
        }

        public TextField getTextField() {
            return this.textField;
        }

        public Button getButton() {
            return this.button;
        }

        protected FontAwesome.Glyph getButtonGlyph() {
            return FontAwesome.Glyph.FILE_ALT;
        }

        private Node createIcon(int size) {
            GlyphFont font = GlyphFontRegistry.font((String)"FontAwesome");
            Glyph g = font.create((Enum)this.getButtonGlyph()).size((double)size);
            g.setAlignment(Pos.CENTER);
            g.setContentDisplay(ContentDisplay.CENTER);
            g.setTextAlignment(TextAlignment.CENTER);
            g.setStyle("-fx-text-fill: -fx-text-base-color;");
            return g;
        }
    }

    public static class DirectoryChoiceControl
    extends FileChoiceControl {
        private DirectoryChoiceControl() {
            super(Collections.emptyList());
        }

        @Override
        protected File textToFile(String text) {
            if (text == null || text.trim().isEmpty() || !new File(text).isDirectory()) {
                return null;
            }
            return new File(text);
        }

        @Override
        protected FontAwesome.Glyph getButtonGlyph() {
            return FontAwesome.Glyph.FOLDER_OPEN_ALT;
        }

        @Override
        protected void configureButton(Button button) {
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind((ObservableValue)resources.createProperty("chooseDirectory"));
            button.setOnAction(e -> {
                File dirNew = FileChoosers.promptForDirectory(button.getScene().getWindow(), null, (File)this.getObservableFile().getValue());
                if (dirNew != null) {
                    this.getTextField().textProperty().set((Object)dirNew.getAbsolutePath());
                }
                e.consume();
            });
        }
    }
}

