/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx.editors;

import java.util.Locale;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.prefs.controlsfx.items.PropertyItem;
import qupath.fx.utils.converters.LocaleConverter;

abstract class AbstractChoiceEditor<T, S extends ComboBox<T>>
extends AbstractPropertyEditor<T, S>
implements ListChangeListener<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChoiceEditor.class);
    private ObservableList<T> choices;

    AbstractChoiceEditor(S combo, PropertySheet.Item property, ObservableList<T> choices) {
        super(property, combo);
        if (property.getType().equals(Locale.class)) {
            combo.setConverter((StringConverter)new LocaleConverter());
        }
        if (property instanceof PropertyItem) {
            PropertyItem item = (PropertyItem)property;
            combo.promptTextProperty().bind((ObservableValue)item.promptProperty());
        }
        this.choices = choices == null ? FXCollections.observableArrayList() : choices;
        combo.getItems().setAll(this.choices);
        this.choices.addListener((ListChangeListener)this);
    }

    public void setValue(T value) {
        ComboBox combo = (ComboBox)this.getEditor();
        if (combo.getItems().contains(value)) {
            combo.getSelectionModel().select(value);
        } else {
            if (value != null) {
                logger.warn("Value {} not found in choices for property {}", value, (Object)this.getProperty().getName());
            }
            combo.getSelectionModel().clearSelection();
        }
    }

    protected ObservableValue<T> getObservableValue() {
        return ((ComboBox)this.getEditor()).getSelectionModel().selectedItemProperty();
    }

    public void onChanged(ListChangeListener.Change<? extends T> c) {
        this.syncComboItemsToChoices();
    }

    private void syncComboItemsToChoices() {
        Object selected = this.getProperty().getValue();
        ObservableList comboItems = ((ComboBox)this.getEditor()).getItems();
        ((ComboBox)this.getEditor()).getSelectionModel().clearSelection();
        comboItems.setAll(this.choices);
        this.setValue(selected);
    }
}

