/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.textfield.CustomTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.controlsfx.PropertyEditorFactory;
import qupath.fx.prefs.controlsfx.PropertyItemParser;
import qupath.fx.prefs.controlsfx.items.DefaultPropertyItem;
import qupath.fx.prefs.controlsfx.items.PropertyItem;

public class PropertySheetUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertySheetUtils.class);

    public static PropertySheet createDefaultPropertySheet() {
        PropertySheet propSheet = new PropertySheet();
        propSheet.setMode(PropertySheet.Mode.CATEGORY);
        propSheet.setPropertyEditorFactory((Callback)new PropertyEditorFactory());
        return propSheet;
    }

    public static <T> PropertyItem createPropertySheetItem(Property<T> property, Class<? extends T> cls) {
        return new DefaultPropertyItem<T>(property, cls);
    }

    public static void refreshEditors(PropertySheet propSheet) {
        logger.trace("Refreshing property sheet editors");
        ArrayList items = new ArrayList(propSheet.getItems());
        propSheet.getItems().clear();
        propSheet.getItems().addAll(items);
        String filterText = propSheet.getTitleFilter();
        if (filterText != null && !filterText.isEmpty()) {
            for (Node node : propSheet.lookupAll(".custom-text-field")) {
                CustomTextField tf;
                if (!(node instanceof CustomTextField) || !Objects.equals(filterText, (tf = (CustomTextField)node).getText())) continue;
                tf.clear();
                break;
            }
        }
    }

    public static List<PropertySheet.Item> parseAnnotatedItems(Object obj) {
        return PropertySheetUtils.parseAnnotatedItemsWithResources(null, obj);
    }

    public static List<PropertySheet.Item> parseAnnotatedItemsWithResources(LocalizedResourceManager manager, Object obj) {
        return new PropertyItemParser().setResourceManager(manager).parseAnnotatedItems(obj);
    }
}

