/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx;

import java.util.Collection;
import java.util.List;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.prefs.controlsfx.PropertyItemParser;
import qupath.fx.prefs.controlsfx.PropertySheetUtils;

public class PropertySheetBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PropertySheetBuilder.class);
    private final PropertySheet sheet;
    private PropertyItemParser parser = new PropertyItemParser();

    public PropertySheetBuilder() {
        this(PropertySheetUtils.createDefaultPropertySheet());
    }

    private PropertySheetBuilder(PropertySheet sheet) {
        this.sheet = sheet == null ? PropertySheetUtils.createDefaultPropertySheet() : sheet;
    }

    public PropertySheetBuilder parser(PropertyItemParser parser) {
        this.parser = parser;
        return this;
    }

    public PropertySheetBuilder editorFactory(Callback<PropertySheet.Item, PropertyEditor<?>> factory) {
        this.sheet.setPropertyEditorFactory(factory);
        return this;
    }

    public PropertySheetBuilder addItems(PropertySheet.Item ... items) {
        for (PropertySheet.Item item : items) {
            this.sheet.getItems().add((Object)item);
        }
        return this;
    }

    public PropertySheetBuilder addItems(Collection<? extends PropertySheet.Item> items) {
        for (PropertySheet.Item item : items) {
            this.sheet.getItems().add((Object)item);
        }
        return this;
    }

    public PropertySheetBuilder addAnnotatedProperties(Object object) {
        List<PropertySheet.Item> items = this.parser.parseAnnotatedItems(object);
        this.sheet.getItems().addAll(items);
        return this;
    }

    public PropertySheet build() {
        return this.sheet;
    }
}

