/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;
import org.controlsfx.control.PropertySheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.localization.LocaleManager;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.annotations.BooleanPref;
import qupath.fx.prefs.annotations.ColorPref;
import qupath.fx.prefs.annotations.DirectoryPref;
import qupath.fx.prefs.annotations.DoublePref;
import qupath.fx.prefs.annotations.FilePref;
import qupath.fx.prefs.annotations.IntegerPref;
import qupath.fx.prefs.annotations.LocalePref;
import qupath.fx.prefs.annotations.Pref;
import qupath.fx.prefs.annotations.PrefCategory;
import qupath.fx.prefs.annotations.StringPref;
import qupath.fx.prefs.controlsfx.PropertyItemBuilder;
import qupath.fx.prefs.controlsfx.items.PropertyItem;

public class PropertyItemParser {
    private static final Logger logger = LoggerFactory.getLogger(PropertyItemParser.class);
    private LocalizedResourceManager resourceManager;
    private LocaleManager localeManager;

    public PropertyItemParser setResourceManager(LocalizedResourceManager manager) {
        this.resourceManager = manager;
        return this;
    }

    public PropertyItemParser setLocaleManager(LocaleManager manager) {
        this.localeManager = manager;
        return this;
    }

    public List<PropertySheet.Item> parseAnnotatedItems(Object obj) {
        Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        ArrayList<PropertySheet.Item> items = new ArrayList<PropertySheet.Item>();
        String categoryBundle = null;
        String categoryKey = null;
        if (cls.isAnnotationPresent(PrefCategory.class)) {
            PrefCategory annotation = cls.getAnnotation(PrefCategory.class);
            categoryBundle = annotation.bundle().isBlank() ? null : annotation.bundle();
            categoryKey = annotation.value();
        }
        for (Field field : cls.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !Property.class.isAssignableFrom(field.getType())) continue;
            PropertySheet.Item item = null;
            try {
                if (!field.canAccess(obj)) {
                    field.setAccessible(true);
                }
                if (field.get(obj) == null) continue;
                if (field.isAnnotationPresent(Pref.class)) {
                    item = this.parseItem((Property)field.get(obj), field.getAnnotation(Pref.class), obj);
                } else if (field.isAnnotationPresent(BooleanPref.class)) {
                    item = this.parseItem((BooleanProperty)field.get(obj), field.getAnnotation(BooleanPref.class));
                } else if (field.isAnnotationPresent(IntegerPref.class)) {
                    item = this.parseItem((IntegerProperty)field.get(obj), field.getAnnotation(IntegerPref.class));
                } else if (field.isAnnotationPresent(DoublePref.class)) {
                    item = this.parseItem((DoubleProperty)field.get(obj), field.getAnnotation(DoublePref.class));
                } else if (field.isAnnotationPresent(StringPref.class)) {
                    item = this.parseItem((Property<String>)((Property)field.get(obj)), field.getAnnotation(StringPref.class));
                } else if (field.isAnnotationPresent(LocalePref.class)) {
                    item = this.parseItem((Property<Locale>)((Property)field.get(obj)), field.getAnnotation(LocalePref.class));
                } else if (field.isAnnotationPresent(ColorPref.class)) {
                    item = this.parseItem((Property<Integer>)((Property)field.get(obj)), field.getAnnotation(ColorPref.class));
                } else if (field.isAnnotationPresent(FilePref.class)) {
                    item = this.parseItem((Property<String>)((Property)field.get(obj)), field.getAnnotation(FilePref.class));
                } else if (field.isAnnotationPresent(DirectoryPref.class)) {
                    item = this.parseItem((Property<String>)((Property)field.get(obj)), field.getAnnotation(DirectoryPref.class));
                }
                if (item instanceof PropertyItem) {
                    PropertyItem propertyItem = (PropertyItem)item;
                    if (field.isAnnotationPresent(PrefCategory.class)) {
                        PrefCategory annotation = cls.getAnnotation(PrefCategory.class);
                        String localeCategoryBundle = annotation.bundle().isBlank() ? null : annotation.bundle();
                        String localeCategoryKey = annotation.value();
                        propertyItem.categoryKey(localeCategoryBundle, localeCategoryKey);
                    } else if (categoryKey != null) {
                        propertyItem.categoryKey(categoryBundle, categoryKey);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    private PropertySheet.Item parseItem(Property property, Pref annotation, Object parent) {
        PropertyItemBuilder<?> builder = this.buildItem(property, annotation.type()).resourceManager(this.resourceManager).key(annotation.value()).bundle(annotation.bundle());
        String choiceMethod = annotation.choiceMethod();
        if (!choiceMethod.isBlank() && parent != null) {
            Class<?> cls = parent.getClass();
            try {
                Method method = cls.getDeclaredMethod(choiceMethod, new Class[0]);
                method.setAccessible(true);
                Object result = method.invoke(parent, new Object[0]);
                if (result instanceof ObservableList) {
                    ObservableList list = (ObservableList)result;
                    builder.choices(list);
                } else if (result instanceof Collection) {
                    Collection collection = (Collection)result;
                    builder.choices(collection);
                }
            }
            catch (Exception e) {
                logger.error("Unable to parse choices from " + String.valueOf(annotation) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return builder.build();
    }

    private PropertySheet.Item parseItem(BooleanProperty property, BooleanPref annotation) {
        return this.buildItem((Property)property, (Class)Boolean.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).build();
    }

    private PropertySheet.Item parseItem(IntegerProperty property, IntegerPref annotation) {
        return this.buildItem((Property)property, (Class)Integer.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).build();
    }

    private PropertySheet.Item parseItem(DoubleProperty property, DoublePref annotation) {
        return this.buildItem((Property)property, (Class)Double.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).build();
    }

    private PropertySheet.Item parseItem(Property<String> property, StringPref annotation) {
        return this.buildItem(property, String.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).build();
    }

    private PropertySheet.Item parseItem(Property<Locale> property, LocalePref annotation) {
        LocaleManager localeManager = this.localeManager == null ? new LocaleManager() : this.localeManager;
        return this.buildItem(property, Locale.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).choices(annotation.availableLanguagesOnly() ? localeManager.getAvailableLocales() : localeManager.getAllLocales()).propertyType(PropertyItemBuilder.PropertyType.SEARCHABLE_CHOICE).build();
    }

    private PropertySheet.Item parseItem(Property<Integer> property, ColorPref annotation) {
        return this.buildItem(property, Integer.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).propertyType(PropertyItemBuilder.PropertyType.COLOR).build();
    }

    private PropertySheet.Item parseItem(Property<String> property, DirectoryPref annotation) {
        return this.buildItem(property, String.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).propertyType(PropertyItemBuilder.PropertyType.DIRECTORY).build();
    }

    private PropertySheet.Item parseItem(Property<String> property, FilePref annotation) {
        ArrayList<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
        if (annotation.extensions() != null && annotation.extensions().length > 0) {
            filters.add(FileChoosers.createExtensionFilter(null, annotation.extensions()));
        }
        return this.buildItem(property, String.class).key(annotation.value()).resourceManager(this.resourceManager).bundle(annotation.bundle()).propertyType(PropertyItemBuilder.PropertyType.FILE).extensionFilters(filters).build();
    }

    private <T> PropertyItemBuilder<T> buildItem(Property<T> prop, Class<? extends T> cls) {
        return new PropertyItemBuilder<T>(prop, cls);
    }
}

