/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx;

import java.util.Collection;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;
import org.controlsfx.control.PropertySheet;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.controlsfx.items.ChoicePropertyItem;
import qupath.fx.prefs.controlsfx.items.ColorPropertyItem;
import qupath.fx.prefs.controlsfx.items.DefaultPropertyItem;
import qupath.fx.prefs.controlsfx.items.DirectoryPropertyItem;
import qupath.fx.prefs.controlsfx.items.FilePropertyItem;
import qupath.fx.prefs.controlsfx.items.PropertyItem;

public class PropertyItemBuilder<T> {
    private LocalizedResourceManager manager;
    private Property<T> property;
    private Class<? extends T> cls;
    private PropertyType propertyType = PropertyType.GENERAL;
    private ObservableList<T> choices;
    private String bundle;
    private String key;
    private String categoryKey;
    private String name;
    private String description;
    private String category;
    private ObservableList<? extends FileChooser.ExtensionFilter> extensionFilters;

    public PropertyItemBuilder(Property<T> prop, Class<? extends T> cls) {
        this.property = prop;
        this.cls = cls;
    }

    public PropertyItemBuilder<T> resourceManager(LocalizedResourceManager manager) {
        this.manager = manager;
        return this;
    }

    public PropertyItemBuilder<T> key(String key) {
        this.key = key;
        return this;
    }

    public PropertyItemBuilder<T> categoryKey(String key) {
        this.categoryKey = key;
        return this;
    }

    public PropertyItemBuilder<T> bundle(String name) {
        this.bundle = name;
        return this;
    }

    public PropertyItemBuilder<T> propertyType(PropertyType type) {
        this.propertyType = type;
        return this;
    }

    public PropertyItemBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public PropertyItemBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public PropertyItemBuilder<T> category(String category) {
        this.category = category;
        return this;
    }

    public PropertyItemBuilder<T> choices(Collection<T> choices) {
        return this.choices(FXCollections.observableArrayList(choices));
    }

    public PropertyItemBuilder<T> choices(ObservableList<T> choices) {
        this.choices = choices;
        this.propertyType = PropertyType.CHOICE;
        return this;
    }

    public PropertyItemBuilder<T> extensionFilters(Collection<? extends FileChooser.ExtensionFilter> filters) {
        this.extensionFilters = filters == null ? FXCollections.emptyObservableList() : FXCollections.observableArrayList(filters);
        return this;
    }

    public PropertySheet.Item build() {
        PropertyItem item = switch (this.propertyType) {
            case PropertyType.DIRECTORY -> new DirectoryPropertyItem(this.manager, this.property);
            case PropertyType.FILE -> new FilePropertyItem(this.manager, (Property<String>)this.property, (Collection<? extends FileChooser.ExtensionFilter>)this.extensionFilters);
            case PropertyType.COLOR -> new ColorPropertyItem(this.manager, (IntegerProperty)this.property);
            case PropertyType.CHOICE -> new ChoicePropertyItem<T>(this.manager, this.property, this.choices, this.cls, false);
            case PropertyType.SEARCHABLE_CHOICE -> new ChoicePropertyItem<T>(this.manager, this.property, this.choices, this.cls, true);
            default -> new DefaultPropertyItem<T>(this.manager, this.property, this.cls);
        };
        item.name(this.name);
        item.category(this.category);
        item.description(this.description);
        if (this.key != null) {
            item.key(this.bundle, this.key);
        }
        if (this.categoryKey != null) {
            item.categoryKey(this.bundle, this.categoryKey);
        }
        return item;
    }

    public static enum PropertyType {
        GENERAL,
        FILE,
        DIRECTORY,
        COLOR,
        CHOICE,
        SEARCHABLE_CHOICE;

    }
}

