/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs.controlsfx;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.DefaultPropertyEditorFactory;
import org.controlsfx.property.editor.PropertyEditor;
import qupath.fx.prefs.controlsfx.editors.ChoiceEditor;
import qupath.fx.prefs.controlsfx.editors.DirectoryEditor;
import qupath.fx.prefs.controlsfx.editors.FileEditor;
import qupath.fx.prefs.controlsfx.editors.SearchableChoiceEditor;
import qupath.fx.prefs.controlsfx.items.ChoicePropertyItem;
import qupath.fx.prefs.controlsfx.items.DirectoryPropertyItem;
import qupath.fx.prefs.controlsfx.items.FilePropertyItem;
import qupath.fx.prefs.controlsfx.items.PropertyItem;
import qupath.fx.utils.FXUtils;

public class PropertyEditorFactory
extends DefaultPropertyEditorFactory {
    private Map<Class<?>, Function<?, String>> reformatTypes = new HashMap();
    public Function<?, String> ENUM_REFORMATTER = PropertyEditorFactory::reformatEnum;
    private boolean bindLabelText = false;
    private Map<PropertySheet.Item, PropertyEditor<?>> cache = new ConcurrentHashMap();

    public PropertyEditor<?> call(PropertySheet.Item item) {
        Object editor = this.cache.getOrDefault(item, null);
        if (editor != null) {
            return editor;
        }
        if (item instanceof DirectoryPropertyItem) {
            editor = new DirectoryEditor(item);
        } else if (item.getType() == File.class) {
            List filters;
            if (item instanceof FilePropertyItem) {
                FilePropertyItem fileItem = (FilePropertyItem)item;
                filters = fileItem.getExtensionFilters();
            } else {
                filters = Collections.emptyList();
            }
            editor = new FileEditor(item, filters);
        } else {
            ChoicePropertyItem choiceItem;
            editor = item instanceof ChoicePropertyItem ? ((choiceItem = (ChoicePropertyItem)item).makeSearchable() ? new SearchableChoiceEditor((PropertySheet.Item)choiceItem, choiceItem.getChoices()) : new ChoiceEditor((PropertySheet.Item)choiceItem, choiceItem.getChoices())) : super.call(item);
        }
        if (this.reformatTypes.containsKey(item.getType()) && editor.getEditor() instanceof ComboBox) {
            ComboBox combo = (ComboBox)editor.getEditor();
            Function<?, String> formatter = this.reformatTypes.get(item.getType());
            combo.setCellFactory(obj -> FXUtils.createCustomListCell(formatter));
            combo.setButtonCell(FXUtils.createCustomListCell(formatter));
        }
        if (item instanceof PropertyItem) {
            PropertyItem propItem = (PropertyItem)item;
            Node node = editor.getEditor();
            if (node instanceof TextField) {
                TextField tf = (TextField)node;
                if (!tf.promptTextProperty().isBound()) {
                    tf.promptTextProperty().bindBidirectional((Property)propItem.promptProperty());
                }
            } else {
                ComboBoxBase combo;
                node = editor.getEditor();
                if (node instanceof ComboBoxBase && !(combo = (ComboBoxBase)node).promptTextProperty().isBound()) {
                    combo.promptTextProperty().bindBidirectional((Property)propItem.promptProperty());
                }
            }
        }
        if (this.bindLabelText && item instanceof PropertyItem) {
            ParentChangeListener listener = new ParentChangeListener((PropertyItem)item, editor.getEditor());
            editor.getEditor().parentProperty().addListener((ChangeListener)listener);
        }
        this.cache.put(item, (PropertyEditor<?>)editor);
        return editor;
    }

    public PropertyEditor<?> getEditor(PropertySheet.Item item) {
        return this.cache.get(item);
    }

    public void setReformatEnums(Class<? extends Enum> ... enumTypes) {
        for (Class<? extends Enum> cls : enumTypes) {
            this.setReformatType(cls, this.ENUM_REFORMATTER);
        }
    }

    public void setReformatType(Class<?> cls, Function<?, String> formatter) {
        if (formatter == null) {
            this.reformatTypes.remove(cls);
        } else {
            this.reformatTypes.put(cls, formatter);
        }
    }

    private static String reformatEnum(Object obj) {
        String s = Objects.toString(obj);
        if (Objects.equals(s = s.replaceAll("_", " "), s.toUpperCase())) {
            return s.substring(0, 1) + s.substring(1).toLowerCase();
        }
        return s;
    }

    private static class ParentChangeListener
    implements ChangeListener<Parent> {
        private PropertyItem item;
        private Node node;

        private ParentChangeListener(PropertyItem item, Node node) {
            this.item = item;
            this.node = node;
        }

        public void changed(ObservableValue<? extends Parent> observable, Parent oldValue, Parent newValue) {
            if (newValue == null) {
                return;
            }
            for (Node labelLookup : newValue.lookupAll(".label")) {
                Tooltip tooltip;
                Label label;
                if (!(labelLookup instanceof Label) || (label = (Label)labelLookup).getLabelFor() != this.node) continue;
                if (!label.textProperty().isBound()) {
                    label.textProperty().bind((ObservableValue)this.item.nameProperty());
                }
                if ((tooltip = label.getTooltip()) == null || tooltip.textProperty().isBound()) break;
                tooltip.textProperty().bind((ObservableValue)this.item.descriptionProperty());
                break;
            }
        }
    }
}

