/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.prefs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.StringProperty;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.prefs.PrefUtils;
import qupath.fx.utils.converters.EnumConverter;
import qupath.fx.utils.converters.FileConverter;
import qupath.fx.utils.converters.LocaleConverter;
import qupath.fx.utils.converters.PathConverter;
import qupath.fx.utils.converters.UriConverter;

public class PreferenceManager {
    private static final Logger logger = LoggerFactory.getLogger(PreferenceManager.class);
    private ReadOnlyObjectWrapper<Preferences> preferences = new ReadOnlyObjectWrapper();
    private final LongProperty reloadCount = new SimpleLongProperty(0L);
    private final LongProperty resetCount = new SimpleLongProperty(0L);

    private PreferenceManager(Preferences preferences) {
        Objects.requireNonNull(preferences, "Preferences cannot be null");
        this.preferences.set((Object)preferences);
        logger.trace("Preference manager created with name: {}", (Object)preferences.name());
    }

    public static PreferenceManager create(Preferences preferences) {
        return new PreferenceManager(preferences);
    }

    public static PreferenceManager createForUserPreferences(String pathName) {
        Preferences prefs = Preferences.userRoot().node(pathName);
        return PreferenceManager.create(prefs);
    }

    public static PreferenceManager createForSystemPreferences(String pathName) {
        Preferences prefs = Preferences.systemRoot().node(pathName);
        return PreferenceManager.create(prefs);
    }

    public Preferences getPreferences() {
        return (Preferences)this.preferences.get();
    }

    public ReadOnlyObjectProperty<Preferences> preferencesProperty() {
        return this.preferences.getReadOnlyProperty();
    }

    public synchronized void reset() throws BackingStoreException {
        Preferences oldPreferences = (Preferences)this.preferences.get();
        oldPreferences.removeNode();
        oldPreferences.flush();
        Preferences newPreferences = oldPreferences.isUserNode() ? Preferences.userRoot().node(oldPreferences.absolutePath()) : Preferences.systemRoot().node(oldPreferences.absolutePath());
        this.preferences.set((Object)newPreferences);
        this.resetCount.set(this.resetCount.get() + 1L);
    }

    public synchronized void reload() {
        this.reloadCount.set(this.reloadCount.get() + 1L);
    }

    public synchronized void save() throws BackingStoreException {
        ((Preferences)this.preferences.get()).flush();
    }

    public String toXml() throws IOException, BackingStoreException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ((Preferences)this.preferences.get()).exportSubtree(stream);
            String string = stream.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    public BooleanProperty createPersistentBooleanProperty(String key, boolean defaultValue) {
        BooleanProperty prop = PrefUtils.createPersistentBooleanProperty(this.preferences, key, defaultValue);
        this.reloadCount.addListener((observable, oldValue, newValue) -> prop.set(((Preferences)this.preferences.getValue()).getBoolean(key, prop.get())));
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public BooleanProperty createTransientBooleanProperty(String key, boolean defaultValue) {
        BooleanProperty prop = PrefUtils.createTransientBooleanProperty(key, defaultValue);
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public IntegerProperty createPersistentIntegerProperty(String key, int defaultValue) {
        IntegerProperty prop = PrefUtils.createPersistentIntegerProperty(this.preferences, key, defaultValue);
        this.reloadCount.addListener((observable, oldValue, newValue) -> prop.set(((Preferences)this.preferences.getValue()).getInt(key, prop.get())));
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public IntegerProperty createTransientIntegerProperty(String key, int defaultValue) {
        IntegerProperty prop = PrefUtils.createTransientIntegerProperty(key, defaultValue);
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public FloatProperty createPersistentFloatProperty(String key, float defaultValue) {
        FloatProperty prop = PrefUtils.createPersistentFloatProperty(this.preferences, key, defaultValue);
        this.reloadCount.addListener((observable, oldValue, newValue) -> prop.set(((Preferences)this.preferences.getValue()).getFloat(key, prop.get())));
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public FloatProperty createTransientFloatProperty(String key, float defaultValue) {
        FloatProperty prop = PrefUtils.createTransientFloatProperty(key, defaultValue);
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public DoubleProperty createPersistentDoubleProperty(String key, double defaultValue) {
        DoubleProperty prop = PrefUtils.createPersistentDoubleProperty(this.preferences, key, defaultValue);
        this.reloadCount.addListener((observable, oldValue, newValue) -> prop.set(((Preferences)this.preferences.getValue()).getDouble(key, prop.get())));
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public DoubleProperty createTransientDoubleProperty(String key, double defaultValue) {
        DoubleProperty prop = PrefUtils.createTransientDoubleProperty(key, defaultValue);
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public LongProperty createPersistentLongProperty(String key, long defaultValue) {
        LongProperty prop = PrefUtils.createPersistentLongProperty(this.preferences, key, defaultValue);
        this.reloadCount.addListener((observable, oldValue, newValue) -> prop.set(((Preferences)this.preferences.getValue()).getLong(key, prop.get())));
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public LongProperty createTransientLongProperty(String key, long defaultValue) {
        LongProperty prop = PrefUtils.createTransientLongProperty(key, defaultValue);
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public StringProperty createPersistentStringProperty(String key, String defaultValue) {
        StringProperty prop = PrefUtils.createPersistentStringProperty(this.preferences, key, defaultValue);
        this.reloadCount.addListener((observable, oldValue, newValue) -> prop.set((Object)((Preferences)this.preferences.getValue()).get(key, (String)prop.get())));
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set((Object)defaultValue));
        return prop;
    }

    public StringProperty createTransientStringProperty(String key, String defaultValue) {
        StringProperty prop = PrefUtils.createTransientStringProperty(key, defaultValue);
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set((Object)defaultValue));
        return prop;
    }

    public <T extends Enum> ObjectProperty<T> createPersistentEnumProperty(String key, T defaultValue, Class<T> enumType) {
        return this.createPersistentObjectProperty(key, defaultValue, new EnumConverter<T>(enumType));
    }

    public <T extends Enum> ObjectProperty<T> createPersistentEnumProperty(String key, T defaultValue) {
        return this.createPersistentEnumProperty(key, defaultValue, defaultValue.getClass());
    }

    public ObjectProperty<Path> createPersistentPathProperty(String key, Path defaultValue) {
        return this.createPersistentObjectProperty(key, defaultValue, new PathConverter());
    }

    public ObjectProperty<File> createPersistentFileProperty(String key, File defaultValue) {
        return this.createPersistentObjectProperty(key, defaultValue, new FileConverter());
    }

    public ObjectProperty<URI> createPersistentUriProperty(String key, URI defaultValue) {
        return this.createPersistentObjectProperty(key, defaultValue, new UriConverter());
    }

    public ObjectProperty<Locale> createPersistentLocaleProperty(String key, Locale defaultValue) {
        return this.createPersistentObjectProperty(key, defaultValue, new LocaleConverter());
    }

    public <T> ObjectProperty<T> createPersistentObjectProperty(String key, T defaultValue, StringConverter<T> converter) {
        ObjectProperty prop = PrefUtils.createPersistentObjectProperty(this.preferences, key, defaultValue, converter);
        this.reloadCount.addListener((observable, oldValue, newValue) -> prop.set(converter.fromString(((Preferences)this.preferences.getValue()).get(key, converter.toString(prop.get())))));
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }

    public <T> ObjectProperty<T> createPersistentObjectProperty(String key, T defaultValue, final Function<T, String> serializer, final Function<String, T> deserializer) {
        StringConverter converter = new StringConverter<T>(){

            public String toString(T object) {
                return (String)serializer.apply(object);
            }

            public T fromString(String string) {
                return deserializer.apply(string);
            }
        };
        return this.createPersistentObjectProperty(key, defaultValue, converter);
    }

    public <T> ObjectProperty<T> createTransientObjectProperty(String key, T defaultValue) {
        ObjectProperty prop = PrefUtils.createTransientObjectProperty(key, defaultValue);
        this.resetCount.addListener((observable, oldValue, newValue) -> prop.set(defaultValue));
        return prop;
    }
}

