/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.localization;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizedResourceManager {
    private final ResourceRefresher refresher = new ResourceRefresher();
    private String defaultBundleName;
    private ResourceBundle.Control control;
    private Function<String, ResourceBundle> bundleSupplier;

    private LocalizedResourceManager(String defaultBundleName, ResourceBundle.Control control, Function<String, ResourceBundle> bundleFunction) {
        this.defaultBundleName = defaultBundleName;
        this.control = control;
        this.bundleSupplier = bundleFunction == null ? this::getBundle : bundleFunction;
    }

    public static LocalizedResourceManager createInstance(String defaultBundleName) {
        return LocalizedResourceManager.createInstance(defaultBundleName, null);
    }

    public static LocalizedResourceManager createInstance(String defaultBundleName, ResourceBundle.Control control) {
        return new LocalizedResourceManager(defaultBundleName, control, null);
    }

    public String getDefaultBundleName() {
        return this.defaultBundleName;
    }

    private ResourceBundle getBundle(String name) {
        if (name == null) {
            name = this.defaultBundleName;
        }
        if (name == null) {
            throw new UnsupportedOperationException("No bundle name provided!");
        }
        if (this.control == null) {
            return ResourceBundle.getBundle(name);
        }
        return ResourceBundle.getBundle(name, Locale.getDefault(Locale.Category.DISPLAY), this.control);
    }

    public boolean hasString(String key) {
        if (this.defaultBundleName == null) {
            return false;
        }
        return this.hasString(this.defaultBundleName, key);
    }

    public boolean hasString(String bundleName, String key) {
        ResourceBundle bundle = this.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        return bundle.containsKey(key);
    }

    public String getString(String key) {
        return this.getString(this.defaultBundleName, key);
    }

    public String getString(String bundleName, String key) {
        return this.getBundle(bundleName).getString(key);
    }

    public void refresh() {
        this.refresher.refresh();
    }

    public void registerProperty(StringProperty property, String key) {
        this.registerProperty(property, null, key);
    }

    public void registerProperty(StringProperty property, String bundle, String key) {
        this.refresher.registerProperty(property, bundle, key);
    }

    public StringProperty createProperty(String key) {
        return this.createProperty(null, key);
    }

    public StringProperty createProperty(String bundle, String key) {
        SimpleStringProperty property = new SimpleStringProperty();
        this.registerProperty((StringProperty)property, bundle, key);
        return property;
    }

    private class ResourceRefresher {
        private List<PropertyWithResource> properties = new ArrayList<PropertyWithResource>();

        private ResourceRefresher() {
        }

        private PropertyWithResource registerProperty(StringProperty property, String bundle, String key) {
            PropertyWithResource refreshable = new PropertyWithResource(property, bundle, key);
            refreshable.refresh();
            this.properties.add(refreshable);
            return refreshable;
        }

        private void refresh() {
            for (PropertyWithResource r : this.properties) {
                r.refresh();
            }
        }
    }

    private class PropertyWithResource {
        private static final Logger logger = LoggerFactory.getLogger(PropertyWithResource.class);
        private String bundle;
        private String key;
        private StringProperty property;

        private PropertyWithResource(StringProperty property, String bundle, String key) {
            this.property = property;
            this.bundle = bundle;
            this.key = key;
        }

        public void refresh() {
            if (this.property.isBound()) {
                logger.debug("Cannot refresh {} with key {} (property is bound)", (Object)this.property, (Object)this.key);
            } else {
                try {
                    ResourceBundle resourceBundle = LocalizedResourceManager.this.bundleSupplier.apply(this.bundle);
                    this.property.set((Object)resourceBundle.getString(this.key));
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

