/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.localization;

import java.util.Locale;
import java.util.Objects;

public class LocaleSnapshot {
    private Locale main = Locale.getDefault();
    private Locale display = Locale.getDefault(Locale.Category.DISPLAY);
    private Locale format = Locale.getDefault(Locale.Category.FORMAT);

    public LocaleSnapshot() {
        this.refresh();
    }

    public void refresh() {
        this.main = Locale.getDefault();
        this.display = Locale.getDefault(Locale.Category.DISPLAY);
        this.format = Locale.getDefault(Locale.Category.FORMAT);
    }

    public Locale getMainLocale() {
        return this.main;
    }

    public Locale getDisplayLocale() {
        return this.display;
    }

    public Locale getFormatLocale() {
        return this.format;
    }

    public boolean hasChanged() {
        return !Objects.equals(this.main, Locale.getDefault()) || !Objects.equals(this.display, Locale.getDefault(Locale.Category.DISPLAY)) || !Objects.equals(this.format, Locale.getDefault(Locale.Category.FORMAT));
    }
}

