/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.localization;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.util.StringConverter;
import qupath.fx.utils.converters.LocaleConverter;

public class LocaleManager {
    private final Locale baseLocale;
    private final Map<String, Locale> localeMap = new TreeMap<String, Locale>();
    private final StringConverter<Locale> converter;
    private final boolean useCountryCodes;
    private final ObjectProperty<Predicate<Locale>> availableLanguagePredicateProperty = new SimpleObjectProperty();
    private final ObservableList<Locale> allLocales;
    private ObservableList<Locale> availableLocales;

    public LocaleManager() {
        this(l -> true);
    }

    public LocaleManager(Predicate<Locale> availableLocalesPredicate) {
        this(availableLocalesPredicate, true);
    }

    public LocaleManager(Predicate<Locale> availableLocalesPredicate, boolean useCountryCodes) {
        this(Locale.US, availableLocalesPredicate, useCountryCodes);
    }

    public LocaleManager(Locale baseLocale, Predicate<Locale> availableLocalesPredicate) {
        this(baseLocale, availableLocalesPredicate, true);
    }

    public LocaleManager(Locale baseLocale, Predicate<Locale> availableLocalesPredicate, boolean useCountryCodes) {
        Objects.requireNonNull(baseLocale, "Base locale cannot be null");
        this.baseLocale = baseLocale;
        this.useCountryCodes = useCountryCodes;
        this.availableLanguagePredicateProperty.set(availableLocalesPredicate);
        this.initializeLocaleMap();
        this.converter = new LocaleConverter(baseLocale);
        this.allLocales = FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList(this.localeMap.values()));
        this.createAvailableLocaleList();
    }

    private void initializeLocaleMap() {
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!this.localeFilter(locale)) continue;
            String name = locale.getDisplayName(this.baseLocale);
            this.localeMap.putIfAbsent(name, locale);
        }
    }

    private boolean localeFilter(Locale locale) {
        if (Objects.equals(locale, this.baseLocale)) {
            return true;
        }
        return !locale.getLanguage().isBlank() && (this.useCountryCodes || locale.getCountry().isEmpty()) && locale != Locale.ENGLISH;
    }

    public ObservableList<Locale> getAllLocales() {
        return this.allLocales;
    }

    public boolean useCountryCodes() {
        return this.useCountryCodes;
    }

    public ObservableList<Locale> getAvailableLocales() {
        return this.availableLocales;
    }

    private void createAvailableLocaleList() {
        this.availableLocales = FXCollections.observableArrayList();
        this.refreshAvailableLocales();
        this.availableLanguagePredicateProperty.addListener((v, o, n) -> this.refreshAvailableLocales());
    }

    public void refreshAvailableLocales() {
        Predicate predicate = (Predicate)this.availableLanguagePredicateProperty.get();
        FilteredList newContents = predicate == null ? this.allLocales : this.allLocales.filtered(predicate);
        if (this.availableLocales.size() != newContents.size() || !new HashSet<Locale>((Collection<Locale>)this.availableLocales).containsAll((Collection<?>)newContents)) {
            this.availableLocales.setAll((Collection)newContents);
        }
    }
}

