/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.dialogs;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.utils.FXUtils;

public class FileChoosers {
    private static final Logger logger = LoggerFactory.getLogger(FileChoosers.class);
    private static final LocalizedResourceManager resources = LocalizedResourceManager.createInstance("qupath.fx.localization.strings");
    private static final Map<Window, String> lastPathOrUriMap = new WeakHashMap<Window, String>();
    private static final Map<Window, File> lastDirectoryMap = new WeakHashMap<Window, File>();
    public static FileChooser.ExtensionFilter FILTER_ALL_FILES = new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"});

    public static List<File> promptForMultipleFiles(FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptForMultipleFiles(null, null, extensionFilters);
    }

    public static List<File> promptForMultipleFiles(String title, FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptForMultipleFiles(null, title, extensionFilters);
    }

    public static List<File> promptForMultipleFiles(Window owner, String title, FileChooser.ExtensionFilter ... extensionFilters) {
        FileChooser chooser = FileChoosers.buildFileChooser().title(title == null ? resources.getString("chooseMultipleFiles") : title).initialDirectory(FileChoosers.getInitialDirectoryForOwner(owner)).extensionFilters(extensionFilters).build();
        List files = FXUtils.callOnApplicationThread(() -> chooser.showOpenMultipleDialog(FileChoosers.getOwnerOrDefault(owner)));
        if (files != null && !files.isEmpty()) {
            FileChoosers.updateInitialDirectoryFromSelectedFile(owner, (File)files.get(0));
        }
        return files;
    }

    public static File promptForDirectory() {
        return FileChoosers.promptForDirectory(null, null);
    }

    public static File promptForDirectory(String title, File initialDir) {
        return FileChoosers.promptForDirectory(null, title, initialDir);
    }

    public static File promptForDirectory(Window owner, String title, File initialDir) {
        DirectoryChooser chooser = FileChoosers.buildDirectoryChooser().title(title == null ? resources.getString("chooseDirectory") : title).initialDirectory(FileChoosers.getInitialDirectoryForOwner(owner)).initialFile(initialDir).build();
        File dir = FXUtils.callOnApplicationThread(() -> chooser.showDialog(FileChoosers.getDefaultOwner()));
        FileChoosers.updateInitialDirectoryFromSelectedFile(owner, dir);
        return dir;
    }

    public static File promptForFile(FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptForFile(null, extensionFilters);
    }

    public static File promptForFile(String title, FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptForFile(null, title, extensionFilters);
    }

    public static File promptForFile(Window owner, String title, FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptForFile(owner, title, null, extensionFilters);
    }

    public static File promptForFile(Window owner, String title, File initialFile, FileChooser.ExtensionFilter ... extensionFilters) {
        File initialDir = null;
        String initialName = null;
        if (initialFile != null) {
            if (initialFile.isFile()) {
                initialDir = initialFile.getParentFile();
                initialName = initialFile.getName();
            } else if (initialFile.isDirectory()) {
                initialDir = initialFile;
            }
        }
        if (initialDir == null) {
            initialDir = FileChoosers.getInitialDirectoryForOwner(owner);
        }
        FileChooser chooser = FileChoosers.buildFileChooser().title(title == null ? resources.getString("chooseFile") : title).initialDirectory(initialDir).initialFileName(initialName).extensionFilters(extensionFilters).build();
        File file = FXUtils.callOnApplicationThread(() -> chooser.showOpenDialog(FileChoosers.getOwnerOrDefault(owner)));
        FileChoosers.updateInitialDirectoryFromSelectedFile(owner, file);
        return file;
    }

    public static File promptToSaveFile(FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptToSaveFile(null, null, extensionFilters);
    }

    public static File promptToSaveFile(String title, File initialFile, FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptToSaveFile(null, title, initialFile, extensionFilters);
    }

    public static File promptToSaveFile(Window owner, String title, File initialFile, FileChooser.ExtensionFilter ... extensionFilters) {
        FileChooser.ExtensionFilter filter;
        FileChooser chooser = FileChoosers.buildFileChooser().title(title == null ? resources.getString("saveFile") : title).initialDirectory(FileChoosers.getInitialDirectoryForOwner(owner)).initialFile(initialFile).extensionFilters(extensionFilters).build();
        File file = FXUtils.callOnApplicationThread(() -> chooser.showSaveDialog(FileChoosers.getOwnerOrDefault(owner)));
        if (file != null && (filter = chooser.getSelectedExtensionFilter()) != null) {
            file = FileChoosers.ensureNameEndsWithExtension(file, filter);
        }
        FileChoosers.updateInitialDirectoryFromSelectedFile(owner, file);
        return file;
    }

    public static String promptForFilePathOrURI(FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptForFilePathOrURI(null, null, extensionFilters);
    }

    public static String promptForFilePathOrURI(String title, String defaultText, FileChooser.ExtensionFilter ... extensionFilters) {
        return FileChoosers.promptForFilePathOrURI(null, title, defaultText, extensionFilters);
    }

    public static String promptForFilePathOrURI(Window owner, String title, String defaultText, FileChooser.ExtensionFilter ... extensionFilters) {
        ButtonType result;
        FileOrUriChooserPane chooserPane = new FileOrUriChooserPane(extensionFilters);
        if (defaultText == null) {
            defaultText = lastPathOrUriMap.getOrDefault(owner, "");
        }
        if (defaultText != null) {
            chooserPane.setText(defaultText);
        }
        if ((result = Dialogs.builder().content((Node)chooserPane).buttons(ButtonType.OK, ButtonType.CANCEL).owner(owner).title(title).showAndWait().orElse(ButtonType.CANCEL)) == ButtonType.OK) {
            String text = chooserPane.getText();
            if (text != null) {
                lastPathOrUriMap.put(owner, text);
            }
            return text;
        }
        return null;
    }

    public static FileChooser.ExtensionFilter createExtensionFilter(String description, String ... extensions) {
        return FileChoosers.createExtensionFilter(description, Arrays.asList(extensions));
    }

    public static FileChooser.ExtensionFilter createExtensionFilter(String description, Collection<String> extensions) {
        List<String> extensionsCorrected = extensions.stream().map(FileChoosers::ensureExtensionFilterValid).toList();
        if (description == null) {
            description = resources.getString("validFilesDescription");
        }
        return new FileChooser.ExtensionFilter(description, extensionsCorrected);
    }

    private static String ensureExtensionFilterValid(String ext) {
        if (ext.startsWith("*.")) {
            return ext;
        }
        if (ext.startsWith(".")) {
            return "*" + ext;
        }
        return "*." + ext;
    }

    private static void updateInitialDirectoryFromSelectedFile(Window owner, File file) {
        while (file != null && !file.isDirectory()) {
            file = file.getParentFile();
        }
        if (file != null) {
            lastDirectoryMap.put(owner, file);
        }
    }

    private static File getInitialDirectoryForOwner(Window owner) {
        File dir = lastDirectoryMap.getOrDefault(owner, null);
        if (dir == null && owner != null) {
            return lastDirectoryMap.getOrDefault(null, null);
        }
        return null;
    }

    private static Window getOwnerOrDefault(Window owner) {
        return owner == null ? FileChoosers.getDefaultOwner() : owner;
    }

    private static Window getDefaultOwner() {
        return Dialogs.getDefaultOwner();
    }

    public static Builder<FileChooser> buildFileChooser() {
        return new FileChooserBuilder();
    }

    public static Builder<DirectoryChooser> buildDirectoryChooser() {
        return new DirectoryChooserBuilder();
    }

    private static File ensureNameEndsWithExtension(File file, FileChooser.ExtensionFilter filter) {
        String nameCorrected;
        String name = file.getName();
        if (Objects.equals(name, nameCorrected = FileChoosers.ensureNameEndsWithExtension(name, filter))) {
            return file;
        }
        return new File(file.getParentFile(), nameCorrected);
    }

    private static String ensureNameEndsWithExtension(String name, FileChooser.ExtensionFilter filter) {
        if (filter == null || name == null || FileChoosers.acceptAllFiles(filter) || filter.getExtensions().isEmpty()) {
            return name;
        }
        for (String extension : filter.getExtensions()) {
            String ext = FileChoosers.stripExtensionPrefix(extension);
            if (!name.toLowerCase().endsWith(ext.toLowerCase())) continue;
            return FileChoosers.ensureExtensionNotRepeated(name, ext);
        }
        String ext = FileChoosers.stripExtensionPrefix((String)filter.getExtensions().get(0));
        int lastDotInd = ext.lastIndexOf(".");
        if (lastDotInd > 0) {
            String lastPart = ext.substring(ext.lastIndexOf("."));
            if (name.toLowerCase().endsWith(lastPart.toLowerCase())) {
                name = name.substring(0, name.length() - lastPart.length());
            }
        }
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return FileChoosers.ensureExtensionNotRepeated(name + ext, ext);
    }

    private static String ensureExtensionNotRepeated(String name, String ext) {
        if (ext.startsWith("*")) {
            ext = ext.substring(1);
        }
        ext = ext.toLowerCase();
        while (name.toLowerCase().endsWith(ext + ext)) {
            name = name.substring(0, name.length() - ext.length());
        }
        return name;
    }

    private static boolean acceptAllFiles(FileChooser.ExtensionFilter filter) {
        if (Objects.equals(FILTER_ALL_FILES, filter)) {
            return true;
        }
        return filter.getExtensions().stream().anyMatch("*.*"::equals);
    }

    private static boolean isMultipartExtension(String ext) {
        int last;
        int first = ext.indexOf(".");
        return first != (last = ext.lastIndexOf("."));
    }

    private static String stripExtensionPrefix(String extension) {
        int ind = extension.indexOf("*.");
        return ind < 0 ? extension : extension.substring(ind + 1);
    }

    private static boolean isMac() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    }

    public static void main(String[] args) {
        Platform.startup(FileChoosers::showChooser);
    }

    private static void showChooser() {
        Stage stage = new Stage();
        stage.setScene(new Scene((Parent)new Pane()));
        stage.setTitle("Dummy");
        stage.show();
        for (String ext : List.of("*.txt", "*.tif", "*.ome.tif", "*.zarr", "*.ome.zarr", "*.*")) {
            FileChooser.ExtensionFilter filter = FileChoosers.createExtensionFilter("A filter", ext);
            File file = FileChoosers.promptToSaveFile("Some title", null, filter);
            if (file == null) {
                System.out.println("No file selected for " + ext);
                break;
            }
            System.out.println("Extension: " + ext + ", Selected file: " + String.valueOf(file));
        }
        stage.close();
    }

    public static abstract class Builder<T> {
        protected StringProperty titleProperty;
        protected File initialDirectory;
        protected String initialFileName;
        protected Set<FileChooser.ExtensionFilter> extensionFilters = new LinkedHashSet<FileChooser.ExtensionFilter>();
        protected FileChooser.ExtensionFilter selectedExtensionFilter = null;

        public abstract T build();

        public Builder<T> title(String title) {
            return this.titleProperty((StringProperty)new SimpleStringProperty(title));
        }

        public Builder<T> titleProperty(StringProperty titleProperty) {
            this.titleProperty = titleProperty;
            return this;
        }

        public Builder<T> initialDirectory(File dir) {
            this.initialDirectory = dir;
            return this;
        }

        public Builder<T> initialFile(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return this.initialDirectory(file);
                }
                if (file.getParentFile() != null && file.getParentFile().isDirectory()) {
                    this.initialDirectory(file.getParentFile());
                }
                return this.initialFileName(file.getName());
            }
            return this;
        }

        public Builder<T> initialFileName(String name) {
            this.initialFileName = name;
            return this;
        }

        public Builder<T> extensionFilter(String description, String ... extensions) {
            return this.extensionFilters(FileChoosers.createExtensionFilter(description, extensions));
        }

        public Builder<T> extensionFilter(String description, Collection<String> extensions) {
            return this.extensionFilters(FileChoosers.createExtensionFilter(description, extensions));
        }

        public Builder<T> extensionFilters(FileChooser.ExtensionFilter ... extensionFilters) {
            return this.extensionFilters(Arrays.asList(extensionFilters));
        }

        public Builder<T> extensionFilters(Collection<? extends FileChooser.ExtensionFilter> extensionFilters) {
            this.extensionFilters.clear();
            for (FileChooser.ExtensionFilter extensionFilter : extensionFilters) {
                if (extensionFilter == null) continue;
                this.extensionFilters.add(extensionFilter);
            }
            return this;
        }

        public Builder<T> selectedExtensionFilter(FileChooser.ExtensionFilter extensionFilter) {
            this.selectedExtensionFilter = extensionFilter;
            return this;
        }
    }

    private static class FileOrUriChooserPane
    extends GridPane {
        private final FileChooser.ExtensionFilter[] filters;
        private final StringProperty textProperty;

        private FileOrUriChooserPane(FileChooser.ExtensionFilter ... filters) {
            this.filters = (FileChooser.ExtensionFilter[])filters.clone();
            Label label = new Label(resources.getString("enterUri"));
            TextField textField = new TextField();
            textField.setPromptText(resources.getString("enterUriPrompt"));
            textField.setPrefColumnCount(32);
            this.textProperty = textField.textProperty();
            label.setLabelFor((Node)textField);
            Button buttonFile = new Button(resources.getString("chooseFile"));
            buttonFile.setOnAction(e -> this.handleButtonPress());
            this.add((Node)label, 0, 0);
            this.add((Node)textField, 1, 0);
            this.add((Node)buttonFile, 2, 0);
            GridPane.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
        }

        private void handleButtonPress() {
            File file = FileChoosers.promptForFile(this.filters);
            if (file != null) {
                this.textProperty.set((Object)file.getAbsolutePath());
            }
        }

        public void setText(String text) {
            this.textProperty.set((Object)text);
        }

        public StringProperty textProperty() {
            return this.textProperty;
        }

        public String getText() {
            return (String)this.textProperty.get();
        }
    }

    private static class FileChooserBuilder
    extends Builder<FileChooser> {
        private FileChooserBuilder() {
        }

        @Override
        public FileChooser build() {
            FileChooser chooser = new FileChooser();
            if (this.titleProperty != null) {
                chooser.titleProperty().bind((ObservableValue)this.titleProperty);
            }
            if (this.extensionFilters.isEmpty()) {
                chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{FILTER_ALL_FILES});
            } else {
                chooser.getExtensionFilters().setAll((Collection)this.extensionFilters);
            }
            if (this.selectedExtensionFilter != null) {
                chooser.setSelectedExtensionFilter(this.selectedExtensionFilter);
            } else {
                chooser.setSelectedExtensionFilter((FileChooser.ExtensionFilter)chooser.getExtensionFilters().get(0));
            }
            if (this.initialDirectory != null && this.initialDirectory.isDirectory()) {
                chooser.setInitialDirectory(this.initialDirectory);
            }
            if (this.initialFileName != null) {
                chooser.setInitialFileName(this.initialFileName);
            } else {
                String ext;
                FileChooser.ExtensionFilter filter = chooser.getSelectedExtensionFilter();
                if (filter != null && !filter.getExtensions().isEmpty() && !FileChoosers.acceptAllFiles(filter) && FileChoosers.isMac() && FileChoosers.isMultipartExtension(ext = (String)filter.getExtensions().get(0))) {
                    String initialName = "Untitled" + ext.substring(ext.indexOf("."), ext.lastIndexOf("."));
                    chooser.setInitialFileName(initialName);
                }
            }
            return chooser;
        }
    }

    private static class DirectoryChooserBuilder
    extends Builder<DirectoryChooser> {
        private DirectoryChooserBuilder() {
        }

        @Override
        public DirectoryChooser build() {
            DirectoryChooser chooser = new DirectoryChooser();
            if (this.titleProperty != null) {
                chooser.titleProperty().bind((ObservableValue)this.titleProperty);
            }
            if (this.initialDirectory != null && this.initialDirectory.isDirectory()) {
                chooser.setInitialDirectory(this.initialDirectory);
            }
            return chooser;
        }
    }
}

