/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Modality;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.ControlsFXNotifications;
import qupath.fx.utils.FXUtils;

public class Dialogs {
    private static final Logger logger = LoggerFactory.getLogger(Dialogs.class);
    private static Window primaryWindow;
    private static ObservableList<String> knownExtensions;
    private static boolean controlsFxMissing;

    public static void setPrimaryWindow(Window window) {
        primaryWindow = window;
    }

    public static Window getPrimaryWindow() {
        return primaryWindow;
    }

    public static ObservableList<String> getKnownFileExtensions() {
        return knownExtensions;
    }

    public static boolean showConfirmDialog(String title, String text) {
        return Dialogs.showConfirmDialog(title, (Node)Dialogs.createContentLabel(text));
    }

    public static boolean showMessageDialog(String title, Node node) {
        return new Builder().buttons(ButtonType.OK).title(title).content(node).resizable().showAndWait().orElse(ButtonType.CANCEL) == ButtonType.OK;
    }

    public static boolean showMessageDialog(String title, String message) {
        return Dialogs.showMessageDialog(title, (Node)Dialogs.createContentLabel(message));
    }

    public static boolean showConfirmDialog(String title, Node node) {
        return new Builder().alertType(Alert.AlertType.CONFIRMATION).buttons(ButtonType.OK, ButtonType.CANCEL).title(title).content(node).resizable().showAndWait().orElse(ButtonType.CANCEL) == ButtonType.OK;
    }

    public static boolean showYesNoDialog(String title, String text) {
        return new Builder().alertType(Alert.AlertType.NONE).buttons(ButtonType.YES, ButtonType.NO).title(title).content((Node)Dialogs.createContentLabel(text)).showAndWait().orElse(ButtonType.NO) == ButtonType.YES;
    }

    private static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public static ButtonType showYesNoCancelDialog(String title, String text) {
        return new Builder().alertType(Alert.AlertType.NONE).buttons(ButtonType.YES, ButtonType.NO, ButtonType.CANCEL).title(title).content((Node)Dialogs.createContentLabel(text)).showAndWait().orElse(ButtonType.CANCEL);
    }

    public static Double showInputDialog(String title, String message, Double initialInput) {
        if (Platform.isFxApplicationThread()) {
            TextInputDialog dialog = new TextInputDialog(initialInput.toString());
            FXUtils.restrictTextFieldInputToNumber(dialog.getEditor(), true);
            dialog.setTitle(title);
            dialog.initOwner(Dialogs.getDefaultOwner());
            dialog.setHeaderText(null);
            dialog.setContentText(message);
            dialog.setResizable(true);
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                try {
                    return Double.parseDouble((String)result.get());
                }
                catch (Exception e) {
                    logger.error("Unable to parse numeric value from {}", (Object)result);
                    return Double.NaN;
                }
            }
        } else {
            return FXUtils.callOnApplicationThread(() -> Dialogs.showInputDialog(title, message, initialInput));
        }
        return null;
    }

    public static String showInputDialog(String title, String message, String initialInput) {
        if (Platform.isFxApplicationThread()) {
            TextInputDialog dialog = new TextInputDialog(initialInput);
            dialog.setTitle(title);
            dialog.initOwner(Dialogs.getDefaultOwner());
            dialog.setHeaderText(null);
            dialog.setContentText(message);
            dialog.setResizable(true);
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                return (String)result.get();
            }
        } else {
            return FXUtils.callOnApplicationThread(() -> Dialogs.showInputDialog(title, message, initialInput));
        }
        return null;
    }

    public static <T> T showChoiceDialog(String title, String message, T[] choices, T defaultChoice) {
        return Dialogs.showChoiceDialog(title, message, Arrays.asList(choices), defaultChoice);
    }

    public static <T> T showChoiceDialog(String title, String message, Collection<T> choices, T defaultChoice) {
        if (Platform.isFxApplicationThread()) {
            ChoiceDialog dialog = new ChoiceDialog(defaultChoice, choices);
            dialog.setTitle(title);
            dialog.initOwner(Dialogs.getDefaultOwner());
            dialog.getDialogPane().setHeaderText(null);
            if (message != null) {
                dialog.getDialogPane().setContentText(message);
            }
            Optional result = dialog.showAndWait();
            return result.orElse(null);
        }
        return (T)FXUtils.callOnApplicationThread(() -> Dialogs.showChoiceDialog(title, message, choices, defaultChoice));
    }

    public static void showErrorMessage(String title, Throwable e) {
        Object message = e.getLocalizedMessage();
        if (message == null) {
            message = "This app has encountered a problem, sorry.\n\n" + String.valueOf(e);
        }
        Dialogs.showErrorMessage(title, (String)message);
        if (Dialogs.isHeadless()) {
            logger.error(title, e);
        }
    }

    public static void showErrorNotification(String title, Throwable e) {
        Object message = e.getLocalizedMessage();
        if (Dialogs.isHeadless()) {
            if (message != null && !((String)message).isBlank() && !((String)message).equals(title)) {
                logger.error(title + ": " + e.getLocalizedMessage(), e);
            } else {
                logger.error(title, e);
            }
        } else {
            if (message == null || ((String)message).isBlank()) {
                message = "Unknown error (" + e.getClass().getSimpleName() + ")";
            }
            Dialogs.showNotification(title, (String)message, Alert.AlertType.ERROR);
        }
    }

    public static void showErrorNotification(String title, String message) {
        if (Dialogs.isHeadless()) {
            logger.error(title + ": " + message);
        } else {
            Dialogs.showNotification(title, message, Alert.AlertType.ERROR);
        }
    }

    public static void showWarningNotification(String title, String message) {
        if (Dialogs.isHeadless()) {
            logger.warn(title + ": " + message);
        } else {
            Dialogs.showNotification(title, message, Alert.AlertType.WARNING);
        }
    }

    public static void showInfoNotification(String title, String message) {
        if (Dialogs.isHeadless()) {
            logger.info(title + ": " + message);
        } else {
            Dialogs.showNotification(title, message, Alert.AlertType.INFORMATION);
        }
    }

    public static void showPlainNotification(String title, String message) {
        if (Dialogs.isHeadless()) {
            logger.info(title + ": " + message);
        } else {
            Dialogs.showNotification(title, message, Alert.AlertType.NONE);
        }
    }

    private static void showNotification(String title, String message, Alert.AlertType type) {
        if (!controlsFxMissing) {
            try {
                ControlsFXNotifications.showNotifications(title, message, type);
                return;
            }
            catch (NoClassDefFoundError e) {
                logger.warn("ControlsFX notifications are not available, showing dialog instead");
                controlsFxMissing = true;
            }
        }
        new Builder().buttons(ButtonType.OK).title(title).contentText(message).alertType(type).resizable().show();
    }

    public static void showErrorMessage(String title, String message) {
        if (Dialogs.isHeadless()) {
            logger.error(title + ": " + message);
        } else {
            Label content = message == null || message.isBlank() ? Dialogs.createContentLabel("This app has encountered a problem, sorry") : Dialogs.createContentLabel(message);
            Dialogs.showErrorMessage(title, (Node)content);
        }
    }

    public static void showErrorMessage(String title, Node node) {
        new Builder().alertType(Alert.AlertType.ERROR).title(title).content(node).show();
    }

    public static void showPlainMessage(String title, String message) {
        if (Dialogs.isHeadless()) {
            logger.info(title + ": " + message);
        } else {
            new Builder().alertType(Alert.AlertType.INFORMATION).title(title).content((Node)Dialogs.createContentLabel(message)).show();
        }
    }

    public static void showTextWindow(Window owner, String title, String contents, Modality modality, boolean isEditable) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> Dialogs.showTextWindow(owner, title, contents, modality, isEditable));
            return;
        }
        logger.info("{}\n{}", (Object)title, (Object)contents);
        Stage dialog = new Stage();
        if (owner == null) {
            dialog.initOwner(Dialogs.getDefaultOwner());
        } else {
            dialog.initOwner(owner);
        }
        dialog.initModality(modality);
        dialog.setTitle(title);
        TextArea textArea = new TextArea();
        textArea.setPrefColumnCount(60);
        textArea.setPrefRowCount(25);
        textArea.setText(contents);
        textArea.setWrapText(true);
        textArea.positionCaret(0);
        textArea.setEditable(isEditable);
        dialog.setScene(new Scene((Parent)textArea));
        dialog.show();
    }

    static Window getDefaultOwner() {
        Comparator<Window> comparator = Comparator.comparing(w -> Dialogs.isModal(w) ? -1 : 1).thenComparing(w -> w.isFocused() ? -1 : 1).thenComparing(w -> w == primaryWindow).thenComparing(Dialogs::getTitle);
        Window owner = Window.getWindows().stream().filter(w -> !(w instanceof PopupWindow)).sorted(comparator).findFirst().orElse(primaryWindow);
        return owner;
    }

    private static String getTitle(Window window) {
        String title = null;
        if (window instanceof Stage) {
            Stage stage = (Stage)window;
            title = stage.getTitle();
        }
        return title == null ? "" : title;
    }

    private static boolean isModal(Window window) {
        if (window instanceof Stage) {
            Stage stage = (Stage)window;
            return stage.getModality() != Modality.NONE;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    static boolean isHeadless() {
        return Window.getWindows().isEmpty();
    }

    public static void main(String[] args) {
        System.out.println("Starting main...");
        Platform.startup(() -> {
            Stage stage = new Stage();
            stage.setTitle("Title");
            stage.setScene(new Scene((Parent)new Label("Minimal stage")));
            stage.show();
            Dialogs.showInfoNotification("Info", "This is normal info");
            Dialogs.showErrorNotification("Uh-oh", "This is erroneous!");
        });
        System.out.println("Ending main");
    }

    static {
        knownExtensions = FXCollections.observableArrayList();
        controlsFxMissing = false;
    }

    public static class Builder {
        private Alert.AlertType alertType;
        private Window owner = null;
        private String title = "";
        private String header = null;
        private String contentText = null;
        private Node expandableContent = null;
        private Node content = null;
        private boolean resizable = false;
        private double width = -1.0;
        private double height = -1.0;
        private double prefWidth = -1.0;
        private double prefHeight = -1.0;
        private List<ButtonType> buttons = null;
        private Modality modality = Modality.APPLICATION_MODAL;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder headerText(String header) {
            this.header = header;
            return this;
        }

        public Builder contentText(String content) {
            this.contentText = content;
            return this;
        }

        public Builder content(Node content) {
            this.content = content;
            return this;
        }

        public Builder expandableContent(Node content) {
            this.expandableContent = content;
            return this;
        }

        public Builder owner(Window owner) {
            this.owner = owner;
            return this;
        }

        public Builder resizable() {
            this.resizable = true;
            return this;
        }

        public Builder nonModal() {
            this.modality = Modality.NONE;
            return this;
        }

        public Builder modality(Modality modality) {
            this.modality = modality;
            return this;
        }

        public Builder alertType(Alert.AlertType type) {
            this.alertType = type;
            return this;
        }

        public Builder warning() {
            return this.alertType(Alert.AlertType.WARNING);
        }

        public Builder error() {
            return this.alertType(Alert.AlertType.ERROR);
        }

        public Builder information() {
            return this.alertType(Alert.AlertType.INFORMATION);
        }

        public Builder confirmation() {
            return this.alertType(Alert.AlertType.CONFIRMATION);
        }

        public Builder buttons(ButtonType ... buttonTypes) {
            this.buttons = Arrays.asList(buttonTypes);
            return this;
        }

        public Builder buttons(String ... buttonNames) {
            ArrayList<ButtonType> list = new ArrayList<ButtonType>();
            for (String name : buttonNames) {
                list.add(switch (name.toLowerCase()) {
                    case "ok" -> ButtonType.OK;
                    case "yes" -> ButtonType.YES;
                    case "no" -> ButtonType.NO;
                    case "cancel" -> ButtonType.CANCEL;
                    case "apply" -> ButtonType.APPLY;
                    case "close" -> ButtonType.CLOSE;
                    case "finish" -> ButtonType.FINISH;
                    case "next" -> ButtonType.NEXT;
                    case "previous" -> ButtonType.PREVIOUS;
                    default -> new ButtonType(name);
                });
            }
            this.buttons = list;
            return this;
        }

        public Builder width(double width) {
            this.width = width;
            return this;
        }

        public Builder height(double height) {
            this.height = height;
            return this;
        }

        public Builder prefWidth(double prefWidth) {
            this.prefWidth = prefWidth;
            return this;
        }

        public Builder prefHeight(double prefHeight) {
            this.prefHeight = prefHeight;
            return this;
        }

        public Builder size(double width, double height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Dialog<ButtonType> build() {
            Object dialog = this.alertType == null ? new Dialog() : new Alert(this.alertType);
            if (this.owner == null) {
                dialog.initOwner(Dialogs.getDefaultOwner());
            } else {
                dialog.initOwner(this.owner);
            }
            dialog.setTitle(this.title);
            if (this.header != null) {
                dialog.setHeaderText(this.header);
            } else {
                dialog.setHeaderText(null);
            }
            if (this.contentText != null) {
                dialog.setContentText(this.contentText);
            }
            if (this.content != null) {
                dialog.getDialogPane().setContent(this.content);
            }
            if (this.expandableContent != null) {
                dialog.getDialogPane().setExpandableContent(this.expandableContent);
            }
            if (this.width > 0.0) {
                dialog.setWidth(this.width);
            }
            if (this.height > 0.0) {
                dialog.setHeight(this.height);
            }
            if (this.prefWidth > 0.0) {
                dialog.getDialogPane().setPrefWidth(this.prefWidth);
            }
            if (this.prefHeight > 0.0) {
                dialog.getDialogPane().setPrefHeight(this.prefHeight);
            }
            if (this.buttons != null) {
                dialog.getDialogPane().getButtonTypes().setAll(this.buttons);
            }
            if (dialog.getDialogPane().getButtonTypes().isEmpty()) {
                dialog.getDialogPane().getScene().getWindow().setOnCloseRequest(arg_0 -> Builder.lambda$build$0((Dialog)dialog, arg_0));
            }
            dialog.setResizable(this.resizable);
            dialog.initModality(this.modality);
            if (Insets.EMPTY.equals((Object)dialog.getDialogPane().getPadding())) {
                dialog.getDialogPane().setStyle("-fx-background-insets: -1; -fx-padding: 1px;");
            }
            return dialog;
        }

        public void show() {
            if (Dialogs.isHeadless()) {
                logger.warn("Cannot show dialog in headless mode!");
                return;
            }
            FXUtils.runOnApplicationThread(() -> this.build().show());
        }

        public Optional<ButtonType> showAndWait() {
            return FXUtils.callOnApplicationThread(() -> this.build().showAndWait());
        }

        private static /* synthetic */ void lambda$build$0(Dialog dialog, WindowEvent e) {
            dialog.hide();
        }
    }
}

