/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.dialogs;

import java.net.URL;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import org.controlsfx.control.Notifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;

class ControlsFXNotifications {
    private static final Logger logger = LoggerFactory.getLogger(ControlsFXNotifications.class);

    ControlsFXNotifications() {
    }

    static void showNotifications(String title, String message, Alert.AlertType type) {
        if (Dialogs.isHeadless()) {
            logger.warn("Cannot show notifications in headless mode!");
            return;
        }
        if (Platform.isFxApplicationThread()) {
            switch (type) {
                case CONFIRMATION: {
                    ControlsFXNotifications.createNotifications().title(title).text(message).showConfirm();
                    break;
                }
                case ERROR: {
                    ControlsFXNotifications.createNotifications().title(title).text(message).showError();
                    break;
                }
                case INFORMATION: {
                    ControlsFXNotifications.createNotifications().title(title).text(message).showInformation();
                    break;
                }
                case WARNING: {
                    ControlsFXNotifications.createNotifications().title(title).text(message).showWarning();
                    break;
                }
                default: {
                    ControlsFXNotifications.createNotifications().title(title).text(message).show();
                    break;
                }
            }
        } else {
            Platform.runLater(() -> ControlsFXNotifications.showNotifications(title, message, type));
        }
    }

    private static Notifications createNotifications() {
        Window stage = Dialogs.getPrimaryWindow();
        if (stage == null) {
            stage = Dialogs.getDefaultOwner();
        }
        Notifications notifications = Notifications.create();
        if (stage == null) {
            return notifications;
        }
        Scene scene = stage.getScene();
        if (scene != null) {
            URL url = Dialogs.class.getClassLoader().getResource("qupath/fx/dialogs/notificationscustom.css");
            String stylesheetUrl = url.toExternalForm();
            if (!scene.getStylesheets().contains((Object)stylesheetUrl)) {
                scene.getStylesheets().add((Object)stylesheetUrl);
            }
            notifications.styleClass(new String[]{"custom"});
        }
        return notifications.owner((Object)stage);
    }
}

