/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateTextField<T>
extends HBox {
    private static final Logger logger = LoggerFactory.getLogger(PredicateTextField.class);
    private final ObjectProperty<Function<T, String>> stringFunction = new SimpleObjectProperty();
    private final TextField tfFilter = new TextField("");
    private final StringProperty filterText = this.tfFilter.textProperty();
    private final BooleanProperty useRegex = new SimpleBooleanProperty(false);
    private final BooleanProperty ignoreCase = new SimpleBooleanProperty(true);
    private final BooleanProperty showRegexButton = new SimpleBooleanProperty(true);
    private final ObjectBinding<Predicate<T>> predicate = this.createPredicateBinding(this.filterText);
    private ReadOnlyObjectWrapper<Predicate<T>> predicateWrapper = new ReadOnlyObjectWrapper();

    public PredicateTextField() {
        this(Objects::toString);
    }

    public PredicateTextField(Function<T, String> stringFunction) {
        this.stringFunction.set(stringFunction);
        this.initialize();
        this.predicateWrapper.bind(this.predicate);
    }

    private void initialize() {
        ToggleButton btnRegex = new ToggleButton(".*");
        btnRegex.setTooltip(new Tooltip("Use regular expressions"));
        btnRegex.selectedProperty().bindBidirectional((Property)this.useRegex);
        HBox.setHgrow((Node)this.tfFilter, (Priority)Priority.ALWAYS);
        this.tfFilter.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().add((Object)this.tfFilter);
        if (this.showRegexButton.get()) {
            this.getChildren().add((Object)btnRegex);
        }
        this.showRegexButton.addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.getChildren().add((Object)btnRegex);
            } else {
                this.getChildren().remove((Object)btnRegex);
            }
        });
    }

    public StringProperty textProperty() {
        return this.filterText;
    }

    public String getText() {
        return (String)this.filterText.get();
    }

    public void setText(String text) {
        this.filterText.set((Object)text);
    }

    public StringProperty promptTextProperty() {
        return this.tfFilter.promptTextProperty();
    }

    public String getPromptText() {
        return (String)this.promptTextProperty().get();
    }

    public void setPromptText(String text) {
        this.promptTextProperty().set((Object)text);
    }

    public BooleanProperty useRegexProperty() {
        return this.useRegex;
    }

    public void setUseRegex(boolean use) {
        this.useRegex.set(use);
    }

    public boolean getUseRegex() {
        return this.useRegex.get();
    }

    public BooleanProperty showRegexButtonProperty() {
        return this.showRegexButton;
    }

    public void setShowRegexButton(boolean show) {
        this.showRegexButton.set(show);
    }

    public boolean setShowRegexButton() {
        return this.showRegexButton.get();
    }

    public BooleanProperty ignoreCaseProperty() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase.set(ignoreCase);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase.get();
    }

    public ReadOnlyObjectProperty<Predicate<T>> predicateProperty() {
        return this.predicateWrapper.getReadOnlyProperty();
    }

    public Predicate<T> getPredicate() {
        return (Predicate)this.predicateWrapper.get();
    }

    public ObjectProperty<Function<T, String>> stringFunctionProperty() {
        return this.stringFunction;
    }

    public Function<T, String> getStringFunction() {
        return (Function)this.stringFunction.get();
    }

    public void setStringFunction(Function<T, String> stringFunction) {
        this.stringFunction.set(stringFunction);
    }

    private ObjectBinding<Predicate<T>> createPredicateBinding(StringProperty filterText) {
        return Bindings.createObjectBinding(() -> {
            if (this.useRegex.get()) {
                return PredicateTextField.createPredicateFromRegex((Function)this.stringFunction.get(), (String)filterText.get());
            }
            return PredicateTextField.createPredicateFromText((Function)this.stringFunction.get(), (String)filterText.get(), this.ignoreCase.get());
        }, (Observable[])new Observable[]{filterText, this.useRegex, this.ignoreCase, this.stringFunction});
    }

    private static <T> Predicate<T> createPredicateFromRegex(Function<T, String> stringFunction, String regex) {
        if (regex == null || regex.isBlank()) {
            return info -> true;
        }
        try {
            Pattern pattern = Pattern.compile(regex);
            return item -> PredicateTextField.checkItemAgainstRegex(stringFunction, item, pattern);
        }
        catch (PatternSyntaxException e) {
            logger.debug("Invalid regex: {} ({})", (Object)regex, (Object)e.getMessage());
            return item -> false;
        }
    }

    private static <T> boolean checkItemAgainstRegex(Function<T, String> stringFunction, T item, Pattern pattern) {
        return pattern.matcher(stringFunction.apply(item)).find();
    }

    private static <T> Predicate<T> createPredicateFromText(Function<T, String> stringFunction, String filterText, boolean ignoreCase) {
        if (filterText == null || filterText.isBlank()) {
            return item -> true;
        }
        if (ignoreCase) {
            String text = filterText.toLowerCase();
            return item -> ((String)stringFunction.apply(item)).toLowerCase().contains(text);
        }
        String text = filterText;
        return item -> ((String)stringFunction.apply(item)).contains(text);
    }
}

