/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.TextAlignment;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;

public class InputDisplay
implements EventHandler<InputEvent> {
    private static final Logger logger = LoggerFactory.getLogger(InputDisplay.class);
    private final Window owner;
    private final ObservableList<? extends Window> allWindows;
    private final BooleanProperty showProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty showCloseButton = new SimpleBooleanProperty(true);
    private Stage stage;
    private final FocusListener focusListener = new FocusListener();
    private final KeyFilter keyFilter = new KeyFilter();
    private final MouseFilter mouseFilter = new MouseFilter();
    private final ScrollFilter scrollFilter = new ScrollFilter();
    private static final String inputDisplayClass = "input-display-pane";
    private static final String closeItemClass = "close-item";
    private static final String mouseItemClass = "mouse-item";
    private static final PseudoClass pseudoClassActive = PseudoClass.getPseudoClass((String)"active");
    private final Set<KeyCode> MODIFIER_KEYS = Set.of(KeyCode.SHIFT, KeyCode.SHORTCUT, KeyCode.COMMAND, KeyCode.CONTROL, KeyCode.ALT, KeyCode.ALT_GRAPH);
    private final ObservableMap<String, String> modifiers = FXCollections.observableMap(new TreeMap());
    private final ObservableMap<String, String> keys = FXCollections.observableMap(new TreeMap());
    private final BooleanProperty primaryDown = new SimpleBooleanProperty(false);
    private final BooleanProperty secondaryDown = new SimpleBooleanProperty(false);
    private final BooleanProperty middleDown = new SimpleBooleanProperty(false);
    private final BooleanProperty scrollLeft = new SimpleBooleanProperty(false);
    private final BooleanProperty scrollRight = new SimpleBooleanProperty(false);
    private final BooleanProperty scrollUp = new SimpleBooleanProperty(false);
    private final BooleanProperty scrollDown = new SimpleBooleanProperty(false);

    public InputDisplay(Window owner) {
        this(owner, (ObservableList<? extends Window>)(owner == null ? Window.getWindows() : FXCollections.observableArrayList((Object[])new Window[]{owner})));
    }

    public InputDisplay(Window owner, ObservableList<? extends Window> windows) {
        Objects.requireNonNull(windows, "An observable list of windows must be specified!");
        this.owner = owner;
        this.allWindows = windows;
        this.showProperty.addListener((v, o, n) -> this.updateShowStatus((boolean)n));
        for (Window window : this.allWindows) {
            this.addListenersToWindow(window);
        }
        this.allWindows.addListener(this::handleWindowListChange);
    }

    private void handleWindowListChange(ListChangeListener.Change<? extends Window> change) {
        while (change.next()) {
            for (Window window : change.getRemoved()) {
                this.removeListenersFromWindow(window);
            }
            for (Window window : change.getAddedSubList()) {
                this.addListenersToWindow(window);
            }
        }
    }

    private void addListenersToWindow(Window window) {
        window.addEventFilter(InputEvent.ANY, (EventHandler)this);
        window.focusedProperty().addListener((ChangeListener)this.focusListener);
    }

    private void removeListenersFromWindow(Window window) {
        window.focusedProperty().removeListener((ChangeListener)this.focusListener);
        window.removeEventFilter(InputEvent.ANY, (EventHandler)this);
    }

    private void updateShowStatus(boolean doShow) {
        if (doShow) {
            if (this.stage == null) {
                this.stage = this.createStage();
                this.stage.initOwner(this.owner);
            }
            this.stage.setAlwaysOnTop(true);
            this.stage.show();
            this.stage.setOnCloseRequest(e -> this.showProperty.set(false));
        } else if (this.stage != null) {
            if (this.stage.isShowing()) {
                this.stage.hide();
            }
            this.stage.hide();
        }
    }

    private Stage createStage() {
        logger.trace("Creating stage for input display");
        double keyPaneWidth = 225.0;
        double mousePaneWidth = 120.0;
        double spacing = 5.0;
        AnchorPane pane = new AnchorPane();
        String stylesheetUrl = InputDisplay.class.getResource("/css/input-display.css").toExternalForm();
        pane.getStylesheets().add((Object)stylesheetUrl);
        pane.getStyleClass().add((Object)inputDisplayClass);
        Pane paneKeys = this.createKeyPane(keyPaneWidth);
        pane.getChildren().add((Object)paneKeys);
        AnchorPane.setTopAnchor((Node)paneKeys, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)paneKeys, (Double)0.0);
        Pane paneMouse = this.createMousePane(mousePaneWidth);
        pane.getChildren().add((Object)paneMouse);
        AnchorPane.setTopAnchor((Node)paneMouse, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)paneMouse, (Double)(keyPaneWidth + 5.0));
        SVGPath closeImage = new SVGPath();
        closeImage.setContent("M 0 0 L 8 8 M 8 0 L 0 8");
        closeImage.getStyleClass().add((Object)closeItemClass);
        BorderPane closeButton = new BorderPane((Node)closeImage);
        closeButton.setOnMouseEntered(e -> closeImage.pseudoClassStateChanged(pseudoClassActive, true));
        closeButton.setOnMouseExited(e -> closeImage.pseudoClassStateChanged(pseudoClassActive, false));
        closeButton.setOnMouseClicked(e -> this.showProperty.set(false));
        closeButton.setCursor(Cursor.DEFAULT);
        pane.getChildren().add((Object)closeButton);
        AnchorPane.setTopAnchor((Node)closeButton, (Double)7.0);
        AnchorPane.setLeftAnchor((Node)closeButton, (Double)7.0);
        closeButton.visibleProperty().bind((ObservableValue)this.showCloseButton);
        Screen screen = this.owner == null ? Screen.getPrimary() : FXUtils.getScreenOrPrimary(this.owner);
        Rectangle2D screenBounds = screen.getVisualBounds();
        double xPad = 10.0;
        double yPad = 10.0;
        this.stage = new Stage();
        this.stage.initStyle(StageStyle.TRANSPARENT);
        Scene scene = new Scene((Parent)pane, keyPaneWidth + mousePaneWidth + spacing, 160.0, (Paint)Color.TRANSPARENT);
        this.stage.setScene(scene);
        FXUtils.makeDraggableStage(this.stage);
        Tooltip tooltipClose = new Tooltip("Display input - double-click to close");
        Tooltip.install((Node)pane, (Tooltip)tooltipClose);
        this.stage.setX(screenBounds.getMinX() + xPad);
        this.stage.setY(screenBounds.getMaxY() - scene.getHeight() - yPad);
        this.stage.getScene().setOnMouseClicked(e -> {
            if (!this.showCloseButton.get() && e.getClickCount() == 2) {
                this.hide();
            }
        });
        return this.stage;
    }

    public BooleanProperty showProperty() {
        return this.showProperty;
    }

    public void show() {
        this.showProperty.set(true);
    }

    public void hide() {
        this.showProperty.set(false);
    }

    public void handle(InputEvent event) {
        if (!this.showProperty.get()) {
            return;
        }
        if (event instanceof KeyEvent) {
            this.keyFilter.handle((KeyEvent)event);
        } else if (event instanceof MouseEvent) {
            this.mouseFilter.handle((MouseEvent)event);
        } else if (event instanceof ScrollEvent) {
            this.scrollFilter.handle((ScrollEvent)event);
        }
    }

    void updateKeys(StringProperty textModifiers, StringProperty textKeys, StringProperty textHistory) {
        textModifiers.set((Object)String.join((CharSequence)" + ", this.modifiers.keySet()));
        textKeys.set((Object)String.join((CharSequence)" + ", this.keys.values()));
        ArrayList allKeys = new ArrayList();
        if (!this.keys.isEmpty()) {
            allKeys.addAll(this.modifiers.keySet());
            allKeys.addAll(this.keys.values());
            textHistory.set((Object)("Last shortcut:\n" + String.join((CharSequence)" + ", allKeys)));
        }
    }

    Pane createKeyPane(double width) {
        final Label labModifiers = new Label("");
        final Label labKeys = new Label("");
        final Label labHistory = new Label("");
        labModifiers.setPrefSize(width, 50.0);
        labKeys.setPrefSize(width, 50.0);
        labHistory.setPrefSize(width, 50.0);
        labModifiers.setAlignment(Pos.CENTER);
        labKeys.setAlignment(Pos.CENTER);
        labHistory.setAlignment(Pos.CENTER);
        labHistory.setTextAlignment(TextAlignment.CENTER);
        labModifiers.getStyleClass().add((Object)"modifiers");
        labKeys.getStyleClass().add((Object)"keys");
        labHistory.getStyleClass().add((Object)"history");
        InvalidationListener keyUpdater = new InvalidationListener(){

            public void invalidated(Observable observable) {
                InputDisplay.this.updateKeys(labModifiers.textProperty(), labKeys.textProperty(), labHistory.textProperty());
            }
        };
        this.modifiers.addListener(keyUpdater);
        this.keys.addListener(keyUpdater);
        GridPane paneKeys = new GridPane();
        paneKeys.add((Node)labModifiers, 0, 0);
        paneKeys.add((Node)labKeys, 0, 1);
        paneKeys.add((Node)labHistory, 0, 2);
        return paneKeys;
    }

    Pane createMousePane(double width) {
        AnchorPane pane = new AnchorPane();
        Rectangle rectPrimary = this.createButtonRectangle(25.0, 40.0);
        Rectangle rectSecondary = this.createButtonRectangle(25.0, 40.0);
        Rectangle rectMiddle = this.createButtonRectangle(8.0, 18.0);
        double gap = 5.0;
        rectMiddle.setTranslateX(rectPrimary.getWidth() + gap / 2.0 - rectMiddle.getWidth() / 2.0);
        rectSecondary.setTranslateX(rectPrimary.getWidth() + gap);
        rectMiddle.setStrokeWidth(8.0);
        rectMiddle.setStroke((Paint)Color.WHITE);
        rectMiddle.setTranslateY((rectPrimary.getHeight() - rectMiddle.getHeight()) / 2.0);
        Shape shapePrimary = Shape.subtract((Shape)rectPrimary, (Shape)rectMiddle);
        shapePrimary.getStyleClass().setAll((Collection)rectPrimary.getStyleClass());
        Shape shapeSecondary = Shape.subtract((Shape)rectSecondary, (Shape)rectMiddle);
        shapeSecondary.getStyleClass().setAll((Collection)rectSecondary.getStyleClass());
        rectMiddle.setStroke(null);
        rectMiddle.setStrokeWidth(2.0);
        this.primaryDown.addListener((v, o, n) -> shapePrimary.pseudoClassStateChanged(pseudoClassActive, n.booleanValue()));
        this.secondaryDown.addListener((v, o, n) -> shapeSecondary.pseudoClassStateChanged(pseudoClassActive, n.booleanValue()));
        this.middleDown.addListener((v, o, n) -> rectMiddle.pseudoClassStateChanged(pseudoClassActive, n.booleanValue()));
        Group group = new Group();
        group.getChildren().addAll((Object[])new Node[]{shapePrimary, shapeSecondary, rectMiddle});
        double arrowBase = 32.0;
        double arrowHeight = arrowBase / 2.0;
        Polygon arrowUp = this.createArrow(arrowBase, arrowHeight, 0.0);
        Polygon arrowDown = this.createArrow(arrowBase, arrowHeight, 180.0);
        Polygon arrowLeft = this.createArrow(arrowBase, arrowHeight, -90.0);
        Polygon arrowRight = this.createArrow(arrowBase, arrowHeight, 90.0);
        this.scrollUp.addListener((v, o, n) -> arrowUp.pseudoClassStateChanged(pseudoClassActive, n.booleanValue()));
        this.scrollDown.addListener((v, o, n) -> arrowDown.pseudoClassStateChanged(pseudoClassActive, n.booleanValue()));
        this.scrollLeft.addListener((v, o, n) -> arrowLeft.pseudoClassStateChanged(pseudoClassActive, n.booleanValue()));
        this.scrollRight.addListener((v, o, n) -> arrowRight.pseudoClassStateChanged(pseudoClassActive, n.booleanValue()));
        pane.getChildren().addAll((Object[])new Node[]{group, arrowUp, arrowDown, arrowLeft, arrowRight});
        AnchorPane.setTopAnchor((Node)group, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)group, (Double)(width / 2.0 - group.getBoundsInLocal().getWidth() / 2.0));
        double y = rectPrimary.getHeight() + 30.0;
        AnchorPane.setTopAnchor((Node)arrowUp, (Double)y);
        AnchorPane.setTopAnchor((Node)arrowDown, (Double)(y + 60.0));
        AnchorPane.setTopAnchor((Node)arrowLeft, (Double)(y + 30.0));
        AnchorPane.setTopAnchor((Node)arrowRight, (Double)(y + 30.0));
        AnchorPane.setLeftAnchor((Node)arrowUp, (Double)(width / 2.0 - arrowBase / 2.0));
        AnchorPane.setLeftAnchor((Node)arrowDown, (Double)(width / 2.0 - arrowBase / 2.0));
        AnchorPane.setLeftAnchor((Node)arrowLeft, (Double)(width / 2.0 - arrowBase / 2.0 - arrowBase));
        AnchorPane.setLeftAnchor((Node)arrowRight, (Double)(width / 2.0 + arrowBase / 2.0));
        return pane;
    }

    Rectangle createButtonRectangle(double width, double height) {
        Rectangle rect = new Rectangle(width, height);
        rect.setArcHeight(8.0);
        rect.setArcWidth(8.0);
        rect.setStrokeWidth(2.0);
        rect.getStyleClass().add((Object)mouseItemClass);
        return rect;
    }

    Polygon createArrow(double arrowBase, double arrowHeight, double rotate) {
        Polygon arrow = new Polygon(new double[]{-arrowBase / 2.0, arrowHeight / 2.0, 0.0, -arrowHeight / 2.0, arrowBase / 2.0, arrowHeight / 2.0});
        arrow.setStrokeWidth(2.0);
        arrow.setRotate(rotate);
        arrow.getStyleClass().add((Object)mouseItemClass);
        return arrow;
    }

    static String getTextForEvent(KeyEvent event) {
        String text = event.getText();
        if (event.getCode().isLetterKey()) {
            return text.toUpperCase();
        }
        if (text.trim().isEmpty()) {
            return event.getCode().getName();
        }
        return text;
    }

    class FocusListener
    implements ChangeListener<Boolean> {
        FocusListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!InputDisplay.this.showProperty.get()) {
                return;
            }
            if (newValue.booleanValue()) {
                InputDisplay.this.modifiers.clear();
                InputDisplay.this.keys.clear();
            } else {
                InputDisplay.this.primaryDown.set(false);
                InputDisplay.this.secondaryDown.set(false);
                InputDisplay.this.middleDown.set(false);
                InputDisplay.this.scrollLeft.set(false);
                InputDisplay.this.scrollRight.set(false);
                InputDisplay.this.scrollUp.set(false);
                InputDisplay.this.scrollDown.set(false);
            }
        }
    }

    class KeyFilter
    implements EventHandler<KeyEvent> {
        KeyFilter() {
        }

        public void handle(KeyEvent event) {
            ObservableMap<String, String> set;
            ObservableMap<String, String> observableMap = set = InputDisplay.this.MODIFIER_KEYS.contains(event.getCode()) ? InputDisplay.this.modifiers : InputDisplay.this.keys;
            if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                if (event.getCode() != null) {
                    set.put((Object)event.getCode().getName(), (Object)InputDisplay.getTextForEvent(event));
                }
            } else if (event.getEventType() == KeyEvent.KEY_RELEASED) {
                set.remove((Object)event.getCode().getName());
            }
        }
    }

    class MouseFilter
    implements EventHandler<MouseEvent> {
        MouseFilter() {
        }

        public void handle(MouseEvent event) {
            EventType type = event.getEventType();
            if (type == MouseEvent.MOUSE_PRESSED) {
                if (event.getButton() == MouseButton.PRIMARY) {
                    InputDisplay.this.primaryDown.set(true);
                } else if (event.getButton() == MouseButton.SECONDARY) {
                    InputDisplay.this.secondaryDown.set(true);
                } else if (event.getButton() == MouseButton.MIDDLE) {
                    InputDisplay.this.middleDown.set(true);
                }
            } else if (type == MouseEvent.MOUSE_RELEASED) {
                if (event.getButton() == MouseButton.PRIMARY) {
                    InputDisplay.this.primaryDown.set(false);
                } else if (event.getButton() == MouseButton.SECONDARY) {
                    InputDisplay.this.secondaryDown.set(false);
                } else if (event.getButton() == MouseButton.MIDDLE) {
                    InputDisplay.this.middleDown.set(false);
                }
            }
        }
    }

    class ScrollFilter
    implements EventHandler<ScrollEvent> {
        ScrollFilter() {
        }

        public void handle(ScrollEvent event) {
            EventType type = event.getEventType();
            if (type == ScrollEvent.SCROLL_STARTED || type == ScrollEvent.SCROLL) {
                if (event.isInertia()) {
                    InputDisplay.this.scrollUp.set(false);
                    InputDisplay.this.scrollDown.set(false);
                    InputDisplay.this.scrollLeft.set(false);
                    InputDisplay.this.scrollRight.set(false);
                    return;
                }
                boolean invertScrolling = false;
                double direction = invertScrolling ? -1.0 : 1.0;
                InputDisplay.this.scrollUp.set(event.getDeltaY() * direction < -0.001);
                InputDisplay.this.scrollDown.set(event.getDeltaY() * direction > 0.001);
                InputDisplay.this.scrollLeft.set(event.getDeltaX() * direction < -0.001);
                InputDisplay.this.scrollRight.set(event.getDeltaX() * direction > 0.001);
            } else if (type == ScrollEvent.SCROLL_FINISHED) {
                InputDisplay.this.scrollUp.set(false);
                InputDisplay.this.scrollDown.set(false);
                InputDisplay.this.scrollLeft.set(false);
                InputDisplay.this.scrollRight.set(false);
            }
        }
    }
}

