/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.shape.Circle;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.localization.LocalizedResourceManager;

public class CircularSlider
extends Control {
    private static final LocalizedResourceManager resources = LocalizedResourceManager.createInstance("qupath.fx.localization.strings");
    private static final int MAX_DISPLAYED_VALUE = 360;
    private static final int MIN_DISPLAYED_VALUE = 0;
    private final DoubleProperty rotationProperty = new SimpleDoubleProperty(0.0);
    private final BooleanProperty snapEnabled = new SimpleBooleanProperty(false);
    private final DoubleProperty tickSpacing = new SimpleDoubleProperty(10.0);
    private final Circle outerCircle = new Circle();
    private final Circle innerCircle = new Circle(5.0);
    private final Circle textCircle = new Circle();
    private final Path tickMarks = new Path();
    private final Text angle = new Text("0.0\u00b0");

    public CircularSlider() {
        this.getChildren().addAll((Object[])new Node[]{this.outerCircle, this.textCircle, this.tickMarks, this.innerCircle, this.angle});
        this.setFocusTraversable(true);
        this.disabledProperty().addListener(e -> this.setMouseTransparent(!this.isDisabled()));
        this.innerCircle.setManaged(false);
        this.outerCircle.setManaged(false);
        this.textCircle.setManaged(false);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/css/circular-slider.css").toExternalForm());
        this.getStyleClass().setAll((Object[])new String[]{"circular-slider"});
        this.outerCircle.getStyleClass().setAll((Object[])new String[]{"circular-slider-outer"});
        this.innerCircle.getStyleClass().setAll((Object[])new String[]{"circular-slider-inner"});
        this.textCircle.getStyleClass().setAll((Object[])new String[]{"circular-slider-text-area"});
        this.angle.setFont(new Font(18.0));
        this.angle.getStyleClass().setAll((Object[])new String[]{"circular-slider-text"});
        this.tickMarks.getStyleClass().setAll((Object[])new String[]{"circular-slider-track-mark"});
        this.innerCircle.setMouseTransparent(true);
        this.angle.setMouseTransparent(true);
        this.textCircle.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                e.consume();
                Double rotation = e.isShiftDown() ? Double.valueOf(0.0) : Dialogs.showInputDialog(resources.getString("CircularSlider.inputTitle"), resources.getString("CircularSlider.inputPrompt"), this.getValue());
                if (rotation != null && Double.isFinite(rotation)) {
                    this.setValue(rotation);
                }
            }
        });
        this.tickMarks.setVisible(false);
        this.outerCircle.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::updateRotationWithMouseEvent);
        this.outerCircle.addEventHandler(MouseEvent.MOUSE_CLICKED, this::updateRotationWithMouseEvent);
        this.outerCircle.addEventHandler(ScrollEvent.ANY, e -> this.setValue(this.getValue() + (e.isShiftDown() ? e.getDeltaX() : e.getDeltaY()) * (this.isSnapToTicks() ? this.getTickSpacing() : 1.0)));
        this.outerCircle.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        this.addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyPressed);
        this.rotationProperty.addListener((observable, oldValue, newValue) -> this.checkRotation());
        this.tickSpacing.addListener((observable, oldValue, newValue) -> {
            if (oldValue.doubleValue() == newValue.doubleValue()) {
                return;
            }
            this.updateSnapMarks();
        });
        this.setPrefSize(200.0, 200.0);
    }

    public DoubleProperty rotationProperty() {
        return this.rotationProperty;
    }

    public Node getTextArea() {
        return this.textCircle;
    }

    public double getValue() {
        return Math.toDegrees(this.rotationProperty.get());
    }

    public void setValue(double rotation) {
        this.rotationProperty.set(Math.toRadians(rotation));
    }

    public boolean isSnapToTicks() {
        return this.snapEnabled.get();
    }

    public void setTickSpacing(double spacing) {
        this.tickSpacing.set(spacing);
    }

    public void setSnapToTicks(boolean enabled) {
        this.snapEnabled.set(enabled);
    }

    public void setShowTickMarks(boolean visible) {
        this.tickMarks.setVisible(visible);
    }

    public void setShowValue(boolean visible) {
        this.angle.setVisible(visible);
    }

    public double getTickSpacing() {
        return this.tickSpacing.get();
    }

    private void updateSnapMarks() {
        this.tickMarks.getElements().clear();
        double radians = Math.toRadians(this.tickSpacing.get());
        for (double i = 0.0; i < Math.PI * 2; i += radians) {
            double x = Math.sin(i);
            double y = -Math.cos(i);
            double x0 = this.outerCircle.getCenterX() + (this.outerCircle.getRadius() - this.innerCircle.getRadius() - 2.0) * x;
            double y0 = this.outerCircle.getCenterY() + (this.outerCircle.getRadius() - this.innerCircle.getRadius() - 2.0) * y;
            double x1 = this.outerCircle.getCenterX() + (this.outerCircle.getRadius() - this.innerCircle.getRadius() - this.innerCircle.getRadius()) * x;
            double y1 = this.outerCircle.getCenterY() + (this.outerCircle.getRadius() - this.innerCircle.getRadius() - this.innerCircle.getRadius()) * y;
            this.tickMarks.getElements().addAll((Object[])new PathElement[]{new MoveTo(x0, y0), new LineTo(x1, y1)});
        }
    }

    private void updateRotationWithMouseEvent(MouseEvent e) {
        double y;
        double dot;
        double length;
        if (this.isDisabled()) {
            return;
        }
        double x = e.getX() - this.outerCircle.getCenterX();
        double angle = Math.atan2(x / (length = Math.sqrt(dot = x * x + (y = e.getY() - this.outerCircle.getCenterY()) * y)), -y / length);
        this.rotationProperty.set(angle >= 0.0 ? angle : Math.PI * 2 + angle);
    }

    private void checkRotation() {
        if (this.getValue() < 0.0) {
            this.setValue(360.0 + this.getValue() % 360.0);
        }
        if (this.getValue() >= 360.0) {
            this.setValue(this.getValue() % 360.0);
        }
        if (this.isSnapToTicks()) {
            double halfSnap = this.tickSpacing.get() * 0.5;
            if (this.getValue() < halfSnap || this.getValue() > 360.0 - halfSnap) {
                this.setValue(0.0);
            } else {
                this.setValue(this.tickSpacing.get() * (double)Math.round(this.getValue() / this.tickSpacing.get()));
            }
            this.setValue(this.tickSpacing.get() * (double)Math.round(this.getValue() / this.tickSpacing.get()));
        }
        this.updateTextAndInnerCircle();
    }

    private void updateTextAndInnerCircle() {
        this.angle.setText(String.format("%.1f\u00b0", this.getValue()));
        double radians = this.rotationProperty.get();
        double vecX = Math.sin(radians);
        double vecY = -Math.cos(radians);
        double x = this.outerCircle.getCenterX() + (this.outerCircle.getRadius() - this.innerCircle.getRadius() - 5.0) * vecX;
        double y = this.outerCircle.getCenterY() + (this.outerCircle.getRadius() - this.innerCircle.getRadius() - 5.0) * vecY;
        this.innerCircle.setCenterX(x);
        this.innerCircle.setCenterY(y);
        this.textCircle.setCenterX(this.outerCircle.getCenterX());
        this.textCircle.setCenterY(this.outerCircle.getCenterY());
    }

    protected Skin<?> createDefaultSkin() {
        return new CircularSliderSkin(this);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.outerCircle.setRadius(Math.min(this.getWidth(), this.getHeight()) * 0.5 - 5.0);
        this.textCircle.setRadius(this.outerCircle.getRadius() * 0.8 - 2.0);
        this.outerCircle.setCenterX(this.getWidth() * 0.5);
        this.outerCircle.setCenterY(this.getHeight() * 0.5);
        this.innerCircle.setRadius(this.outerCircle.getRadius() * 0.05);
        this.updateTextAndInnerCircle();
        this.updateSnapMarks();
    }

    private void onMousePressed(MouseEvent e) {
        double x = e.getX() - this.outerCircle.getCenterX();
        double y = e.getY() - this.outerCircle.getCenterY();
        if (!this.focusedProperty().get() && x * x + y * y <= this.outerCircle.getRadius() * this.outerCircle.getRadius()) {
            this.requestFocus();
        }
    }

    private void onKeyPressed(KeyEvent e) {
        switch (e.getCode()) {
            case LEFT: {
                this.setValue(this.getValue() - (this.isSnapToTicks() ? this.getTickSpacing() : 1.0));
                break;
            }
            case RIGHT: {
                this.setValue(this.getValue() + (this.isSnapToTicks() ? this.getTickSpacing() : 1.0));
                break;
            }
        }
    }

    private static final class CircularSliderSkin
    extends SkinBase<CircularSlider> {
        protected CircularSliderSkin(CircularSlider control) {
            super((Control)control);
        }
    }
}

