/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

class ToolUtils {
    ToolUtils() {
    }

    static boolean tryToSelect(QuPathViewer viewer, double x, double y, int searchCount, boolean addToSelection) {
        return ToolUtils.tryToSelect(viewer, x, y, searchCount, addToSelection, false);
    }

    static boolean tryToSelect(QuPathViewer viewer, double x, double y, int searchCount, boolean addToSelection, boolean toggleSelection) {
        PathObjectHierarchy hierarchy;
        PathObjectHierarchy pathObjectHierarchy = hierarchy = viewer == null ? null : viewer.getHierarchy();
        if (hierarchy == null) {
            return false;
        }
        PathObject pathObject = ToolUtils.getSelectableObject(viewer, x, y, searchCount);
        if (toggleSelection && hierarchy.getSelectionModel().getSelectedObject() == pathObject) {
            hierarchy.getSelectionModel().deselectObject(pathObject);
        } else {
            viewer.setSelectedObject(pathObject, addToSelection);
        }
        if (pathObject == null && addToSelection) {
            viewer.setSelectedObject(null);
        }
        return pathObject != null;
    }

    static PathObject getSelectableObject(QuPathViewer viewer, double x, double y, int searchCount) {
        List<PathObject> pathObjectList = ToolUtils.getSelectableObjectList(viewer, x, y);
        if (pathObjectList == null || pathObjectList.isEmpty()) {
            return null;
        }
        int ind = searchCount % pathObjectList.size();
        return pathObjectList.get(ind);
    }

    static List<PathObject> getSelectableObjectList(QuPathViewer viewer, double x, double y) {
        PathObjectHierarchy hierarchy;
        PathObjectHierarchy pathObjectHierarchy = hierarchy = viewer == null ? null : viewer.getHierarchy();
        if (hierarchy == null) {
            return Collections.emptyList();
        }
        double vertexTolerance = Math.max((double)PathPrefs.pointRadiusProperty().get() * viewer.getDownsampleFactor(), viewer.getMaxROIHandleSize());
        Collection pathObjects = PathObjectTools.getObjectsForLocation((PathObjectHierarchy)hierarchy, (double)x, (double)y, (int)viewer.getZPosition(), (int)viewer.getTPosition(), (double)vertexTolerance);
        if (pathObjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PathObject> pathObjectList = new ArrayList<PathObject>(pathObjects);
        if (pathObjectList.size() == 1) {
            return pathObjectList;
        }
        Collections.sort(pathObjectList, PathObjectHierarchy.HIERARCHY_COMPARATOR);
        return pathObjectList;
    }
}

