/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.viewer.tools.handlers;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import qupath.lib.geom.Point2;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.tools.handlers.AbstractPathToolEventHandler;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathROIObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiEditor;
import qupath.lib.roi.interfaces.ROI;

class PointsToolEventHandler
extends AbstractPathToolEventHandler {
    PointsToolEventHandler() {
    }

    private PointsROI getCurrentPoints() {
        QuPathViewer viewer = this.getViewer();
        PathObject currentObject = viewer.getSelectedObject();
        if (currentObject == null) {
            return null;
        }
        return currentObject.getROI() instanceof PointsROI ? (PointsROI)currentObject.getROI() : null;
    }

    @Override
    protected boolean requestPixelSnapping() {
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.getButton() != MouseButton.PRIMARY || e.isConsumed()) {
            return;
        }
        PointsROI points = this.getCurrentPoints();
        if (points == null) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        RoiEditor editor = viewer.getROIEditor();
        editor.resetActiveHandle();
        PathObject currentObject = viewer.getSelectedObject();
        viewer.getHierarchy().updateObject(currentObject, false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (!e.isPrimaryButtonDown() || e.isConsumed()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        RoiEditor editor = viewer.getROIEditor();
        if (!(editor.getROI() instanceof PointsROI) || !editor.hasActiveHandle()) {
            return;
        }
        PointsROI points = this.getCurrentPoints();
        Point2D pAdjusting = this.mouseLocationToImage(e, true, this.requestPixelSnapping());
        PointsROI points2 = (PointsROI)editor.setActiveHandlePosition(pAdjusting.getX(), pAdjusting.getY(), 0.25, e.isShiftDown());
        if (points2 == points) {
            return;
        }
        PathROIObject currentObject = (PathROIObject)viewer.getSelectedObject();
        currentObject.setROI((ROI)points2);
        viewer.repaint();
    }

    private ROI removeNearbyPoint(PointsROI points, double x, double y, double distance) {
        if (points == null) {
            return points;
        }
        Point2 p = points.getNearest(x, y, distance);
        return this.removePoint((ROI)points, p);
    }

    private boolean handleAltClick(QuPathViewer viewer, double x, double y, PathObject currentObject) {
        ROI points2;
        PointsROI points;
        ImagePlane viewerPlane = viewer.getImagePlane();
        PathObjectHierarchy hierarchy = viewer.getHierarchy();
        double distance = PathPrefs.pointRadiusProperty().get();
        if (currentObject != null && !currentObject.isLocked() && PathObjectTools.hasPointROI((PathObject)currentObject) && (points = (PointsROI)currentObject.getROI()).getImagePlane().equals((Object)viewerPlane) && points != (points2 = this.removeNearbyPoint(points, x, y, distance))) {
            ((PathROIObject)currentObject).setROI(points2);
            hierarchy.updateObject(currentObject, false);
            return true;
        }
        boolean currentIsValid = false;
        for (PathObject pathObject : hierarchy.getAllPointObjects()) {
            if (!pathObject.getROI().getImagePlane().equals((Object)viewerPlane) || ((PointsROI)pathObject.getROI()).getNearest(x, y, distance) == null) continue;
            if (pathObject == currentObject) {
                currentIsValid = true;
                continue;
            }
            viewer.setSelectedObject(pathObject);
            return true;
        }
        if (!currentIsValid) {
            viewer.setSelectedObject(null);
        }
        return true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ROI currentROI;
        super.mousePressed(e);
        if (!e.isPrimaryButtonDown() || e.isConsumed()) {
            return;
        }
        QuPathViewer viewer = this.getViewer();
        ImageServer<BufferedImage> server = viewer.getServer();
        if (server == null) {
            return;
        }
        ImagePlane viewerPlane = viewer.getImagePlane();
        Point2D p = this.mouseLocationToImage(e, false, this.requestPixelSnapping());
        double xx = p.getX();
        double yy = p.getY();
        if (xx < 0.0 || yy < 0.0 || xx >= (double)server.getWidth() || yy >= (double)server.getHeight()) {
            return;
        }
        PathObject currentObjectTemp = viewer.getSelectedObject();
        if (currentObjectTemp != null && !(currentObjectTemp instanceof PathROIObject)) {
            return;
        }
        PathROIObject currentObject = (PathROIObject)currentObjectTemp;
        ROI rOI = currentROI = currentObject == null ? null : currentObject.getROI();
        boolean currentUnlocked = currentObject == null ? false : !currentObject.isLocked();
        RoiEditor editor = viewer.getROIEditor();
        double radius = PathPrefs.pointRadiusProperty().get();
        ROI points = null;
        if (currentROI != null && currentROI.isPoint() && (currentROI.isEmpty() || currentROI.getImagePlane().equals((Object)viewerPlane))) {
            points = currentROI;
        }
        if (e.isAltDown()) {
            this.handleAltClick(viewer, xx, yy, (PathObject)currentObject);
        } else if (points == null || !currentUnlocked || !PathPrefs.multipointToolProperty().get() && !editor.grabHandle(xx, yy, radius, e.isShiftDown()) || e.isShiftDown() && e.getClickCount() > 1) {
            points = ROIs.createPointsROI((double)xx, (double)yy, (ImagePlane)viewerPlane);
            currentObject = (PathROIObject)PathObjects.createAnnotationObject((ROI)points, (PathClass)((PathClass)PathPrefs.autoSetAnnotationClassProperty().get()));
            viewer.getHierarchy().addObject((PathObject)currentObject);
            viewer.setSelectedObject((PathObject)currentObject);
            editor.setROI(points);
            editor.grabHandle(xx, yy, radius, e.isShiftDown());
        } else if (points != null) {
            ImagePlane plane = points == null || points.isEmpty() ? viewerPlane : points.getImagePlane();
            ROI points2 = this.addPoint(points, xx, yy, radius, plane);
            if (points2 == points) {
                if (!editor.grabHandle(xx, yy, radius, e.isShiftDown())) {
                    return;
                }
                points2 = (PointsROI)editor.setActiveHandlePosition(xx, yy, 0.25, e.isShiftDown());
            } else {
                editor.setROI(points2);
                editor.grabHandle(xx, yy, radius, e.isShiftDown());
            }
            if (points2 != points) {
                currentObject.setROI(points2);
                viewer.getHierarchy().updateObject((PathObject)currentObject, true);
            }
        }
        viewer.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.ensureCursorType(Cursor.CROSSHAIR);
    }

    private ROI addPoint(ROI points, double x, double y, double minimumSeparation, ImagePlane plane) {
        if (Double.isNaN(x + y)) {
            return points;
        }
        List pointsList = points.getAllPoints();
        if (minimumSeparation > 0.0) {
            double threshold = minimumSeparation * minimumSeparation;
            for (Point2 p : pointsList) {
                if (!(p.distanceSq(x, y) < threshold)) continue;
                return points;
            }
        }
        ArrayList<Point2> pointsList2 = new ArrayList<Point2>(pointsList);
        pointsList2.add(new Point2(x, y));
        return ROIs.createPointsROI(pointsList2, (ImagePlane)plane);
    }

    private ROI removePoint(ROI points, Point2 point) {
        if (point == null) {
            return points;
        }
        ArrayList pointsList = new ArrayList(points.getAllPoints());
        if (pointsList.remove(point)) {
            return ROIs.createPointsROI(pointsList, (ImagePlane)ImagePlane.getPlaneWithChannel((int)points.getC(), (int)points.getZ(), (int)points.getT()));
        }
        return points;
    }
}

